/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFence;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockWallBase;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Position;
import cn.nukkit.level.Sound;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.RedstoneComponent;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitDifference(info="Implements RedstoneComponent and uses methods from it.", since="1.4.0.0-PN")
public class BlockLever
extends BlockFlowable
implements RedstoneComponent,
Faceable {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final ArrayBlockProperty<LeverOrientation> LEVER_DIRECTION = new ArrayBlockProperty("lever_direction", false, (Serializable[])LeverOrientation.values(), 3, "lever_direction", false, new String[]{"down_east_west", "east", "west", "south", "north", "up_north_south", "up_east_west", "down_north_south"});
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(LEVER_DIRECTION, CommonBlockProperties.OPEN);

    public BlockLever() {
        this(0);
    }

    public BlockLever(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Lever";
    }

    @Override
    public int getId() {
        return 69;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this, (Integer)0);
    }

    public boolean isPowerOn() {
        return this.getBooleanValue(CommonBlockProperties.OPEN);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-P`N")
    public void setPowerOn(boolean powerOn) {
        this.setBooleanValue(CommonBlockProperties.OPEN, powerOn);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-P`N")
    public LeverOrientation getLeverOrientation() {
        return this.getPropertyValue(LEVER_DIRECTION);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-P`N")
    public void setLeverOrientation(@Nullable LeverOrientation value) {
        this.setPropertyValue(LEVER_DIRECTION, value);
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, this.isPowerOn() ? 15 : 0, this.isPowerOn() ? 0 : 15));
        this.toggleBooleanProperty(CommonBlockProperties.OPEN);
        this.getLevel().setBlock((Vector3)this, this, false, true);
        this.getLevel().addSound(this, Sound.RANDOM_CLICK, 0.8f, this.isPowerOn() ? 0.58f : 0.5f);
        LeverOrientation orientation = this.getLeverOrientation();
        BlockFace face = orientation.getFacing();
        if (this.level.getServer().isRedstoneEnabled()) {
            this.updateAroundRedstone(new BlockFace[0]);
            RedstoneComponent.updateAroundRedstone((Position)this.getSide(face.getOpposite()), face);
        }
        return true;
    }

    @Override
    @PowerNukkitDifference(info="Now, can be placed on solid blocks", since="1.4.0.0-PN")
    public int onUpdate(int type) {
        BlockFace blockFace;
        Block side;
        if (type == 1 && !BlockLever.isSupportValid(side = this.getSide(blockFace = this.getLeverOrientation().getFacing().getOpposite()), blockFace.getOpposite())) {
            this.level.useBreakOn(this);
        }
        return 0;
    }

    @Override
    @PowerNukkitDifference.DifferenceList(value={@PowerNukkitDifference(info="Allows to be placed on walls", since="1.3.0.0-PN"), @PowerNukkitDifference(info="Now, can be placed on solid blocks and always returns false if the placement fails", since="1.4.0.0-PN")})
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (target.canBeReplaced()) {
            target = target.down();
            face = BlockFace.UP;
        }
        if (!BlockLever.isSupportValid(target, face)) {
            return false;
        }
        this.setLeverOrientation(LeverOrientation.forFacings(face, player.getHorizontalFacing()));
        return this.getLevel().setBlock((Vector3)block, this, true, true);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static boolean isSupportValid(Block support, BlockFace face) {
        switch (support.getId()) {
            case 60: 
            case 198: {
                return true;
            }
        }
        if (face == BlockFace.DOWN) {
            return support.isSolid(BlockFace.DOWN) && (support.isFullBlock() || !support.isTransparent());
        }
        if (support.isSolid(face)) {
            return true;
        }
        if (support instanceof BlockWallBase || support instanceof BlockFence) {
            return face == BlockFace.UP;
        }
        return false;
    }

    @Override
    @PowerNukkitDifference(info="Update redstone", since="1.4.0.0-PN")
    public boolean onBreak(Item item) {
        this.getLevel().setBlock((Vector3)this, Block.get(0), true, true);
        if (this.isPowerOn()) {
            BlockFace face = this.getLeverOrientation().getFacing();
            this.level.updateAround(this.getLocation().getSide(face.getOpposite()));
            if (this.level.getServer().isRedstoneEnabled()) {
                this.updateAroundRedstone(new BlockFace[0]);
                RedstoneComponent.updateAroundRedstone((Position)this.getSide(face.getOpposite()), face);
            }
        }
        return true;
    }

    @Override
    public int getWeakPower(BlockFace side) {
        return this.isPowerOn() ? 15 : 0;
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return !this.isPowerOn() ? 0 : (this.getLeverOrientation().getFacing() == side ? 15 : 0);
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 2;
    }

    @Override
    public boolean canBeFlowedInto() {
        return false;
    }

    @Override
    @PowerNukkitDifference(info="Fixed the directions", since="1.3.0.0-PN")
    public BlockFace getBlockFace() {
        return this.getLeverOrientation().getFacing();
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    public static enum LeverOrientation {
        DOWN_X(0, "down_x", BlockFace.DOWN),
        EAST(1, "east", BlockFace.EAST),
        WEST(2, "west", BlockFace.WEST),
        SOUTH(3, "south", BlockFace.SOUTH),
        NORTH(4, "north", BlockFace.NORTH),
        UP_Z(5, "up_z", BlockFace.UP),
        UP_X(6, "up_x", BlockFace.UP),
        DOWN_Z(7, "down_z", BlockFace.DOWN);

        private static final LeverOrientation[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final BlockFace facing;

        private LeverOrientation(int meta, String name, BlockFace face) {
            this.meta = meta;
            this.name = name;
            this.facing = face;
        }

        public int getMetadata() {
            return this.meta;
        }

        public BlockFace getFacing() {
            return this.facing;
        }

        public String toString() {
            return this.name;
        }

        public static LeverOrientation byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public static LeverOrientation forFacings(BlockFace clickedSide, BlockFace playerDirection) {
            switch (clickedSide) {
                case DOWN: {
                    switch (playerDirection.getAxis()) {
                        case X: {
                            return DOWN_X;
                        }
                        case Z: {
                            return DOWN_Z;
                        }
                    }
                    throw new IllegalArgumentException("Invalid entityFacing " + (Object)((Object)playerDirection) + " for facing " + (Object)((Object)clickedSide));
                }
                case UP: {
                    switch (playerDirection.getAxis()) {
                        case X: {
                            return UP_X;
                        }
                        case Z: {
                            return UP_Z;
                        }
                    }
                    throw new IllegalArgumentException("Invalid entityFacing " + (Object)((Object)playerDirection) + " for facing " + (Object)((Object)clickedSide));
                }
                case NORTH: {
                    return NORTH;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case WEST: {
                    return WEST;
                }
                case EAST: {
                    return EAST;
                }
            }
            throw new IllegalArgumentException("Invalid facing: " + (Object)((Object)clickedSide));
        }

        public String getName() {
            return this.name;
        }

        static {
            META_LOOKUP = new LeverOrientation[LeverOrientation.values().length];
            LeverOrientation[] leverOrientationArray = LeverOrientation.values();
            int n = leverOrientationArray.length;
            for (int i = 0; i < n; ++i) {
                LeverOrientation face;
                LeverOrientation.META_LOOKUP[face.getMetadata()] = face = leverOrientationArray[i];
            }
        }
    }
}

