/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.blockentity.BlockEntityMusic;
import cn.nukkit.event.player.PlayerInteractEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Sound;
import cn.nukkit.math.BlockFace;
import cn.nukkit.network.protocol.BlockEventPacket;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.RedstoneComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitDifference.DifferenceList(value={@PowerNukkitDifference(info="Implements RedstoneComponent.", since="1.4.0.0-PN"), @PowerNukkitDifference(since="1.4.0.0-PN", info="Implements BlockEntityHolder only in PowerNukkit")})
public class BlockNoteblock
extends BlockSolid
implements RedstoneComponent,
BlockEntityHolder<BlockEntityMusic> {
    @Override
    public String getName() {
        return "Note Block";
    }

    @Override
    public int getId() {
        return 25;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityMusic> getBlockEntityClass() {
        return BlockEntityMusic.class;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "Music";
    }

    @Override
    public double getHardness() {
        return 0.8;
    }

    @Override
    public double getResistance() {
        return 4.0;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        return BlockEntityHolder.setBlockAndCreateEntity(this) != null;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int onTouch(@Nullable Player player, PlayerInteractEvent.Action action) {
        if (action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && (player == null || !player.isCreative() && !player.isSpectator())) {
            this.emitSound();
        }
        return super.onTouch(player, action);
    }

    public int getStrength() {
        BlockEntityMusic blockEntity = (BlockEntityMusic)this.getBlockEntity();
        return blockEntity != null ? blockEntity.getPitch() : 0;
    }

    public void increaseStrength() {
        ((BlockEntityMusic)this.getOrCreateBlockEntity()).changePitch();
    }

    public Instrument getInstrument() {
        switch (this.down().getId()) {
            case 41: {
                return Instrument.GLOCKENSPIEL;
            }
            case 82: 
            case 476: {
                return Instrument.FLUTE;
            }
            case 174: {
                return Instrument.CHIME;
            }
            case 35: {
                return Instrument.GUITAR;
            }
            case 216: {
                return Instrument.XYLOPHONE;
            }
            case 42: {
                return Instrument.VIBRAPHONE;
            }
            case 88: {
                return Instrument.COW_BELL;
            }
            case 86: {
                return Instrument.DIDGERIDOO;
            }
            case 133: {
                return Instrument.SQUARE_WAVE;
            }
            case 170: {
                return Instrument.BANJO;
            }
            case 89: {
                return Instrument.ELECTRIC_PIANO;
            }
            case 5: 
            case 17: 
            case 25: 
            case 47: 
            case 53: 
            case 54: 
            case 58: 
            case 63: 
            case 64: 
            case 68: 
            case 72: 
            case 84: 
            case 85: 
            case 96: 
            case 99: 
            case 100: 
            case 107: 
            case 134: 
            case 135: 
            case 136: 
            case 146: 
            case 151: 
            case 157: 
            case 158: 
            case 162: 
            case 163: 
            case 164: 
            case 176: 
            case 177: 
            case 178: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 499: 
            case 500: 
            case 509: 
            case 510: 
            case 513: 
            case 514: {
                return Instrument.BASS;
            }
            case 12: 
            case 13: 
            case 237: {
                return Instrument.DRUM;
            }
            case 20: 
            case 102: 
            case 138: 
            case 160: 
            case 169: 
            case 241: {
                return Instrument.STICKS;
            }
            case 1: 
            case 4: 
            case 7: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 23: 
            case 24: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 49: 
            case 52: 
            case 56: 
            case 61: 
            case 62: 
            case 67: 
            case 70: 
            case 73: 
            case 74: 
            case 87: 
            case 98: 
            case 108: 
            case 109: 
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 120: 
            case 121: 
            case 125: 
            case 128: 
            case 129: 
            case 130: 
            case 139: 
            case 153: 
            case 155: 
            case 156: 
            case 159: 
            case 168: 
            case 172: 
            case 173: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 201: 
            case 203: 
            case 206: 
            case 213: 
            case 215: 
            case 236: 
            case 245: 
            case 246: 
            case 251: 
            case 487: 
            case 488: {
                return Instrument.BASS_DRUM;
            }
        }
        return Instrument.PIANO;
    }

    public void emitSound() {
        if (this.up().getId() != 0) {
            return;
        }
        Instrument instrument = this.getInstrument();
        this.level.addLevelSoundEvent(this, 81, instrument.ordinal() << 8 | this.getStrength());
        BlockEventPacket pk = new BlockEventPacket();
        pk.x = this.getFloorX();
        pk.y = this.getFloorY();
        pk.z = this.getFloorZ();
        pk.case1 = instrument.ordinal();
        pk.case2 = this.getStrength();
        this.getLevel().addChunkPacket(this.getFloorX() >> 4, this.getFloorZ() >> 4, pk);
    }

    @Override
    public boolean onActivate(@Nonnull Item item, @Nullable Player player) {
        this.increaseStrength();
        this.emitSound();
        return true;
    }

    @Override
    @PowerNukkitDifference(info="Using new method for checking if powered", since="1.4.0.0-PN")
    public int onUpdate(int type) {
        if (type == 6) {
            BlockEntityMusic music = (BlockEntityMusic)this.getBlockEntity();
            if (music == null) {
                return 0;
            }
            if (this.isGettingPower()) {
                if (!music.isPowered()) {
                    this.emitSound();
                }
                music.setPowered(true);
            } else {
                music.setPowered(false);
            }
        }
        return super.onUpdate(type);
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WOOD_BLOCK_COLOR;
    }

    public static enum Instrument {
        PIANO(Sound.NOTE_HARP),
        BASS_DRUM(Sound.NOTE_BD),
        DRUM(Sound.NOTE_SNARE),
        STICKS(Sound.NOTE_HAT),
        BASS(Sound.NOTE_BASS),
        GLOCKENSPIEL(Sound.NOTE_BELL),
        FLUTE(Sound.NOTE_FLUTE),
        CHIME(Sound.NOTE_CHIME),
        GUITAR(Sound.NOTE_GUITAR),
        XYLOPHONE(Sound.NOTE_XYLOPHONE),
        VIBRAPHONE(Sound.NOTE_IRON_XYLOPHONE),
        COW_BELL(Sound.NOTE_COW_BELL),
        DIDGERIDOO(Sound.NOTE_DIDGERIDOO),
        SQUARE_WAVE(Sound.NOTE_BIT),
        BANJO(Sound.NOTE_BANJO),
        ELECTRIC_PIANO(Sound.NOTE_PLING);

        private final Sound sound;

        private Instrument(Sound sound) {
            this.sound = sound;
        }

        public Sound getSound() {
            return this.sound;
        }
    }
}

