/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.value.PrismarineBlockType;
import cn.nukkit.utils.BlockColor;
import javax.annotation.Nonnull;

public class BlockPrismarine
extends BlockSolidMeta {
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperty<PrismarineBlockType> PRISMARINE_BLOCK_TYPE = new ArrayBlockProperty<PrismarineBlockType>("prismarine_block_type", true, PrismarineBlockType.class);
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(PRISMARINE_BLOCK_TYPE);
    @Deprecated
    @DeprecationDetails(since="1.5.0.0-PN", replaceWith="getPrismarineBlockType()", reason="Use the BlockProperty API instead")
    public static final int NORMAL = 0;
    @DeprecationDetails(since="1.5.0.0-PN", replaceWith="getPrismarineBlockType()", reason="Use the BlockProperty API instead")
    public static final int DARK = 1;
    @DeprecationDetails(since="1.5.0.0-PN", replaceWith="getPrismarineBlockType()", reason="Use the BlockProperty API instead")
    public static final int BRICKS = 2;

    public BlockPrismarine() {
        this(0);
    }

    public BlockPrismarine(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 168;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public double getHardness() {
        return 1.5;
    }

    @Override
    public double getResistance() {
        return 30.0;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public String getName() {
        return this.getPrismarineBlockType().getEnglishName();
    }

    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public void setPrismarineBlockType(PrismarineBlockType prismarineBlockType) {
        this.setPropertyValue(PRISMARINE_BLOCK_TYPE, prismarineBlockType);
    }

    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public PrismarineBlockType getPrismarineBlockType() {
        return this.getPropertyValue(PRISMARINE_BLOCK_TYPE);
    }

    @Override
    public int getToolTier() {
        return 1;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public BlockColor getColor() {
        return this.getPrismarineBlockType().getColor();
    }
}

