/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockRedstoneDiode;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.event.redstone.RedstoneUpdateEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemRedstone;
import cn.nukkit.level.Level;
import cn.nukkit.level.Location;
import cn.nukkit.level.Position;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.RedstoneComponent;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

@PowerNukkitDifference(info="Implements RedstoneComponent and uses methods from it.", since="1.4.0.0-PN")
public class BlockRedstoneWire
extends BlockFlowable
implements RedstoneComponent {
    @Since(value="1.5.0.0-PN")
    @PowerNukkitOnly
    public static final BlockProperties PROPERTIES = CommonBlockProperties.REDSTONE_SIGNAL_BLOCK_PROPERTY;
    private boolean canProvidePower = true;
    private final Set<Vector3> blocksNeedingUpdate = new HashSet<Vector3>();

    public BlockRedstoneWire() {
        this(0);
    }

    public BlockRedstoneWire(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Redstone Wire";
    }

    @Override
    public int getId() {
        return 55;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Removed unneeded replaceable check")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (!this.canBePlacedOn(block.down())) {
            return false;
        }
        if (this.level.getServer().isRedstoneEnabled()) {
            this.getLevel().setBlock((Vector3)block, this, true);
            this.updateSurroundingRedstone(true);
            Location pos = this.getLocation();
            for (BlockFace blockFace : BlockFace.Plane.VERTICAL) {
                RedstoneComponent.updateAroundRedstone(pos.getSide(blockFace), blockFace.getOpposite());
            }
            for (BlockFace blockFace : BlockFace.Plane.VERTICAL) {
                this.updateAround(pos.getSide(blockFace), blockFace.getOpposite());
            }
            for (BlockFace blockFace : BlockFace.Plane.HORIZONTAL) {
                Position p = pos.getSide(blockFace);
                if (this.level.getBlock(p).isNormalBlock()) {
                    this.updateAround(p.getSide(BlockFace.UP), BlockFace.DOWN);
                    continue;
                }
                this.updateAround(p.getSide(BlockFace.DOWN), BlockFace.UP);
            }
        } else {
            this.getLevel().setBlock((Vector3)block, this, true, true);
        }
        return true;
    }

    private void updateAround(Position pos, BlockFace face) {
        if (this.level.getBlock(pos).getId() == 55) {
            this.updateAroundRedstone(face);
            for (BlockFace side : BlockFace.values()) {
                RedstoneComponent.updateAroundRedstone(pos.getSide(side), side.getOpposite());
            }
        }
    }

    private void updateSurroundingRedstone(boolean force) {
        this.calculateCurrentChanges(force);
    }

    @PowerNukkitDifference(info="Let redstone go down transparent blocks.", since="1.4.0.0-PN")
    private void calculateCurrentChanges(boolean force) {
        int meta;
        Location pos = this.getLocation();
        int maxStrength = meta = this.getDamage();
        this.canProvidePower = false;
        int power = this.getIndirectPower();
        this.canProvidePower = true;
        if (power > 0 && power > maxStrength - 1) {
            maxStrength = power;
        }
        int strength = 0;
        for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
            Vector3 v = ((Vector3)pos).getSide(face);
            if (v.getX() == this.getX() && v.getZ() == this.getZ()) continue;
            strength = this.getMaxCurrentStrength(v, strength);
            if (this.getMaxCurrentStrength(v.up(), strength) > strength && !this.level.getBlock(pos.up()).isNormalBlock()) {
                strength = this.getMaxCurrentStrength(v.up(), strength);
            }
            if (this.getMaxCurrentStrength(v.down(), strength) <= strength || this.level.getBlock(v).isNormalBlock()) continue;
            strength = this.getMaxCurrentStrength(v.down(), strength);
        }
        maxStrength = strength > maxStrength ? strength - 1 : (maxStrength > 0 ? --maxStrength : 0);
        if (power > maxStrength - 1) {
            maxStrength = power;
        } else if (power < maxStrength && strength <= maxStrength) {
            maxStrength = Math.max(power, strength - 1);
        }
        if (meta != maxStrength) {
            this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, meta, maxStrength));
            this.setDamage(maxStrength);
            this.level.setBlock((Vector3)this, this, false, true);
            this.updateAllAroundRedstone(new BlockFace[0]);
        } else if (force) {
            for (BlockFace face : BlockFace.values()) {
                RedstoneComponent.updateAroundRedstone((Position)this.getSide(face), face.getOpposite());
            }
        }
    }

    private int getMaxCurrentStrength(Vector3 pos, int maxStrength) {
        if (this.level.getBlockIdAt(pos.getFloorX(), pos.getFloorY(), pos.getFloorZ()) != this.getId()) {
            return maxStrength;
        }
        int strength = this.level.getBlockDataAt(pos.getFloorX(), pos.getFloorY(), pos.getFloorZ());
        return Math.max(strength, maxStrength);
    }

    @Override
    public boolean onBreak(Item item) {
        Block air = Block.get(0);
        this.getLevel().setBlock((Vector3)this, air, true, true);
        Location pos = this.getLocation();
        if (this.level.getServer().isRedstoneEnabled()) {
            this.updateSurroundingRedstone(false);
            this.getLevel().setBlock((Vector3)this, air, true, true);
            for (BlockFace blockFace : BlockFace.values()) {
                RedstoneComponent.updateAroundRedstone(pos.getSide(blockFace), new BlockFace[0]);
            }
            for (BlockFace blockFace : BlockFace.Plane.HORIZONTAL) {
                Position p = pos.getSide(blockFace);
                if (this.level.getBlock(p).isNormalBlock()) {
                    this.updateAround(p.getSide(BlockFace.UP), BlockFace.DOWN);
                    continue;
                }
                this.updateAround(p.getSide(BlockFace.DOWN), BlockFace.UP);
            }
        }
        return true;
    }

    @Override
    public Item toItem() {
        return new ItemRedstone();
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    public int onUpdate(int type) {
        if (type != 1 && type != 6) {
            return 0;
        }
        if (!this.level.getServer().isRedstoneEnabled()) {
            return 0;
        }
        RedstoneUpdateEvent ev = new RedstoneUpdateEvent(this);
        this.getLevel().getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return 0;
        }
        if (type == 1 && !this.canBePlacedOn(this.down())) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        this.updateSurroundingRedstone(false);
        return 1;
    }

    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed placement logic")
    public boolean canBePlacedOn(Block support) {
        return support.isSolid(BlockFace.UP);
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return !this.canProvidePower ? 0 : this.getWeakPower(side);
    }

    @Override
    public int getWeakPower(BlockFace side) {
        if (!this.canProvidePower) {
            return 0;
        }
        int power = this.getDamage();
        if (power == 0) {
            return 0;
        }
        if (side == BlockFace.UP) {
            return power;
        }
        EnumSet<BlockFace> faces = EnumSet.noneOf(BlockFace.class);
        for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
            if (!this.isPowerSourceAt(face)) continue;
            faces.add(face);
        }
        if (side.getAxis().isHorizontal() && faces.isEmpty()) {
            return power;
        }
        if (faces.contains((Object)side) && !faces.contains((Object)side.rotateYCCW()) && !faces.contains((Object)side.rotateY())) {
            return power;
        }
        return 0;
    }

    private boolean isPowerSourceAt(BlockFace side) {
        Location pos = this.getLocation();
        Vector3 v = ((Vector3)pos).getSide(side);
        Block block = this.level.getBlock(v);
        boolean flag = block.isNormalBlock();
        boolean flag1 = this.level.getBlock(pos.up()).isNormalBlock();
        return !flag1 && flag && BlockRedstoneWire.canConnectUpwardsTo(this.level, v.up()) || BlockRedstoneWire.canConnectTo(block, side) || !flag && BlockRedstoneWire.canConnectUpwardsTo(this.level, block.down());
    }

    protected static boolean canConnectUpwardsTo(Level level, Vector3 pos) {
        return BlockRedstoneWire.canConnectUpwardsTo(level.getBlock(pos));
    }

    protected static boolean canConnectUpwardsTo(Block block) {
        return BlockRedstoneWire.canConnectTo(block, null);
    }

    @PowerNukkitDifference(info="Can't connect to pistons and bells, but powers them either.", since="1.4.0.0-PN")
    protected static boolean canConnectTo(Block block, BlockFace side) {
        if (block.getId() == 55) {
            return true;
        }
        if (BlockRedstoneDiode.isDiode(block)) {
            BlockFace face = ((BlockRedstoneDiode)block).getFacing();
            return face == side || face.getOpposite() == side;
        }
        return block.isPowerSource() && side != null;
    }

    @Override
    public boolean isPowerSource() {
        return this.canProvidePower;
    }

    private int getIndirectPower() {
        int power = 0;
        Location pos = this.getLocation();
        for (BlockFace face : BlockFace.values()) {
            int blockPower = this.getIndirectPower(((Vector3)pos).getSide(face), face);
            if (blockPower >= 15) {
                return 15;
            }
            if (blockPower <= power) continue;
            power = blockPower;
        }
        return power;
    }

    private int getIndirectPower(Vector3 pos, BlockFace face) {
        Block block = this.level.getBlock(pos);
        if (block.getId() == 55) {
            return 0;
        }
        return block.isNormalBlock() ? this.getStrongPower(pos) : block.getWeakPower(face);
    }

    private int getStrongPower(Vector3 pos) {
        int i = 0;
        for (BlockFace face : BlockFace.values()) {
            if ((i = Math.max(i, this.getStrongPower(pos.getSide(face), face))) < 15) continue;
            return i;
        }
        return i;
    }

    private int getStrongPower(Vector3 pos, BlockFace direction) {
        Block block = this.level.getBlock(pos);
        if (block.getId() == 55) {
            return 0;
        }
        return block.getStrongPower(direction);
    }
}

