/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntitySign;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemSign;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.CompassRoseDirection;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@PowerNukkitDifference(since="1.4.0.0-PN", info="Implements BlockEntityHolder only in PowerNukkit")
public class BlockSignPost
extends BlockTransparentMeta
implements Faceable,
BlockEntityHolder<BlockEntitySign> {
    private static final Logger log = LogManager.getLogger(BlockSignPost.class);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperty<CompassRoseDirection> GROUND_SIGN_DIRECTION = new ArrayBlockProperty("ground_sign_direction", false, (Serializable[])new CompassRoseDirection[]{CompassRoseDirection.SOUTH, CompassRoseDirection.SOUTH_SOUTH_WEST, CompassRoseDirection.SOUTH_WEST, CompassRoseDirection.WEST_SOUTH_WEST, CompassRoseDirection.WEST, CompassRoseDirection.WEST_NORTH_WEST, CompassRoseDirection.NORTH_WEST, CompassRoseDirection.NORTH_NORTH_WEST, CompassRoseDirection.NORTH, CompassRoseDirection.NORTH_NORTH_EAST, CompassRoseDirection.NORTH_EAST, CompassRoseDirection.EAST_NORTH_EAST, CompassRoseDirection.EAST, CompassRoseDirection.EAST_SOUTH_EAST, CompassRoseDirection.SOUTH_EAST, CompassRoseDirection.SOUTH_SOUTH_EAST}).ordinal(true);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(GROUND_SIGN_DIRECTION);

    public BlockSignPost() {
        this(0);
    }

    public BlockSignPost(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 63;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntitySign> getBlockEntityClass() {
        return BlockEntitySign.class;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "Sign";
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public double getHardness() {
        return 1.0;
    }

    @Override
    public double getResistance() {
        return 5.0;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public boolean isSolid(BlockFace side) {
        return false;
    }

    @Override
    public String getName() {
        return "Sign Post";
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    protected int getPostId() {
        return this.getId();
    }

    public int getWallId() {
        return 68;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        if (face == BlockFace.DOWN) {
            return false;
        }
        Block layer0 = this.level.getBlock((Vector3)this, 0);
        Block layer1 = this.level.getBlock((Vector3)this, 1);
        CompoundTag nbt = new CompoundTag().putString("Text1", "").putString("Text2", "").putString("Text3", "").putString("Text4", "");
        if (face == BlockFace.UP) {
            CompassRoseDirection direction = GROUND_SIGN_DIRECTION.getValueForMeta((int)Math.floor(((player != null ? player.yaw : 0.0) + 180.0) * 16.0 / 360.0 + 0.5) & 0xF);
            BlockState post = BlockState.of(this.getPostId()).withProperty(GROUND_SIGN_DIRECTION, direction);
            this.getLevel().setBlock((Vector3)block, post.getBlock(block), true);
        } else {
            BlockState wall = BlockState.of(this.getWallId()).withProperty(CommonBlockProperties.FACING_DIRECTION, face);
            this.getLevel().setBlock((Vector3)block, wall.getBlock(block), true);
        }
        if (player != null) {
            nbt.putString("Creator", player.getUniqueId().toString());
        }
        if (item.hasCustomBlockData()) {
            for (Tag aTag : item.getCustomBlockData().getAllTags()) {
                nbt.put(aTag.getName(), aTag);
            }
        }
        try {
            this.createBlockEntity(nbt, new Object[0]);
            return true;
        }
        catch (Exception e) {
            log.warn("Failed to create block entity {} at {}", (Object)this.getBlockEntityType(), (Object)this.getLocation(), (Object)e);
            this.level.setBlock((Vector3)layer0, 0, layer0, true);
            this.level.setBlock((Vector3)layer1, 0, layer1, true);
            return false;
        }
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 && this.down().getId() == 0) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        return 0;
    }

    @Override
    public Item toItem() {
        return new ItemSign();
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public CompassRoseDirection getSignDirection() {
        return this.getPropertyValue(GROUND_SIGN_DIRECTION);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setSignDirection(CompassRoseDirection direction) {
        this.setPropertyValue(GROUND_SIGN_DIRECTION, direction);
    }

    @Override
    @PowerNukkitDifference(info="Was returning the wrong face, it now return the closest face, or the left face if even", since="1.4.0.0-PN")
    public BlockFace getBlockFace() {
        return this.getSignDirection().getClosestBlockFace();
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public void setBlockFace(BlockFace face) {
        this.setSignDirection(face.getCompassRoseDirection());
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }
}

