/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockSlab;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.value.WoodType;
import cn.nukkit.utils.BlockColor;
import javax.annotation.Nonnull;

public class BlockSlabWood
extends BlockSlab {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(WoodType.PROPERTY, TOP_SLOT_PROPERTY);

    public BlockSlabWood() {
        this(0);
    }

    public BlockSlabWood(int meta) {
        super(meta, 157);
    }

    @Override
    public String getName() {
        return (this.isOnTop() ? "Upper " : "") + this.getSlabName() + " Wood Slab";
    }

    @Override
    public String getSlabName() {
        return this.getWoodType().getEnglishName();
    }

    @Override
    public int getId() {
        return 158;
    }

    @Override
    public boolean isSameType(BlockSlab slab) {
        return slab.getId() == this.getId() && slab.getPropertyValue(WoodType.PROPERTY).equals((Object)this.getWoodType());
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public int getBurnChance() {
        return 5;
    }

    @Override
    public int getBurnAbility() {
        return 20;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public WoodType getWoodType() {
        return this.getPropertyValue(WoodType.PROPERTY);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setWoodType(WoodType type) {
        this.setPropertyValue(WoodType.PROPERTY, type);
    }

    @Override
    public BlockColor getColor() {
        return this.getWoodType().getColor();
    }
}

