/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockBell;
import cn.nukkit.block.BlockButton;
import cn.nukkit.block.BlockConnectable;
import cn.nukkit.block.BlockFenceGate;
import cn.nukkit.block.BlockLantern;
import cn.nukkit.block.BlockPressurePlateBase;
import cn.nukkit.block.BlockSignPost;
import cn.nukkit.block.BlockStairs;
import cn.nukkit.block.BlockTorch;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.block.BlockTrapdoor;
import cn.nukkit.block.BlockWall;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.blockproperty.value.AttachmentType;
import cn.nukkit.item.Item;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.math.VectorMath;
import cn.nukkit.utils.Faceable;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public abstract class BlockWallBase
extends BlockTransparentMeta
implements BlockConnectable {
    private static final Logger log = LogManager.getLogger(BlockWallBase.class);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperty<BlockWall.WallConnectionType> WALL_CONNECTION_TYPE_SOUTH = new ArrayBlockProperty<BlockWall.WallConnectionType>("wall_connection_type_south", false, BlockWall.WallConnectionType.class);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperty<BlockWall.WallConnectionType> WALL_CONNECTION_TYPE_WEST = new ArrayBlockProperty<BlockWall.WallConnectionType>("wall_connection_type_west", false, BlockWall.WallConnectionType.class);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperty<BlockWall.WallConnectionType> WALL_CONNECTION_TYPE_NORTH = new ArrayBlockProperty<BlockWall.WallConnectionType>("wall_connection_type_north", false, BlockWall.WallConnectionType.class);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperty<BlockWall.WallConnectionType> WALL_CONNECTION_TYPE_EAST = new ArrayBlockProperty<BlockWall.WallConnectionType>("wall_connection_type_east", false, BlockWall.WallConnectionType.class);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BooleanBlockProperty WALL_POST_BIT = new BooleanBlockProperty("wall_post_bit", false);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(WALL_CONNECTION_TYPE_SOUTH, WALL_CONNECTION_TYPE_WEST, WALL_CONNECTION_TYPE_NORTH, WALL_CONNECTION_TYPE_EAST, WALL_POST_BIT);
    private static final double MIN_POST_BB = 0.3125;
    private static final double MAX_POST_BB = 0.6875;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockWallBase(int meta) {
        super(meta);
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean isSolid(BlockFace side) {
        return false;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 30.0;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    private boolean shouldBeTall(Block above, BlockFace face) {
        switch (above.getId()) {
            case 0: 
            case 144: {
                return false;
            }
            case 461: {
                BlockBell bell = (BlockBell)above;
                return bell.getAttachment() == AttachmentType.STANDING && bell.getBlockFace().getAxis() != face.getAxis();
            }
        }
        if (above instanceof BlockWallBase) {
            return ((BlockWallBase)above).getConnectionType(face) != BlockWall.WallConnectionType.NONE;
        }
        if (above instanceof BlockConnectable) {
            return ((BlockConnectable)((Object)above)).isConnected(face);
        }
        if (above instanceof BlockPressurePlateBase || above instanceof BlockStairs) {
            return true;
        }
        return above.isSolid() && !above.isTransparent() || this.shouldBeTallBasedOnBoundingBox(above, face);
    }

    private boolean shouldBeTallBasedOnBoundingBox(Block above, BlockFace face) {
        AxisAlignedBB boundingBox = above.getBoundingBox();
        if (boundingBox == null) {
            return false;
        }
        if ((boundingBox = boundingBox.getOffsetBoundingBox(-above.x, -above.y, -above.z)).getMinY() > 0.0) {
            return false;
        }
        int offset = face.getXOffset();
        if (offset < 0) {
            return boundingBox.getMinX() < 0.3125 && boundingBox.getMinZ() < 0.3125 && 0.6875 < boundingBox.getMaxZ();
        }
        if (offset > 0) {
            return 0.6875 < boundingBox.getMaxX() && 0.6875 < boundingBox.getMaxZ() && boundingBox.getMinZ() < 0.6875;
        }
        offset = face.getZOffset();
        if (offset < 0) {
            return boundingBox.getMinZ() < 0.3125 && boundingBox.getMinX() < 0.3125 && 0.3125 < boundingBox.getMaxX();
        }
        if (offset > 0) {
            return 0.6875 < boundingBox.getMaxZ() && 0.6875 < boundingBox.getMaxX() && boundingBox.getMinX() < 0.6875;
        }
        return false;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean autoConfigureState() {
        Number previousMeta = this.getDataStorage();
        this.setWallPost(true);
        Block above = this.up(1, 0);
        for (BlockFace blockFace : BlockFace.Plane.HORIZONTAL) {
            Block side = this.getSideAtLayer(0, blockFace);
            if (this.canConnect(side)) {
                try {
                    this.connect(blockFace, above, false);
                    continue;
                }
                catch (RuntimeException e) {
                    log.error("Failed to connect the block {} at {} to {} which is {} at {}", (Object)this, (Object)this.getLocation(), (Object)blockFace, (Object)side, (Object)side.getLocation(), (Object)e);
                    throw e;
                }
            }
            this.disconnect(blockFace);
        }
        this.recheckPostConditions(above);
        return !this.getDataStorage().equals(previousMeta);
    }

    @Override
    @PowerNukkitDifference(info="Will connect as expected", since="1.4.0.0-PN")
    public int onUpdate(int type) {
        if (type == 1) {
            if (this.autoConfigureState()) {
                this.level.setBlock((Vector3)this, this, true);
            }
            return type;
        }
        return 0;
    }

    @Override
    @PowerNukkitDifference(info="Will be placed on the right state", since="1.4.0.0-PN")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        this.autoConfigureState();
        return super.place(item, block, target, face, fx, fy, fz, player);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isWallPost() {
        return this.getBooleanValue(WALL_POST_BIT);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setWallPost(boolean wallPost) {
        this.setBooleanValue(WALL_POST_BIT, wallPost);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void clearConnections() {
        this.setPropertyValue(WALL_CONNECTION_TYPE_EAST, BlockWall.WallConnectionType.NONE);
        this.setPropertyValue(WALL_CONNECTION_TYPE_WEST, BlockWall.WallConnectionType.NONE);
        this.setPropertyValue(WALL_CONNECTION_TYPE_NORTH, BlockWall.WallConnectionType.NONE);
        this.setPropertyValue(WALL_CONNECTION_TYPE_SOUTH, BlockWall.WallConnectionType.NONE);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Map<BlockFace, BlockWall.WallConnectionType> getWallConnections() {
        EnumMap<BlockFace, BlockWall.WallConnectionType> connections = new EnumMap<BlockFace, BlockWall.WallConnectionType>(BlockFace.class);
        for (BlockFace blockFace : BlockFace.Plane.HORIZONTAL) {
            BlockWall.WallConnectionType connectionType = this.getConnectionType(blockFace);
            if (connectionType == BlockWall.WallConnectionType.NONE) continue;
            connections.put(blockFace, connectionType);
        }
        return connections;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockWall.WallConnectionType getConnectionType(BlockFace blockFace) {
        switch (blockFace) {
            case NORTH: {
                return this.getPropertyValue(WALL_CONNECTION_TYPE_NORTH);
            }
            case SOUTH: {
                return this.getPropertyValue(WALL_CONNECTION_TYPE_SOUTH);
            }
            case WEST: {
                return this.getPropertyValue(WALL_CONNECTION_TYPE_WEST);
            }
            case EAST: {
                return this.getPropertyValue(WALL_CONNECTION_TYPE_EAST);
            }
        }
        return BlockWall.WallConnectionType.NONE;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean setConnection(BlockFace blockFace, BlockWall.WallConnectionType type) {
        switch (blockFace) {
            case NORTH: {
                this.setPropertyValue(WALL_CONNECTION_TYPE_NORTH, type);
                return true;
            }
            case SOUTH: {
                this.setPropertyValue(WALL_CONNECTION_TYPE_SOUTH, type);
                return true;
            }
            case WEST: {
                this.setPropertyValue(WALL_CONNECTION_TYPE_WEST, type);
                return true;
            }
            case EAST: {
                this.setPropertyValue(WALL_CONNECTION_TYPE_EAST, type);
                return true;
            }
        }
        return false;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void autoUpdatePostFlag() {
        this.setWallPost(this.recheckPostConditions(this.up(1, 0)));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean hasConnections() {
        return this.getPropertyValue(WALL_CONNECTION_TYPE_EAST) != BlockWall.WallConnectionType.NONE || this.getPropertyValue(WALL_CONNECTION_TYPE_WEST) != BlockWall.WallConnectionType.NONE || this.getPropertyValue(WALL_CONNECTION_TYPE_NORTH) != BlockWall.WallConnectionType.NONE || this.getPropertyValue(WALL_CONNECTION_TYPE_SOUTH) != BlockWall.WallConnectionType.NONE;
    }

    private boolean recheckPostConditions(Block above) {
        if (!this.hasConnections()) {
            return true;
        }
        Map<BlockFace, BlockWall.WallConnectionType> connections = this.getWallConnections();
        if (connections.size() != 2) {
            return true;
        }
        Iterator<Map.Entry<BlockFace, BlockWall.WallConnectionType>> iterator = connections.entrySet().iterator();
        Map.Entry<BlockFace, BlockWall.WallConnectionType> entryA = iterator.next();
        Map.Entry<BlockFace, BlockWall.WallConnectionType> entryB = iterator.next();
        if (entryA.getValue() != entryB.getValue() || entryA.getKey().getOpposite() != entryB.getKey()) {
            return true;
        }
        BlockFace.Axis axis = entryA.getKey().getAxis();
        switch (above.getId()) {
            case 140: 
            case 144: 
            case 176: 
            case 412: 
            case 414: {
                return true;
            }
            case 208: {
                if (((Faceable)((Object)above)).getBlockFace() != BlockFace.UP) break;
                return true;
            }
            case 461: {
                BlockBell bell = (BlockBell)above;
                if (bell.getAttachment() != AttachmentType.STANDING || bell.getBlockFace().getAxis() != axis) break;
                return true;
            }
            default: {
                if (above instanceof BlockWallBase) {
                    if (!((BlockWallBase)above).isWallPost()) break;
                    return true;
                }
                if (above instanceof BlockLantern) {
                    if (((BlockLantern)above).isHanging()) break;
                    return true;
                }
                if (above.getId() == 69 || above instanceof BlockTorch || above instanceof BlockButton) {
                    if (((Faceable)((Object)above)).getBlockFace() != BlockFace.UP) break;
                    return true;
                }
                if (above instanceof BlockFenceGate) {
                    if (((Faceable)((Object)above)).getBlockFace().getAxis() != axis) break;
                    return true;
                }
                if (!(above instanceof BlockConnectable)) break;
                int shared = 0;
                for (BlockFace connection : ((BlockConnectable)((Object)above)).getConnections()) {
                    if (connections.containsKey((Object)connection) && ++shared == 2) break;
                }
                if (shared >= 2) break;
                return true;
            }
        }
        return above instanceof BlockSignPost;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isSameHeightStraight() {
        Map<BlockFace, BlockWall.WallConnectionType> connections = this.getWallConnections();
        if (connections.size() != 2) {
            return false;
        }
        Iterator<Map.Entry<BlockFace, BlockWall.WallConnectionType>> iterator = connections.entrySet().iterator();
        Map.Entry<BlockFace, BlockWall.WallConnectionType> a = iterator.next();
        Map.Entry<BlockFace, BlockWall.WallConnectionType> b = iterator.next();
        return a.getValue() == b.getValue() && a.getKey().getOpposite() == b.getKey();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean connect(BlockFace blockFace) {
        return this.connect(blockFace, true);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean connect(BlockFace blockFace, boolean recheckPost) {
        if (blockFace.getHorizontalIndex() < 0) {
            return false;
        }
        Block above = this.getSideAtLayer(0, BlockFace.UP);
        return this.connect(blockFace, above, recheckPost);
    }

    private boolean connect(BlockFace blockFace, Block above, boolean recheckPost) {
        BlockWall.WallConnectionType type;
        BlockWall.WallConnectionType wallConnectionType = type = this.shouldBeTall(above, blockFace) ? BlockWall.WallConnectionType.TALL : BlockWall.WallConnectionType.SHORT;
        if (this.setConnection(blockFace, type)) {
            if (recheckPost) {
                this.recheckPostConditions(above);
            }
            return true;
        }
        return false;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean disconnect(BlockFace blockFace) {
        if (blockFace.getHorizontalIndex() < 0) {
            return false;
        }
        if (this.setConnection(blockFace, BlockWall.WallConnectionType.NONE)) {
            this.autoUpdatePostFlag();
            return true;
        }
        return false;
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        double e;
        boolean north = this.canConnect(this.getSide(BlockFace.NORTH));
        boolean south = this.canConnect(this.getSide(BlockFace.SOUTH));
        boolean west = this.canConnect(this.getSide(BlockFace.WEST));
        boolean east = this.canConnect(this.getSide(BlockFace.EAST));
        double n = north ? 0.0 : 0.25;
        double s = south ? 1.0 : 0.75;
        double w = west ? 0.0 : 0.25;
        double d = e = east ? 1.0 : 0.75;
        if (north && south && !west && !east) {
            w = 0.3125;
            e = 0.6875;
        } else if (!north && !south && west && east) {
            n = 0.3125;
            s = 0.6875;
        }
        return new SimpleAxisAlignedBB(this.x + w, this.y, this.z + n, this.x + e, this.y + 1.5, this.z + s);
    }

    @Override
    @PowerNukkitDifference(info="Will connect to glass panes, iron bars and fence gates", since="1.4.0.0-PN")
    public boolean canConnect(Block block) {
        switch (block.getId()) {
            case 20: 
            case 101: 
            case 102: 
            case 160: 
            case 241: {
                return true;
            }
        }
        if (block instanceof BlockWallBase) {
            return true;
        }
        if (block instanceof BlockFenceGate) {
            BlockFenceGate fenceGate = (BlockFenceGate)block;
            return fenceGate.getBlockFace().getAxis() != VectorMath.calculateAxis(this, block);
        }
        if (block instanceof BlockStairs) {
            return ((BlockStairs)block).getBlockFace().getOpposite() == VectorMath.calculateFace(this, block);
        }
        if (block instanceof BlockTrapdoor) {
            BlockTrapdoor trapdoor = (BlockTrapdoor)block;
            return trapdoor.isOpen() && trapdoor.getBlockFace() == VectorMath.calculateFace(this, trapdoor);
        }
        return block.isSolid() && !block.isTransparent();
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isConnected(BlockFace face) {
        return this.getConnectionType(face) != BlockWall.WallConnectionType.NONE;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

