/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLog;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.blockproperty.value.WoodType;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.blockstate.IBlockState;
import cn.nukkit.blockstate.exception.InvalidBlockStateException;
import cn.nukkit.utils.BlockColor;
import java.io.Serializable;
import javax.annotation.Nonnull;

@PowerNukkitDifference(info="Extends BlockLog instead of BlockSolidMeta only in PowerNukkit", since="1.4.0.0-PN")
public class BlockWood
extends BlockLog {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperty<WoodType> OLD_LOG_TYPE = new ArrayBlockProperty("old_log_type", true, (Serializable[])new WoodType[]{WoodType.OAK, WoodType.SPRUCE, WoodType.BIRCH, WoodType.JUNGLE});
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(OLD_LOG_TYPE, CommonBlockProperties.PILLAR_AXIS);
    public static final int OAK = 0;
    public static final int SPRUCE = 1;
    public static final int BIRCH = 2;
    public static final int JUNGLE = 3;

    public BlockWood() {
        this(0);
    }

    public BlockWood(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 17;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 2.0;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public WoodType getWoodType() {
        return this.getPropertyValue(OLD_LOG_TYPE);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setWoodType(WoodType woodType) {
        this.setPropertyValue(OLD_LOG_TYPE, woodType);
    }

    @Override
    public String getName() {
        return this.getWoodType().getEnglishName() + " Log";
    }

    @Override
    @Nonnull
    @Since(value="1.5.1.0-PN")
    @PowerNukkitOnly
    public Block forState(@Nonnull IBlockState state) throws InvalidBlockStateException {
        int id = this.getId();
        if (id != 17 && id != 162) {
            return super.forState(state);
        }
        id = state.getBlockId();
        if (id != 17 && id != 162 || state.getBitSize() != 4) {
            return super.forState(state);
        }
        int exactInt = state.getExactIntStorage();
        if ((exactInt & 0xC) == 12) {
            int increment = state.getBlockId() == 17 ? 0 : 4;
            return BlockState.of(467, (exactInt & 3) + increment).getBlock(this, this.layer);
        }
        return super.forState(state);
    }

    @Override
    public int getBurnChance() {
        return 5;
    }

    @Override
    public int getBurnAbility() {
        return 10;
    }

    @Override
    protected BlockState getStrippedState() {
        int strippedId;
        switch (this.getWoodType()) {
            default: {
                strippedId = 265;
                break;
            }
            case SPRUCE: {
                strippedId = 260;
                break;
            }
            case BIRCH: {
                strippedId = 261;
                break;
            }
            case JUNGLE: {
                strippedId = 262;
                break;
            }
            case ACACIA: {
                strippedId = 263;
                break;
            }
            case DARK_OAK: {
                strippedId = 264;
            }
        }
        return BlockState.of(strippedId).withProperty(CommonBlockProperties.PILLAR_AXIS, this.getPillarAxis());
    }

    @Override
    public BlockColor getColor() {
        return this.getWoodType().getColor();
    }
}

