/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockstate;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.api.Unsigned;
import cn.nukkit.block.Block;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyException;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.blockstate.IMutableBlockState;
import cn.nukkit.blockstate.MutableBlockState;
import cn.nukkit.blockstate.exception.InvalidBlockStateException;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.utils.Validation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class IntMutableBlockState
extends MutableBlockState {
    private int storage;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public IntMutableBlockState(int blockId, BlockProperties properties, int state) {
        super(blockId, properties);
        this.storage = state;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public IntMutableBlockState(int blockId, BlockProperties properties) {
        this(blockId, properties, 0);
    }

    @Override
    @Nonnegative
    @Deprecated
    @DeprecationDetails(reason="Can't store all data, exists for backward compatibility reasons", since="1.4.0.0-PN", replaceWith="getDataStorage()")
    public int getLegacyDamage() {
        return this.storage & Block.DATA_MASK;
    }

    @Override
    @Deprecated
    @Unsigned
    @DeprecationDetails(reason="Can't store all data, exists for backward compatibility reasons", since="1.4.0.0-PN", replaceWith="getDataStorage()")
    public int getBigDamage() {
        return this.storage;
    }

    @Override
    @Nonnegative
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BigInteger getHugeDamage() {
        return BigInteger.valueOf(this.storage);
    }

    @Override
    @Nonnegative
    @Nonnull
    public Integer getDataStorage() {
        return this.storage;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean isDefaultState() {
        return this.storage == 0;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setDataStorage(@Nonnegative Number storage) {
        int state;
        Class<?> c = storage.getClass();
        if (c == Integer.class || c == Short.class || c == Byte.class) {
            state = storage.intValue();
        } else {
            try {
                state = new BigDecimal(storage.toString()).intValueExact();
            }
            catch (ArithmeticException | NumberFormatException e) {
                throw IMutableBlockState.handleUnsupportedStorageType(this.getBlockId(), storage, e);
            }
        }
        this.setDataStorageFromInt(state);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setDataStorageFromInt(@Nonnegative int storage) {
        this.validate(storage);
        this.storage = storage;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    void setDataStorageWithoutValidation(Number storage) {
        this.storage = storage.intValue();
    }

    @Override
    public void validate() {
        this.validate(this.storage);
    }

    private void validate(int state) {
        if (state == 0) {
            return;
        }
        Validation.checkPositive("state", state);
        int bitLength = NukkitMath.bitLength(state);
        if (bitLength > this.properties.getBitSize()) {
            throw new InvalidBlockStateException(BlockState.of(this.getBlockId(), state), "The state have more data bits than specified in the properties. Bits: " + bitLength + ", Max: " + this.properties.getBitSize());
        }
        try {
            BlockProperties properties = this.properties;
            for (String name : properties.getNames()) {
                BlockProperty<?> property = properties.getBlockProperty(name);
                property.validateMeta(state, properties.getOffset(name));
            }
        }
        catch (InvalidBlockPropertyException e) {
            throw new InvalidBlockStateException(BlockState.of(this.getBlockId(), state), (Throwable)e);
        }
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setBooleanValue(String propertyName, boolean value) {
        this.storage = this.properties.setBooleanValue(this.storage, propertyName, value);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setPropertyValue(String propertyName, @Nullable Serializable value) {
        this.storage = this.properties.setValue(this.storage, propertyName, value);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setIntValue(String propertyName, int value) {
        this.storage = this.properties.setIntValue(this.storage, propertyName, value);
    }

    @Override
    @Nonnull
    public Serializable getPropertyValue(String propertyName) {
        return this.properties.getValue(this.storage, propertyName);
    }

    @Override
    public int getIntValue(String propertyName) {
        return this.properties.getIntValue(this.storage, propertyName);
    }

    @Override
    public boolean getBooleanValue(String propertyName) {
        return this.properties.getBooleanValue(this.storage, propertyName);
    }

    @Override
    @Nonnull
    public String getPersistenceValue(String propertyName) {
        return this.properties.getPersistenceValue(this.storage, propertyName);
    }

    @Override
    @Nonnull
    public BlockState getCurrentState() {
        return BlockState.of(this.blockId, this.storage);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getExactIntStorage() {
        return this.storage;
    }

    @Override
    @Nonnull
    public IntMutableBlockState copy() {
        return new IntMutableBlockState(this.blockId, this.properties, this.storage);
    }

    @Override
    public String toString() {
        return "IntMutableBlockState(super=" + super.toString() + ", storage=" + this.storage + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntMutableBlockState)) {
            return false;
        }
        IntMutableBlockState other = (IntMutableBlockState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.storage == other.storage;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IntMutableBlockState;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.storage;
        return result;
    }
}

