/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.command.defaults;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.command.data.CommandEnum;
import cn.nukkit.command.data.CommandParamType;
import cn.nukkit.command.data.CommandParameter;
import cn.nukkit.command.defaults.VanillaCommand;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.SetDifficultyPacket;
import java.util.ArrayList;

public class DifficultyCommand
extends VanillaCommand {
    public DifficultyCommand(String name) {
        super(name, "%nukkit.command.difficulty.description", "%commands.difficulty.usage");
        this.setPermission("nukkit.command.difficulty");
        this.commandParameters.clear();
        this.commandParameters.put("default", new CommandParameter[]{CommandParameter.newType("difficulty", CommandParamType.INT)});
        this.commandParameters.put("byString", new CommandParameter[]{CommandParameter.newEnum("difficulty", new CommandEnum("Difficulty", "peaceful", "p", "easy", "e", "normal", "n", "hard", "h"))});
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
            return false;
        }
        int difficulty = Server.getDifficultyFromString(args[0]);
        if (sender.getServer().isHardcore()) {
            difficulty = 3;
        }
        if (difficulty == -1) {
            sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
            return false;
        }
        sender.getServer().setPropertyInt("difficulty", difficulty);
        SetDifficultyPacket pk = new SetDifficultyPacket();
        pk.difficulty = sender.getServer().getDifficulty();
        Server.broadcastPacket(new ArrayList<Player>(sender.getServer().getOnlinePlayers().values()), (DataPacket)pk);
        Command.broadcastCommandMessage(sender, new TranslationContainer("commands.difficulty.success", String.valueOf(difficulty)));
        return true;
    }
}

