/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity;

import cn.nukkit.AdventureSettings;
import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockBubbleColumn;
import cn.nukkit.block.BlockDirt;
import cn.nukkit.block.BlockFire;
import cn.nukkit.block.BlockHayBale;
import cn.nukkit.block.BlockLava;
import cn.nukkit.block.BlockNetherPortal;
import cn.nukkit.block.BlockTurtleEgg;
import cn.nukkit.block.BlockWater;
import cn.nukkit.blockentity.BlockEntityPistonArm;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.entity.Attribute;
import cn.nukkit.entity.EntityHuman;
import cn.nukkit.entity.EntityLiving;
import cn.nukkit.entity.EntityRideable;
import cn.nukkit.entity.data.ByteEntityData;
import cn.nukkit.entity.data.EntityData;
import cn.nukkit.entity.data.EntityMetadata;
import cn.nukkit.entity.data.FloatEntityData;
import cn.nukkit.entity.data.IntEntityData;
import cn.nukkit.entity.data.LongEntityData;
import cn.nukkit.entity.data.ShortEntityData;
import cn.nukkit.entity.data.StringEntityData;
import cn.nukkit.entity.data.Vector3fEntityData;
import cn.nukkit.event.Event;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.EntityDespawnEvent;
import cn.nukkit.event.entity.EntityInteractEvent;
import cn.nukkit.event.entity.EntityLevelChangeEvent;
import cn.nukkit.event.entity.EntityMotionEvent;
import cn.nukkit.event.entity.EntityPortalEnterEvent;
import cn.nukkit.event.entity.EntityRegainHealthEvent;
import cn.nukkit.event.entity.EntitySpawnEvent;
import cn.nukkit.event.entity.EntityTeleportEvent;
import cn.nukkit.event.entity.EntityVehicleEnterEvent;
import cn.nukkit.event.entity.EntityVehicleExitEvent;
import cn.nukkit.event.player.PlayerInteractEvent;
import cn.nukkit.event.player.PlayerTeleportEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.enchantment.sideeffect.SideEffect;
import cn.nukkit.level.EnumLevel;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.Level;
import cn.nukkit.level.Location;
import cn.nukkit.level.ParticleEffect;
import cn.nukkit.level.Position;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.MathHelper;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector2;
import cn.nukkit.math.Vector3;
import cn.nukkit.math.Vector3f;
import cn.nukkit.metadata.MetadataValue;
import cn.nukkit.metadata.Metadatable;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.network.protocol.AddEntityPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.EntityEventPacket;
import cn.nukkit.network.protocol.MobEffectPacket;
import cn.nukkit.network.protocol.RemoveEntityPacket;
import cn.nukkit.network.protocol.SetEntityDataPacket;
import cn.nukkit.network.protocol.SetEntityLinkPacket;
import cn.nukkit.network.protocol.SetEntityMotionPacket;
import cn.nukkit.network.protocol.types.EntityLink;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.potion.Effect;
import cn.nukkit.scheduler.Task;
import cn.nukkit.utils.ChunkException;
import cn.nukkit.utils.TextFormat;
import cn.nukkit.utils.Utils;
import co.aikar.timings.Timing;
import co.aikar.timings.Timings;
import co.aikar.timings.TimingsHistory;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.AbstractIntList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@PowerNukkitDifference(since="1.4.0.0-PN", info="All DATA constants were made dynamic because they have tendency to change on Minecraft updates, these dynamic calls will avoid the need of plugin recompilations after Minecraft updates that shifts the data values")
public abstract class Entity
extends Location
implements Metadatable {
    private static final Logger log = LogManager.getLogger(Entity.class);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final Entity[] EMPTY_ARRAY = new Entity[0];
    public static final int NETWORK_ID = -1;
    public static final int DATA_TYPE_BYTE = 0;
    public static final int DATA_TYPE_SHORT = 1;
    public static final int DATA_TYPE_INT = 2;
    public static final int DATA_TYPE_FLOAT = 3;
    public static final int DATA_TYPE_STRING = 4;
    public static final int DATA_TYPE_NBT = 5;
    public static final int DATA_TYPE_POS = 6;
    public static final int DATA_TYPE_LONG = 7;
    public static final int DATA_TYPE_VECTOR3F = 8;
    public static final int DATA_FLAGS = Utils.dynamic(0);
    public static final int DATA_HEALTH = Utils.dynamic(1);
    public static final int DATA_VARIANT = Utils.dynamic(2);
    public static final int DATA_COLOR;
    public static final int DATA_COLOUR;
    public static final int DATA_NAMETAG;
    public static final int DATA_OWNER_EID;
    public static final int DATA_TARGET_EID;
    public static final int DATA_AIR;
    public static final int DATA_POTION_COLOR;
    public static final int DATA_POTION_AMBIENT;
    public static final int DATA_JUMP_DURATION;
    public static final int DATA_HURT_TIME;
    public static final int DATA_HURT_DIRECTION;
    public static final int DATA_PADDLE_TIME_LEFT;
    public static final int DATA_PADDLE_TIME_RIGHT;
    public static final int DATA_EXPERIENCE_VALUE;
    public static final int DATA_DISPLAY_ITEM;
    public static final int DATA_DISPLAY_OFFSET;
    public static final int DATA_HAS_DISPLAY;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_SWELL;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_OLD_SWELL;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_SWELL_DIR;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_CHARGE_AMOUNT;
    public static final int DATA_ENDERMAN_HELD_RUNTIME_ID;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final int DATA_CLIENT_EVENT;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", reason="Apparently this the ID 24 was reused to represent CLIENT_EVENT but Cloudburst Nukkit is still mapping it as age")
    public static final int DATA_ENTITY_AGE;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final int DATA_USING_ITEM;
    public static final int DATA_PLAYER_FLAGS;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_PLAYER_INDEX;
    public static final int DATA_PLAYER_BED_POSITION;
    public static final int DATA_FIREBALL_POWER_X;
    public static final int DATA_FIREBALL_POWER_Y;
    public static final int DATA_FIREBALL_POWER_Z;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_AUX_POWER;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FISH_X;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FISH_Z;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FISH_ANGLE;
    public static final int DATA_POTION_AUX_VALUE;
    public static final int DATA_LEAD_HOLDER_EID;
    public static final int DATA_SCALE;
    @Since(value="1.4.0.0-PN")
    public static final int DATA_INTERACTIVE_TAG;
    @Deprecated
    @PowerNukkitOnly
    @Since(value="1.2.0.0-PN")
    @DeprecationDetails(by="PowerNukkit", since="1.4.0.0-PN", reason="This is not only for NPC, it's used to display any interactive button text and Nukkit added this constant with a different name", replaceWith="DATA_INTERACTIVE_TAG")
    public static final int DATA_HAS_NPC_COMPONENT;
    public static final int DATA_NPC_SKIN_ID;
    public static final int DATA_URL_TAG;
    public static final int DATA_MAX_AIR;
    public static final int DATA_MARK_VARIANT;
    public static final int DATA_CONTAINER_TYPE;
    public static final int DATA_CONTAINER_BASE_SIZE;
    public static final int DATA_CONTAINER_EXTRA_SLOTS_PER_STRENGTH;
    public static final int DATA_BLOCK_TARGET;
    public static final int DATA_WITHER_INVULNERABLE_TICKS;
    public static final int DATA_WITHER_TARGET_1;
    public static final int DATA_WITHER_TARGET_2;
    public static final int DATA_WITHER_TARGET_3;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_AERIAL_ATTACK;
    public static final int DATA_BOUNDING_BOX_WIDTH;
    public static final int DATA_BOUNDING_BOX_HEIGHT;
    public static final int DATA_FUSE_LENGTH;
    public static final int DATA_RIDER_SEAT_POSITION;
    public static final int DATA_RIDER_ROTATION_LOCKED;
    public static final int DATA_RIDER_MAX_ROTATION;
    public static final int DATA_RIDER_MIN_ROTATION;
    @Since(value="1.4.0.0-PN")
    public static final int DATA_RIDER_ROTATION_OFFSET;
    public static final int DATA_AREA_EFFECT_CLOUD_RADIUS;
    public static final int DATA_AREA_EFFECT_CLOUD_WAITING;
    public static final int DATA_AREA_EFFECT_CLOUD_PARTICLE_ID;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_SHULKER_PEEK_ID;
    public static final int DATA_SHULKER_ATTACH_FACE;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_SHULKER_ATTACHED;
    public static final int DATA_SHULKER_ATTACH_POS;
    public static final int DATA_TRADING_PLAYER_EID;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_TRADING_CAREER;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_HAS_COMMAND_BLOCK;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_COMMAND_BLOCK_COMMAND;
    public static final int DATA_COMMAND_BLOCK_LAST_OUTPUT;
    public static final int DATA_COMMAND_BLOCK_TRACK_OUTPUT;
    public static final int DATA_CONTROLLING_RIDER_SEAT_NUMBER;
    public static final int DATA_STRENGTH;
    public static final int DATA_MAX_STRENGTH;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_SPELL_CASTING_COLOR;
    public static final int DATA_LIMITED_LIFE;
    public static final int DATA_ARMOR_STAND_POSE_INDEX;
    public static final int DATA_ENDER_CRYSTAL_TIME_OFFSET;
    public static final int DATA_ALWAYS_SHOW_NAMETAG;
    public static final int DATA_COLOR_2;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_NAME_AUTHOR;
    public static final int DATA_SCORE_TAG;
    public static final int DATA_BALLOON_ATTACHED_ENTITY;
    public static final int DATA_PUFFERFISH_SIZE;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_BUBBLE_TIME;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_AGENT;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_SITTING_AMOUNT;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_SITTING_AMOUNT_PREVIOUS;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_EATING_COUNTER;
    public static final int DATA_FLAGS_EXTENDED;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_LAYING_AMOUNT;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_LAYING_AMOUNT_PREVIOUS;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_DURATION;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_SPAWN_TIME;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_CHANGE_RATE;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_CHANGE_ON_PICKUP;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_PICKUP_COUNT;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_INTERACT_TEXT;
    public static final int DATA_TRADE_TIER;
    public static final int DATA_MAX_TRADE_TIER;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_TRADE_EXPERIENCE;
    @Since(value="1.1.1.0-PN")
    public static final int DATA_SKIN_ID;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_SPAWNING_FRAMES;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_COMMAND_BLOCK_TICK_DELAY;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_COMMAND_BLOCK_EXECUTE_ON_FIRST_TICK;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_AMBIENT_SOUND_INTERVAL;
    @Since(value="1.3.0.0-PN")
    public static final int DATA_AMBIENT_SOUND_INTERVAL_RANGE;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_AMBIENT_SOUND_EVENT_NAME;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FALL_DAMAGE_MULTIPLIER;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_NAME_RAW_TEXT;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_CAN_RIDE_TARGET;
    @Since(value="1.3.0.0-PN")
    public static final int DATA_LOW_TIER_CURED_DISCOUNT;
    @Since(value="1.3.0.0-PN")
    public static final int DATA_HIGH_TIER_CURED_DISCOUNT;
    @Since(value="1.3.0.0-PN")
    public static final int DATA_NEARBY_CURED_DISCOUNT;
    @Since(value="1.3.0.0-PN")
    public static final int DATA_NEARBY_CURED_DISCOUNT_TIMESTAMP;
    @Since(value="1.3.0.0-PN")
    public static final int DATA_HITBOX;
    @Since(value="1.3.0.0-PN")
    public static final int DATA_IS_BUOYANT;
    @Since(value="1.5.0.0-PN")
    @PowerNukkitOnly
    public static final int DATA_BASE_RUNTIME_ID;
    @Since(value="1.4.0.0-PN")
    public static final int DATA_FREEZING_EFFECT_STRENGTH;
    @Since(value="1.3.0.0-PN")
    public static final int DATA_BUOYANCY_DATA;
    @Since(value="1.4.0.0-PN")
    public static final int DATA_GOAT_HORN_COUNT;
    @Since(value="1.5.0.0-PN")
    @PowerNukkitOnly
    public static final int DATA_UPDATE_PROPERTIES;
    public static final int DATA_FLAG_ONFIRE;
    public static final int DATA_FLAG_SNEAKING;
    public static final int DATA_FLAG_RIDING;
    public static final int DATA_FLAG_SPRINTING;
    public static final int DATA_FLAG_ACTION;
    public static final int DATA_FLAG_INVISIBLE;
    public static final int DATA_FLAG_TEMPTED;
    public static final int DATA_FLAG_INLOVE;
    public static final int DATA_FLAG_SADDLED;
    public static final int DATA_FLAG_POWERED;
    public static final int DATA_FLAG_IGNITED;
    public static final int DATA_FLAG_BABY;
    public static final int DATA_FLAG_CONVERTING;
    public static final int DATA_FLAG_CRITICAL;
    public static final int DATA_FLAG_CAN_SHOW_NAMETAG;
    public static final int DATA_FLAG_ALWAYS_SHOW_NAMETAG;
    public static final int DATA_FLAG_IMMOBILE;
    public static final int DATA_FLAG_NO_AI;
    public static final int DATA_FLAG_SILENT;
    public static final int DATA_FLAG_WALLCLIMBING;
    public static final int DATA_FLAG_CAN_CLIMB;
    public static final int DATA_FLAG_SWIMMER;
    public static final int DATA_FLAG_CAN_FLY;
    public static final int DATA_FLAG_WALKER;
    public static final int DATA_FLAG_RESTING;
    public static final int DATA_FLAG_SITTING;
    public static final int DATA_FLAG_ANGRY;
    public static final int DATA_FLAG_INTERESTED;
    public static final int DATA_FLAG_CHARGED;
    public static final int DATA_FLAG_TAMED;
    public static final int DATA_FLAG_ORPHANED;
    public static final int DATA_FLAG_LEASHED;
    public static final int DATA_FLAG_SHEARED;
    public static final int DATA_FLAG_GLIDING;
    public static final int DATA_FLAG_ELDER;
    public static final int DATA_FLAG_MOVING;
    public static final int DATA_FLAG_BREATHING;
    public static final int DATA_FLAG_CHESTED;
    public static final int DATA_FLAG_STACKABLE;
    public static final int DATA_FLAG_SHOWBASE;
    public static final int DATA_FLAG_REARING;
    public static final int DATA_FLAG_VIBRATING;
    public static final int DATA_FLAG_IDLING;
    public static final int DATA_FLAG_EVOKER_SPELL;
    public static final int DATA_FLAG_CHARGE_ATTACK;
    public static final int DATA_FLAG_WASD_CONTROLLED;
    public static final int DATA_FLAG_CAN_POWER_JUMP;
    public static final int DATA_FLAG_LINGER;
    public static final int DATA_FLAG_HAS_COLLISION;
    public static final int DATA_FLAG_GRAVITY;
    public static final int DATA_FLAG_FIRE_IMMUNE;
    public static final int DATA_FLAG_DANCING;
    public static final int DATA_FLAG_ENCHANTED;
    public static final int DATA_FLAG_SHOW_TRIDENT_ROPE;
    public static final int DATA_FLAG_CONTAINER_PRIVATE;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_IS_TRANSFORMING;
    public static final int DATA_FLAG_SPIN_ATTACK;
    public static final int DATA_FLAG_SWIMMING;
    public static final int DATA_FLAG_BRIBED;
    public static final int DATA_FLAG_PREGNANT;
    public static final int DATA_FLAG_LAYING_EGG;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_RIDER_CAN_PICK;
    @PowerNukkitOnly
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_TRANSITION_SITTING;
    @Deprecated
    @DeprecationDetails(reason="This is from NukkitX but it has a typo which we can't remove unless NukkitX removes from their side.", since="1.2.0.0-PN", replaceWith="DATA_FLAG_TRANSITION_SITTING")
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_TRANSITION_SETTING;
    public static final int DATA_FLAG_EATING;
    public static final int DATA_FLAG_LAYING_DOWN;
    public static final int DATA_FLAG_SNEEZING;
    public static final int DATA_FLAG_TRUSTING;
    public static final int DATA_FLAG_ROLLING;
    public static final int DATA_FLAG_SCARED;
    public static final int DATA_FLAG_IN_SCAFFOLDING;
    public static final int DATA_FLAG_OVER_SCAFFOLDING;
    public static final int DATA_FLAG_FALL_THROUGH_SCAFFOLDING;
    public static final int DATA_FLAG_BLOCKING;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_TRANSITION_BLOCKING;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_BLOCKED_USING_SHIELD;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_BLOCKED_USING_DAMAGED_SHIELD;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_SLEEPING;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_WANTS_TO_WAKE;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_TRADE_INTEREST;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_DOOR_BREAKER;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_BREAKING_OBSTRUCTION;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_DOOR_OPENER;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_IS_ILLAGER_CAPTAIN;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_STUNNED;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_ROARING;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_DELAYED_ATTACK;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_IS_AVOIDING_MOBS;
    @Since(value="1.3.0.0-PN")
    public static final int DATA_FLAG_IS_AVOIDING_BLOCKS;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_FACING_TARGET_TO_RANGE_ATTACK;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_HIDDEN_WHEN_INVISIBLE;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_IS_IN_UI;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_STALKING;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_EMOTING;
    @Since(value="1.2.0.0-PN")
    public static final int DATA_FLAG_CELEBRATING;
    @Since(value="1.3.0.0-PN")
    public static final int DATA_FLAG_ADMIRING;
    @Since(value="1.3.0.0-PN")
    public static final int DATA_FLAG_CELEBRATING_SPECIAL;
    @Since(value="1.4.0.0-PN")
    public static final int DATA_FLAG_RAM_ATTACK;
    @Since(value="1.5.0.0-PN")
    @PowerNukkitOnly
    public static final int DATA_FLAG_PLAYING_DEAD;
    public static long entityCount;
    private static final Map<String, Class<? extends Entity>> knownEntities;
    private static final Map<String, String> shortNames;
    protected final Map<Integer, Player> hasSpawned = new ConcurrentHashMap<Integer, Player>();
    protected final Map<Integer, Effect> effects = new ConcurrentHashMap<Integer, Effect>();
    protected long id;
    protected final EntityMetadata dataProperties = new EntityMetadata().putLong(DATA_FLAGS, 0L).putByte(DATA_COLOR, 0).putShort(DATA_AIR, 400).putShort(DATA_MAX_AIR, 400).putString(DATA_NAMETAG, "").putLong(DATA_LEAD_HOLDER_EID, -1L).putFloat(DATA_SCALE, 1.0f);
    public final List<Entity> passengers = new ArrayList<Entity>();
    public Entity riding = null;
    public FullChunk chunk;
    protected EntityDamageEvent lastDamageCause = null;
    public List<Block> blocksAround = new ArrayList<Block>();
    public List<Block> collisionBlocks = new ArrayList<Block>();
    public double lastX;
    public double lastY;
    public double lastZ;
    public boolean firstMove = true;
    public double motionX;
    public double motionY;
    public double motionZ;
    public Vector3 temporalVector;
    public double lastMotionX;
    public double lastMotionY;
    public double lastMotionZ;
    public double lastYaw;
    public double lastPitch;
    public double pitchDelta;
    public double yawDelta;
    public double entityCollisionReduction = 0.0;
    public AxisAlignedBB boundingBox;
    public boolean onGround;
    public boolean inBlock = false;
    public boolean positionChanged;
    public boolean motionChanged;
    public int deadTicks = 0;
    protected int age = 0;
    protected float health = 20.0f;
    private int maxHealth = 20;
    protected float absorption = 0.0f;
    protected float ySize = 0.0f;
    public boolean keepMovement = false;
    public float fallDistance = 0.0f;
    public int ticksLived = 0;
    public int lastUpdate;
    public int maxFireTicks;
    public int fireTicks = 0;
    public int inPortalTicks = 0;
    @PowerNukkitOnly
    @Since(value="1.2.1.0-PN")
    protected boolean inEndPortal;
    public float scale = 1.0f;
    public CompoundTag namedTag;
    protected boolean isStatic = false;
    public boolean isCollided = false;
    public boolean isCollidedHorizontally = false;
    public boolean isCollidedVertically = false;
    public int noDamageTicks;
    public boolean justCreated;
    public boolean fireProof;
    public boolean invulnerable;
    protected Server server;
    public double highestPosition;
    public boolean closed = false;
    protected Timing timing;
    protected boolean isPlayer = false;
    private volatile boolean initialized;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean noClip = false;

    public abstract int getNetworkId();

    public float getHeight() {
        return 0.0f;
    }

    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public float getCurrentHeight() {
        if (this.isSwimming()) {
            return this.getSwimmingHeight();
        }
        return this.getHeight();
    }

    public float getEyeHeight() {
        return this.getCurrentHeight() / 2.0f + 0.1f;
    }

    public float getWidth() {
        return 0.0f;
    }

    public float getLength() {
        return 0.0f;
    }

    protected double getStepHeight() {
        return 0.0;
    }

    public boolean canCollide() {
        return true;
    }

    protected float getGravity() {
        return 0.0f;
    }

    protected float getDrag() {
        return 0.0f;
    }

    protected float getBaseOffset() {
        return 0.0f;
    }

    public Entity(FullChunk chunk, CompoundTag nbt) {
        if (this instanceof Player) {
            return;
        }
        this.init(chunk, nbt);
    }

    protected void initEntity() {
        if (this.namedTag.contains("ActiveEffects")) {
            ListTag<CompoundTag> effects = this.namedTag.getList("ActiveEffects", CompoundTag.class);
            for (CompoundTag e : effects.getAll()) {
                Effect effect = Effect.getEffect(e.getByte("Id"));
                if (effect == null) continue;
                effect.setAmplifier(e.getByte("Amplifier")).setDuration(e.getInt("Duration")).setVisible(e.getBoolean("ShowParticles"));
                this.addEffect(effect);
            }
        }
        if (this.namedTag.contains("CustomName")) {
            this.setNameTag(this.namedTag.getString("CustomName"));
            if (this.namedTag.contains("CustomNameVisible")) {
                this.setNameTagVisible(this.namedTag.getBoolean("CustomNameVisible"));
            }
            if (this.namedTag.contains("CustomNameAlwaysVisible")) {
                this.setNameTagAlwaysVisible(this.namedTag.getBoolean("CustomNameAlwaysVisible"));
            }
        }
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_HAS_COLLISION, true);
        this.dataProperties.putFloat(DATA_BOUNDING_BOX_HEIGHT, this.getHeight());
        this.dataProperties.putFloat(DATA_BOUNDING_BOX_WIDTH, this.getWidth());
        this.dataProperties.putInt(DATA_HEALTH, (int)this.getHealth());
        this.scheduleUpdate();
    }

    protected final void init(FullChunk chunk, CompoundTag nbt) {
        if (chunk == null || chunk.getProvider() == null) {
            throw new ChunkException("Invalid garbage Chunk given to Entity");
        }
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.timing = Timings.getEntityTiming(this);
        this.isPlayer = this instanceof Player;
        this.temporalVector = new Vector3();
        this.id = entityCount++;
        this.justCreated = true;
        this.namedTag = nbt;
        this.chunk = chunk;
        this.setLevel(chunk.getProvider().getLevel());
        this.server = chunk.getProvider().getLevel().getServer();
        this.boundingBox = new SimpleAxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        ListTag<DoubleTag> posList = this.namedTag.getList("Pos", DoubleTag.class);
        ListTag<FloatTag> rotationList = this.namedTag.getList("Rotation", FloatTag.class);
        ListTag<DoubleTag> motionList = this.namedTag.getList("Motion", DoubleTag.class);
        this.setPositionAndRotation(this.temporalVector.setComponents(posList.get((int)0).data, posList.get((int)1).data, posList.get((int)2).data), rotationList.get((int)0).data, rotationList.get((int)1).data);
        this.setMotion(this.temporalVector.setComponents(motionList.get((int)0).data, motionList.get((int)1).data, motionList.get((int)2).data));
        if (!this.namedTag.contains("FallDistance")) {
            this.namedTag.putFloat("FallDistance", 0.0f);
        }
        this.fallDistance = this.namedTag.getFloat("FallDistance");
        this.highestPosition = this.y + (double)this.namedTag.getFloat("FallDistance");
        if (!this.namedTag.contains("Fire") || this.namedTag.getShort("Fire") > Short.MAX_VALUE) {
            this.namedTag.putShort("Fire", 0);
        }
        this.fireTicks = this.namedTag.getShort("Fire");
        if (!this.namedTag.contains("Air")) {
            this.namedTag.putShort("Air", 300);
        }
        this.setDataProperty(new ShortEntityData(DATA_AIR, this.namedTag.getShort("Air")), false);
        if (!this.namedTag.contains("OnGround")) {
            this.namedTag.putBoolean("OnGround", false);
        }
        this.onGround = this.namedTag.getBoolean("OnGround");
        if (!this.namedTag.contains("Invulnerable")) {
            this.namedTag.putBoolean("Invulnerable", false);
        }
        this.invulnerable = this.namedTag.getBoolean("Invulnerable");
        if (!this.namedTag.contains("Scale")) {
            this.namedTag.putFloat("Scale", 1.0f);
        }
        this.scale = this.namedTag.getFloat("Scale");
        this.setDataProperty(new FloatEntityData(DATA_SCALE, this.scale), false);
        this.setDataProperty(new ByteEntityData(DATA_COLOR, 0), false);
        try {
            this.chunk.addEntity(this);
            this.level.addEntity(this);
            this.initEntity();
            this.lastUpdate = this.server.getTick();
            EntitySpawnEvent event = new EntitySpawnEvent(this);
            this.server.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                this.close(false);
            } else {
                this.scheduleUpdate();
            }
        }
        catch (Exception e) {
            this.close(false);
            throw e;
        }
    }

    public boolean hasCustomName() {
        return !this.getNameTag().isEmpty();
    }

    public String getNameTag() {
        return this.getDataPropertyString(DATA_NAMETAG);
    }

    public boolean isNameTagVisible() {
        return this.getDataFlag(DATA_FLAGS, DATA_FLAG_CAN_SHOW_NAMETAG);
    }

    public boolean isNameTagAlwaysVisible() {
        return this.getDataPropertyByte(DATA_ALWAYS_SHOW_NAMETAG) == 1;
    }

    public void setNameTag(String name) {
        this.setDataProperty(new StringEntityData(DATA_NAMETAG, name));
    }

    public void setNameTagVisible() {
        this.setNameTagVisible(true);
    }

    public void setNameTagVisible(boolean value) {
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_CAN_SHOW_NAMETAG, value);
    }

    public void setNameTagAlwaysVisible() {
        this.setNameTagAlwaysVisible(true);
    }

    public void setNameTagAlwaysVisible(boolean value) {
        this.setDataProperty(new ByteEntityData(DATA_ALWAYS_SHOW_NAMETAG, value ? 1 : 0));
    }

    public void setScoreTag(String score) {
        this.setDataProperty(new StringEntityData(DATA_SCORE_TAG, score));
    }

    public String getScoreTag() {
        return this.getDataPropertyString(DATA_SCORE_TAG);
    }

    public boolean isSneaking() {
        return this.getDataFlag(DATA_FLAGS, DATA_FLAG_SNEAKING);
    }

    public void setSneaking() {
        this.setSneaking(true);
    }

    public void setSneaking(boolean value) {
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_SNEAKING, value);
    }

    public boolean isSwimming() {
        return this.getDataFlag(DATA_FLAGS, DATA_FLAG_SWIMMING);
    }

    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public float getSwimmingHeight() {
        return this.getHeight();
    }

    public void setSwimming() {
        this.setSwimming(true);
    }

    public void setSwimming(boolean value) {
        if (this.isSwimming() == value) {
            return;
        }
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_SWIMMING, value);
        if (Float.compare(this.getSwimmingHeight(), this.getHeight()) != 0) {
            this.recalculateBoundingBox(true);
        }
    }

    public boolean isSprinting() {
        return this.getDataFlag(DATA_FLAGS, DATA_FLAG_SPRINTING);
    }

    public void setSprinting() {
        this.setSprinting(true);
    }

    public void setSprinting(boolean value) {
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_SPRINTING, value);
    }

    public boolean isGliding() {
        return this.getDataFlag(DATA_FLAGS, DATA_FLAG_GLIDING);
    }

    public void setGliding() {
        this.setGliding(true);
    }

    public void setGliding(boolean value) {
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_GLIDING, value);
    }

    public boolean isImmobile() {
        return this.getDataFlag(DATA_FLAGS, DATA_FLAG_IMMOBILE);
    }

    public void setImmobile() {
        this.setImmobile(true);
    }

    public void setImmobile(boolean value) {
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_IMMOBILE, value);
    }

    public boolean canClimb() {
        return this.getDataFlag(DATA_FLAGS, DATA_FLAG_CAN_CLIMB);
    }

    public void setCanClimb() {
        this.setCanClimb(true);
    }

    public void setCanClimb(boolean value) {
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_CAN_CLIMB, value);
    }

    public boolean canClimbWalls() {
        return this.getDataFlag(DATA_FLAGS, DATA_FLAG_WALLCLIMBING);
    }

    public void setCanClimbWalls() {
        this.setCanClimbWalls(true);
    }

    public void setCanClimbWalls(boolean value) {
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_WALLCLIMBING, value);
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.setDataProperty(new FloatEntityData(DATA_SCALE, this.scale));
        this.recalculateBoundingBox();
    }

    public float getScale() {
        return this.scale;
    }

    public List<Entity> getPassengers() {
        return this.passengers;
    }

    public Entity getPassenger() {
        return (Entity)Iterables.getFirst(this.passengers, null);
    }

    public boolean isPassenger(Entity entity) {
        return this.passengers.contains(entity);
    }

    public boolean isControlling(Entity entity) {
        return this.passengers.indexOf(entity) == 0;
    }

    public boolean hasControllingPassenger() {
        return !this.passengers.isEmpty() && this.isControlling(this.passengers.get(0));
    }

    public Entity getRiding() {
        return this.riding;
    }

    public Map<Integer, Effect> getEffects() {
        return this.effects;
    }

    public void removeAllEffects() {
        for (Effect effect : this.effects.values()) {
            this.removeEffect(effect.getId());
        }
    }

    public void removeEffect(int effectId) {
        if (this.effects.containsKey(effectId)) {
            Effect effect = this.effects.get(effectId);
            this.effects.remove(effectId);
            effect.remove(this);
            this.recalculateEffectColor();
        }
    }

    public Effect getEffect(int effectId) {
        return this.effects.getOrDefault(effectId, null);
    }

    public boolean hasEffect(int effectId) {
        return this.effects.containsKey(effectId);
    }

    public void addEffect(Effect effect) {
        if (effect == null) {
            return;
        }
        effect.add(this);
        this.effects.put(effect.getId(), effect);
        this.recalculateEffectColor();
        if (effect.getId() == 21) {
            this.setHealth(this.getHealth() + (float)(4 * (effect.getAmplifier() + 1)));
        }
    }

    public void recalculateBoundingBox() {
        this.recalculateBoundingBox(true);
    }

    public void recalculateBoundingBox(boolean send) {
        float entityHeight = this.getCurrentHeight();
        float height = entityHeight * this.scale;
        double radius = (double)(this.getWidth() * this.scale) / 2.0;
        this.boundingBox.setBounds(this.x - radius, this.y, this.z - radius, this.x + radius, this.y + (double)height, this.z + radius);
        FloatEntityData bbH = new FloatEntityData(DATA_BOUNDING_BOX_HEIGHT, entityHeight);
        FloatEntityData bbW = new FloatEntityData(DATA_BOUNDING_BOX_WIDTH, this.getWidth());
        this.dataProperties.put(bbH);
        this.dataProperties.put(bbW);
        if (send) {
            this.sendData(this.hasSpawned.values().toArray(Player.EMPTY_ARRAY), new EntityMetadata().put(bbH).put(bbW));
        }
    }

    protected void recalculateEffectColor() {
        int[] color = new int[3];
        int count = 0;
        boolean ambient = true;
        for (Effect effect : this.effects.values()) {
            if (!effect.isVisible()) continue;
            int[] c = effect.getColor();
            color[0] = color[0] + c[0] * (effect.getAmplifier() + 1);
            color[1] = color[1] + c[1] * (effect.getAmplifier() + 1);
            color[2] = color[2] + c[2] * (effect.getAmplifier() + 1);
            count += effect.getAmplifier() + 1;
            if (effect.isAmbient()) continue;
            ambient = false;
        }
        if (count > 0) {
            int r = color[0] / count & 0xFF;
            int g = color[1] / count & 0xFF;
            int b = color[2] / count & 0xFF;
            this.setDataProperty(new IntEntityData(DATA_POTION_COLOR, (r << 16) + (g << 8) + b));
            this.setDataProperty(new ByteEntityData(DATA_POTION_AMBIENT, ambient ? 1 : 0));
        } else {
            this.setDataProperty(new IntEntityData(DATA_POTION_COLOR, 0));
            this.setDataProperty(new ByteEntityData(DATA_POTION_AMBIENT, 0));
        }
    }

    @Nullable
    public static Entity createEntity(@Nonnull String name, @Nonnull Position pos, Object ... args) {
        return Entity.createEntity(name, pos.getChunk(), Entity.getDefaultNBT(pos), args);
    }

    @Nullable
    public static Entity createEntity(int type, @Nonnull Position pos, Object ... args) {
        return Entity.createEntity(String.valueOf(type), pos.getChunk(), Entity.getDefaultNBT(pos), args);
    }

    @Nullable
    public static Entity createEntity(@Nonnull String name, @Nonnull FullChunk chunk, @Nonnull CompoundTag nbt, Object ... args) {
        Entity entity = null;
        Class<? extends Entity> clazz = knownEntities.get(name);
        if (clazz != null) {
            ArrayList<Exception> exceptions = null;
            for (Constructor<?> constructor : clazz.getConstructors()) {
                if (entity != null) break;
                if (constructor.getParameterCount() != (args == null ? 2 : args.length + 2)) continue;
                try {
                    if (args == null || args.length == 0) {
                        entity = (Entity)constructor.newInstance(chunk, nbt);
                        continue;
                    }
                    Object[] objects = new Object[args.length + 2];
                    objects[0] = chunk;
                    objects[1] = nbt;
                    System.arraycopy(args, 0, objects, 2, args.length);
                    entity = (Entity)constructor.newInstance(objects);
                }
                catch (Exception e) {
                    if (exceptions == null) {
                        exceptions = new ArrayList<Exception>();
                    }
                    exceptions.add(e);
                }
            }
            if (entity == null) {
                IllegalArgumentException cause = new IllegalArgumentException("Could not create an entity of type " + name, exceptions != null && exceptions.size() > 0 ? (Throwable)exceptions.get(0) : null);
                if (exceptions != null && exceptions.size() > 1) {
                    for (int i = 1; i < exceptions.size(); ++i) {
                        cause.addSuppressed((Throwable)exceptions.get(i));
                    }
                }
                log.debug("Could not create an entity of type {} with {} args", (Object)name, (Object)(args == null ? 0 : args.length), (Object)cause);
            }
        } else {
            log.debug("Entity type {} is unknown", (Object)name);
        }
        return entity;
    }

    @Nullable
    public static Entity createEntity(int type, @Nonnull FullChunk chunk, @Nonnull CompoundTag nbt, Object ... args) {
        return Entity.createEntity(String.valueOf(type), chunk, nbt, args);
    }

    public static boolean registerEntity(String name, Class<? extends Entity> clazz) {
        return Entity.registerEntity(name, clazz, false);
    }

    public static boolean registerEntity(String name, Class<? extends Entity> clazz, boolean force) {
        block3: {
            if (clazz == null) {
                return false;
            }
            try {
                int networkId = clazz.getField("NETWORK_ID").getInt(null);
                knownEntities.put(String.valueOf(networkId), clazz);
            }
            catch (Exception e) {
                if (force) break block3;
                return false;
            }
        }
        knownEntities.put(name, clazz);
        shortNames.put(clazz.getSimpleName(), name);
        return true;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public static IntCollection getKnownEntityIds() {
        return (IntCollection)knownEntities.keySet().stream().filter(Utils::isInteger).mapToInt(Integer::parseInt).collect(IntArrayList::new, IntArrayList::add, AbstractIntList::addAll);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public static List<String> getSaveIds() {
        return new ArrayList<String>(shortNames.values());
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public static OptionalInt getSaveId(String id) {
        Class<? extends Entity> entityClass = knownEntities.get(id);
        if (entityClass == null) {
            return OptionalInt.empty();
        }
        return knownEntities.entrySet().stream().filter(entry -> ((Class)entry.getValue()).equals(entityClass)).map(Map.Entry::getKey).filter(Utils::isInteger).mapToInt(Integer::parseInt).findFirst();
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public static String getSaveId(int id) {
        Class<? extends Entity> entityClass = knownEntities.get(Integer.toString(id));
        if (entityClass == null) {
            return null;
        }
        return shortNames.get(entityClass.getSimpleName());
    }

    @Nonnull
    public static CompoundTag getDefaultNBT(@Nonnull Vector3 pos) {
        return Entity.getDefaultNBT(pos, null);
    }

    @Nonnull
    public static CompoundTag getDefaultNBT(@Nonnull Vector3 pos, @Nullable Vector3 motion) {
        Location loc;
        Location location = loc = pos instanceof Location ? (Location)pos : null;
        if (loc != null) {
            return Entity.getDefaultNBT(pos, motion, (float)loc.getYaw(), (float)loc.getPitch());
        }
        return Entity.getDefaultNBT(pos, motion, 0.0f, 0.0f);
    }

    @Nonnull
    public static CompoundTag getDefaultNBT(@Nonnull Vector3 pos, @Nullable Vector3 motion, float yaw, float pitch) {
        return new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", pos.x)).add(new DoubleTag("", pos.y)).add(new DoubleTag("", pos.z))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", motion != null ? motion.x : 0.0)).add(new DoubleTag("", motion != null ? motion.y : 0.0)).add(new DoubleTag("", motion != null ? motion.z : 0.0))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", yaw)).add(new FloatTag("", pitch)));
    }

    public void saveNBT() {
        if (!(this instanceof Player)) {
            this.namedTag.putString("id", this.getSaveId());
            if (!this.getNameTag().equals("")) {
                this.namedTag.putString("CustomName", this.getNameTag());
                this.namedTag.putBoolean("CustomNameVisible", this.isNameTagVisible());
                this.namedTag.putBoolean("CustomNameAlwaysVisible", this.isNameTagAlwaysVisible());
            } else {
                this.namedTag.remove("CustomName");
                this.namedTag.remove("CustomNameVisible");
                this.namedTag.remove("CustomNameAlwaysVisible");
            }
        }
        this.namedTag.putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("0", this.x)).add(new DoubleTag("1", this.y)).add(new DoubleTag("2", this.z)));
        this.namedTag.putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("0", this.motionX)).add(new DoubleTag("1", this.motionY)).add(new DoubleTag("2", this.motionZ)));
        this.namedTag.putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("0", (float)this.yaw)).add(new FloatTag("1", (float)this.pitch)));
        this.namedTag.putFloat("FallDistance", this.fallDistance);
        this.namedTag.putShort("Fire", this.fireTicks);
        this.namedTag.putShort("Air", this.getDataPropertyShort(DATA_AIR));
        this.namedTag.putBoolean("OnGround", this.onGround);
        this.namedTag.putBoolean("Invulnerable", this.invulnerable);
        this.namedTag.putFloat("Scale", this.scale);
        if (!this.effects.isEmpty()) {
            ListTag<CompoundTag> list = new ListTag<CompoundTag>("ActiveEffects");
            for (Effect effect : this.effects.values()) {
                list.add(new CompoundTag(String.valueOf(effect.getId())).putByte("Id", effect.getId()).putByte("Amplifier", effect.getAmplifier()).putInt("Duration", effect.getDuration()).putBoolean("Ambient", false).putBoolean("ShowParticles", effect.isVisible()));
            }
            this.namedTag.putList(list);
        } else {
            this.namedTag.remove("ActiveEffects");
        }
    }

    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public String getOriginalName() {
        return this.getSaveId();
    }

    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public final String getVisibleName() {
        String name = this.getName();
        if (!TextFormat.clean(name).trim().isEmpty()) {
            return name;
        }
        return this.getOriginalName();
    }

    @Nonnull
    public String getName() {
        if (this.hasCustomName()) {
            return this.getNameTag();
        }
        return this.getOriginalName();
    }

    public final String getSaveId() {
        return shortNames.getOrDefault(this.getClass().getSimpleName(), "");
    }

    public void spawnTo(Player player) {
        if (!this.hasSpawned.containsKey(player.getLoaderId()) && this.chunk != null && player.usedChunks.containsKey(Level.chunkHash(this.chunk.getX(), this.chunk.getZ()))) {
            this.hasSpawned.put(player.getLoaderId(), player);
            player.dataPacket(this.createAddEntityPacket());
        }
        if (this.riding != null) {
            this.riding.spawnTo(player);
            SetEntityLinkPacket pkk = new SetEntityLinkPacket();
            pkk.vehicleUniqueId = this.riding.getId();
            pkk.riderUniqueId = this.getId();
            pkk.type = 1;
            pkk.immediate = 1;
            player.dataPacket(pkk);
        }
    }

    protected DataPacket createAddEntityPacket() {
        AddEntityPacket addEntity = new AddEntityPacket();
        addEntity.type = this.getNetworkId();
        addEntity.entityUniqueId = this.getId();
        addEntity.entityRuntimeId = this.getId();
        addEntity.yaw = (float)this.yaw;
        addEntity.headYaw = (float)this.yaw;
        addEntity.pitch = (float)this.pitch;
        addEntity.x = (float)this.x;
        addEntity.y = (float)this.y;
        addEntity.z = (float)this.z;
        addEntity.speedX = (float)this.motionX;
        addEntity.speedY = (float)this.motionY;
        addEntity.speedZ = (float)this.motionZ;
        addEntity.metadata = this.dataProperties;
        addEntity.links = new EntityLink[this.passengers.size()];
        for (int i = 0; i < addEntity.links.length; ++i) {
            addEntity.links[i] = new EntityLink(this.getId(), this.passengers.get(i).getId(), i == 0 ? (byte)1 : 2, false, false);
        }
        return addEntity;
    }

    public Map<Integer, Player> getViewers() {
        return this.hasSpawned;
    }

    public void sendPotionEffects(Player player) {
        for (Effect effect : this.effects.values()) {
            MobEffectPacket pk = new MobEffectPacket();
            pk.eid = this.getId();
            pk.effectId = effect.getId();
            pk.amplifier = effect.getAmplifier();
            pk.particles = effect.isVisible();
            pk.duration = effect.getDuration();
            pk.eventId = 1;
            player.dataPacket(pk);
        }
    }

    public void sendData(Player player) {
        this.sendData(player, null);
    }

    public void sendData(Player player, EntityMetadata data) {
        SetEntityDataPacket pk = new SetEntityDataPacket();
        pk.eid = this.getId();
        pk.metadata = data == null ? this.dataProperties : data;
        player.dataPacket(pk);
    }

    public void sendData(Player[] players) {
        this.sendData(players, null);
    }

    public void sendData(Player[] players, EntityMetadata data) {
        SetEntityDataPacket pk = new SetEntityDataPacket();
        pk.eid = this.getId();
        pk.metadata = data == null ? this.dataProperties : data;
        for (Player player : players) {
            if (player == this) continue;
            player.dataPacket(pk.clone());
        }
        if (this instanceof Player) {
            ((Player)this).dataPacket(pk);
        }
    }

    public void despawnFrom(Player player) {
        if (this.hasSpawned.containsKey(player.getLoaderId())) {
            RemoveEntityPacket pk = new RemoveEntityPacket();
            pk.eid = this.getId();
            player.dataPacket(pk);
            this.hasSpawned.remove(player.getLoaderId());
        }
    }

    public boolean attack(EntityDamageEvent source) {
        if (this.hasEffect(12) && (source.getCause() == EntityDamageEvent.DamageCause.FIRE || source.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK || source.getCause() == EntityDamageEvent.DamageCause.LAVA)) {
            return false;
        }
        this.getServer().getPluginManager().callEvent(source);
        if (source.isCancelled()) {
            return false;
        }
        if (this.absorption > 0.0f) {
            this.setAbsorption(Math.max(0.0f, this.getAbsorption() + source.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION)));
        }
        this.setLastDamageCause(source);
        float newHealth = this.getHealth() - source.getFinalDamage();
        if (newHealth < 1.0f && this instanceof Player && source.getCause() != EntityDamageEvent.DamageCause.VOID && source.getCause() != EntityDamageEvent.DamageCause.SUICIDE) {
            Player p = (Player)this;
            boolean totem = false;
            if (p.getOffhandInventory().getItem(0).getId() == 450) {
                p.getOffhandInventory().clear(0);
                totem = true;
            } else if (p.getInventory().getItemInHand().getId() == 450) {
                p.getInventory().clear(p.getInventory().getHeldItemIndex());
                totem = true;
            }
            if (totem) {
                this.getLevel().addLevelEvent(this, 1052);
                this.getLevel().addParticleEffect(this, ParticleEffect.TOTEM);
                this.extinguish();
                this.removeAllEffects();
                this.setHealth(1.0f);
                this.addEffect(Effect.getEffect(10).setDuration(800).setAmplifier(1));
                this.addEffect(Effect.getEffect(12).setDuration(800));
                this.addEffect(Effect.getEffect(22).setDuration(100).setAmplifier(1));
                EntityEventPacket pk = new EntityEventPacket();
                pk.eid = this.getId();
                pk.event = 65;
                p.dataPacket(pk);
                source.setCancelled(true);
                return false;
            }
        }
        Entity attacker = source instanceof EntityDamageByEntityEvent ? ((EntityDamageByEntityEvent)source).getDamager() : null;
        for (SideEffect sideEffect : source.getSideEffects()) {
            sideEffect.doPreHealthChange(this, source, attacker);
        }
        this.setHealth(newHealth);
        return true;
    }

    public boolean attack(float damage) {
        return this.attack(new EntityDamageEvent(this, EntityDamageEvent.DamageCause.CUSTOM, damage));
    }

    public void heal(EntityRegainHealthEvent source) {
        this.server.getPluginManager().callEvent(source);
        if (source.isCancelled()) {
            return;
        }
        this.setHealth(this.getHealth() + source.getAmount());
    }

    public void heal(float amount) {
        this.heal(new EntityRegainHealthEvent(this, amount, 0));
    }

    public float getHealth() {
        return this.health;
    }

    public boolean isAlive() {
        return this.health > 0.0f;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setHealth(float health) {
        if (this.health == health) {
            return;
        }
        if (health < 1.0f) {
            if (this.isAlive()) {
                this.kill();
            }
        } else {
            this.health = health <= (float)this.getMaxHealth() || health < this.health ? health : (float)this.getMaxHealth();
        }
        this.setDataProperty(new IntEntityData(DATA_HEALTH, (int)this.health));
    }

    public void setLastDamageCause(EntityDamageEvent type) {
        this.lastDamageCause = type;
    }

    public EntityDamageEvent getLastDamageCause() {
        return this.lastDamageCause;
    }

    public int getMaxHealth() {
        return this.maxHealth + (this.hasEffect(21) ? 4 * (this.getEffect(21).getAmplifier() + 1) : 0);
    }

    public void setMaxHealth(int maxHealth) {
        this.maxHealth = maxHealth;
    }

    public boolean canCollideWith(Entity entity) {
        return !this.justCreated && this != entity;
    }

    protected boolean checkObstruction(double x, double y, double z) {
        if (this.level.getCollisionCubes(this, this.getBoundingBox(), false).length == 0 || this.noClip) {
            return false;
        }
        int i = NukkitMath.floorDouble(x);
        int j = NukkitMath.floorDouble(y);
        int k = NukkitMath.floorDouble(z);
        double diffX = x - (double)i;
        double diffY = y - (double)j;
        double diffZ = z - (double)k;
        if (!Block.transparent[this.level.getBlockIdAt(i, j, k)]) {
            boolean flag = Block.transparent[this.level.getBlockIdAt(i - 1, j, k)];
            boolean flag1 = Block.transparent[this.level.getBlockIdAt(i + 1, j, k)];
            boolean flag2 = Block.transparent[this.level.getBlockIdAt(i, j - 1, k)];
            boolean flag3 = Block.transparent[this.level.getBlockIdAt(i, j + 1, k)];
            boolean flag4 = Block.transparent[this.level.getBlockIdAt(i, j, k - 1)];
            boolean flag5 = Block.transparent[this.level.getBlockIdAt(i, j, k + 1)];
            int direction = -1;
            double limit = 9999.0;
            if (flag) {
                limit = diffX;
                direction = 0;
            }
            if (flag1 && 1.0 - diffX < limit) {
                limit = 1.0 - diffX;
                direction = 1;
            }
            if (flag2 && diffY < limit) {
                limit = diffY;
                direction = 2;
            }
            if (flag3 && 1.0 - diffY < limit) {
                limit = 1.0 - diffY;
                direction = 3;
            }
            if (flag4 && diffZ < limit) {
                limit = diffZ;
                direction = 4;
            }
            if (flag5 && 1.0 - diffZ < limit) {
                direction = 5;
            }
            double force = ThreadLocalRandom.current().nextDouble() * 0.2 + 0.1;
            if (direction == 0) {
                this.motionX = -force;
                return true;
            }
            if (direction == 1) {
                this.motionX = force;
                return true;
            }
            if (direction == 2) {
                this.motionY = -force;
                return true;
            }
            if (direction == 3) {
                this.motionY = force;
                return true;
            }
            if (direction == 4) {
                this.motionZ = -force;
                return true;
            }
            if (direction == 5) {
                this.motionZ = force;
                return true;
            }
        }
        return false;
    }

    public boolean entityBaseTick() {
        return this.entityBaseTick(1);
    }

    public boolean entityBaseTick(int tickDiff) {
        Timings.entityBaseTickTimer.startTiming();
        if (!this.isPlayer) {
            this.blocksAround = null;
            this.collisionBlocks = null;
        }
        this.justCreated = false;
        if (!this.isAlive()) {
            this.removeAllEffects();
            this.despawnFromAll();
            if (!this.isPlayer) {
                this.close();
            }
            Timings.entityBaseTickTimer.stopTiming();
            return false;
        }
        if (this.riding != null && !this.riding.isAlive() && this.riding instanceof EntityRideable) {
            ((EntityRideable)((Object)this.riding)).mountEntity(this);
        }
        this.updatePassengers();
        if (!this.effects.isEmpty()) {
            for (Effect effect : this.effects.values()) {
                if (effect.canTick()) {
                    effect.applyEffect(this);
                }
                effect.setDuration(effect.getDuration() - tickDiff);
                if (effect.getDuration() > 0) continue;
                this.removeEffect(effect.getId());
            }
        }
        boolean hasUpdate = false;
        this.checkBlockCollision();
        if (this.y <= -16.0 && this.isAlive()) {
            if (this instanceof Player) {
                Player player = (Player)this;
                if (!player.isCreative()) {
                    this.attack(new EntityDamageEvent(this, EntityDamageEvent.DamageCause.VOID, 10.0f));
                }
            } else {
                this.attack(new EntityDamageEvent(this, EntityDamageEvent.DamageCause.VOID, 10.0f));
                hasUpdate = true;
            }
        }
        if (this.fireTicks > 0) {
            if (this.fireProof) {
                this.fireTicks -= 4 * tickDiff;
                if (this.fireTicks < 0) {
                    this.fireTicks = 0;
                }
            } else {
                if (!(this.hasEffect(12) || this.fireTicks % 20 != 0 && tickDiff <= 20)) {
                    this.attack(new EntityDamageEvent(this, EntityDamageEvent.DamageCause.FIRE_TICK, 1.0f));
                }
                this.fireTicks -= tickDiff;
            }
            if (this.fireTicks <= 0) {
                this.extinguish();
            } else if (!(this.fireProof || this instanceof Player && ((Player)this).isSpectator())) {
                this.setDataFlag(DATA_FLAGS, DATA_FLAG_ONFIRE, true);
                hasUpdate = true;
            }
        }
        if (this.noDamageTicks > 0) {
            this.noDamageTicks -= tickDiff;
            if (this.noDamageTicks < 0) {
                this.noDamageTicks = 0;
            }
        }
        if (this.inPortalTicks == 80) {
            Position newPos;
            EntityPortalEnterEvent ev = new EntityPortalEnterEvent(this, EntityPortalEnterEvent.PortalType.NETHER);
            this.getServer().getPluginManager().callEvent(ev);
            if (!(ev.isCancelled() || this.level != EnumLevel.OVERWORLD.getLevel() && this.level != EnumLevel.NETHER.getLevel() || (newPos = EnumLevel.moveToNether(this)) == null)) {
                Position nearestPortal = this.getNearestValidPortal(newPos);
                if (nearestPortal != null) {
                    this.teleport(nearestPortal.add(0.5, 0.0, 0.5), PlayerTeleportEvent.TeleportCause.NETHER_PORTAL);
                } else {
                    final Position finalPos = newPos.add(1.5, 1.0, 1.5);
                    if (this.teleport(finalPos, PlayerTeleportEvent.TeleportCause.NETHER_PORTAL)) {
                        this.server.getScheduler().scheduleDelayedTask(new Task(){

                            @Override
                            public void onRun(int currentTick) {
                                Entity.this.inPortalTicks = 81;
                                Entity.this.teleport(finalPos, PlayerTeleportEvent.TeleportCause.NETHER_PORTAL);
                                BlockNetherPortal.spawnPortal(newPos);
                            }
                        }, 5);
                    }
                }
            }
        }
        this.age += tickDiff;
        this.ticksLived += tickDiff;
        ++TimingsHistory.activatedEntityTicks;
        Timings.entityBaseTickTimer.stopTiming();
        return hasUpdate;
    }

    private Position getNearestValidPortal(Position currentPos) {
        BiPredicate<BlockVector3, BlockState> condition;
        SimpleAxisAlignedBB axisAlignedBB = new SimpleAxisAlignedBB(new Vector3((double)currentPos.getFloorX() - 128.0, 1.0, (double)currentPos.getFloorZ() - 128.0), new Vector3((double)currentPos.getFloorX() + 128.0, currentPos.level.getDimension() == 1 ? 128.0 : 256.0, (double)currentPos.getFloorZ() + 128.0));
        List<Block> blocks = currentPos.level.scanBlocks(axisAlignedBB, condition = (pos, state) -> state.getBlockId() == 90);
        if (blocks.isEmpty()) {
            return null;
        }
        Vector2 currentPosV2 = new Vector2(currentPos.getFloorX(), currentPos.getFloorZ());
        double by = currentPos.getFloorY();
        Comparator<Block> euclideanDistance = Comparator.comparingDouble(block -> currentPosV2.distanceSquared(block.getFloorX(), block.getFloorZ()));
        Comparator<Block> heightDistance = Comparator.comparingDouble(block -> {
            double ey = by - block.y;
            return ey * ey;
        });
        Block nearestPortal = blocks.stream().filter(block -> block.down().getId() != 90).min(euclideanDistance.thenComparing(heightDistance)).orElse(null);
        if (nearestPortal == null) {
            return null;
        }
        return nearestPortal;
    }

    public void updateMovement() {
        double diffPosition = (this.x - this.lastX) * (this.x - this.lastX) + (this.y - this.lastY) * (this.y - this.lastY) + (this.z - this.lastZ) * (this.z - this.lastZ);
        double diffRotation = (this.yaw - this.lastYaw) * (this.yaw - this.lastYaw) + (this.pitch - this.lastPitch) * (this.pitch - this.lastPitch);
        double diffMotion = (this.motionX - this.lastMotionX) * (this.motionX - this.lastMotionX) + (this.motionY - this.lastMotionY) * (this.motionY - this.lastMotionY) + (this.motionZ - this.lastMotionZ) * (this.motionZ - this.lastMotionZ);
        if (diffPosition > 1.0E-4 || diffRotation > 1.0) {
            this.lastX = this.x;
            this.lastY = this.y;
            this.lastZ = this.z;
            this.lastYaw = this.yaw;
            this.lastPitch = this.pitch;
            this.addMovement(this.x, this.y + (double)this.getBaseOffset(), this.z, this.yaw, this.pitch, this.yaw);
            this.positionChanged = true;
        } else {
            this.positionChanged = false;
        }
        if (diffMotion > 0.0025 || diffMotion > 1.0E-4 && this.getMotion().lengthSquared() <= 1.0E-4) {
            this.lastMotionX = this.motionX;
            this.lastMotionY = this.motionY;
            this.lastMotionZ = this.motionZ;
            this.addMotion(this.motionX, this.motionY, this.motionZ);
        }
    }

    public void addMovement(double x, double y, double z, double yaw, double pitch, double headYaw) {
        this.level.addEntityMovement(this, x, y, z, yaw, pitch, headYaw);
    }

    public void addMotion(double motionX, double motionY, double motionZ) {
        SetEntityMotionPacket pk = new SetEntityMotionPacket();
        pk.eid = this.id;
        pk.motionX = (float)motionX;
        pk.motionY = (float)motionY;
        pk.motionZ = (float)motionZ;
        Server.broadcastPacket(this.hasSpawned.values(), (DataPacket)pk);
    }

    @Override
    public Vector3 getDirectionVector() {
        Vector3 vector = super.getDirectionVector();
        return this.temporalVector.setComponents(vector.x, vector.y, vector.z);
    }

    public Vector2 getDirectionPlane() {
        return new Vector2((float)(-Math.cos(Math.toRadians(this.yaw) - 1.5707963267948966)), (float)(-Math.sin(Math.toRadians(this.yaw) - 1.5707963267948966))).normalize();
    }

    public BlockFace getHorizontalFacing() {
        return BlockFace.fromHorizontalIndex(NukkitMath.floorDouble(this.yaw * 4.0 / 360.0 + 0.5) & 3);
    }

    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        if (!this.isAlive()) {
            ++this.deadTicks;
            if (this.deadTicks >= 10) {
                this.despawnFromAll();
                if (!this.isPlayer) {
                    this.close();
                }
            }
            return this.deadTicks < 10;
        }
        int tickDiff = currentTick - this.lastUpdate;
        if (tickDiff <= 0) {
            return false;
        }
        this.lastUpdate = currentTick;
        boolean hasUpdate = this.entityBaseTick(tickDiff);
        this.updateMovement();
        return hasUpdate;
    }

    public boolean mountEntity(Entity entity) {
        return this.mountEntity(entity, (byte)1);
    }

    public boolean mountEntity(Entity entity, byte mode) {
        Objects.requireNonNull(entity, "The target of the mounting entity can't be null");
        if (entity.riding != null) {
            this.dismountEntity(entity);
        } else {
            if (this.isPassenger(entity)) {
                return false;
            }
            EntityVehicleEnterEvent ev = new EntityVehicleEnterEvent(entity, this);
            this.server.getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return false;
            }
            this.broadcastLinkPacket(entity, mode);
            entity.riding = this;
            entity.setDataFlag(DATA_FLAGS, DATA_FLAG_RIDING, true);
            this.passengers.add(entity);
            entity.setSeatPosition(this.getMountedOffset(entity));
            this.updatePassengerPosition(entity);
        }
        return true;
    }

    public boolean dismountEntity(Entity entity) {
        EntityVehicleExitEvent ev = new EntityVehicleExitEvent(entity, this);
        this.server.getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return false;
        }
        this.broadcastLinkPacket(entity, (byte)0);
        entity.riding = null;
        entity.setDataFlag(DATA_FLAGS, DATA_FLAG_RIDING, false);
        this.passengers.remove(entity);
        entity.setSeatPosition(new Vector3f());
        this.updatePassengerPosition(entity);
        return true;
    }

    protected void broadcastLinkPacket(Entity rider, byte type) {
        SetEntityLinkPacket pk = new SetEntityLinkPacket();
        pk.vehicleUniqueId = this.getId();
        pk.riderUniqueId = rider.getId();
        pk.type = type;
        Server.broadcastPacket(this.hasSpawned.values(), (DataPacket)pk);
    }

    public void updatePassengers() {
        if (this.passengers.isEmpty()) {
            return;
        }
        for (Entity passenger : new ArrayList<Entity>(this.passengers)) {
            if (!passenger.isAlive()) {
                this.dismountEntity(passenger);
                continue;
            }
            this.updatePassengerPosition(passenger);
        }
    }

    protected void updatePassengerPosition(Entity passenger) {
        passenger.setPosition(this.add(passenger.getSeatPosition().asVector3()));
    }

    public void setSeatPosition(Vector3f pos) {
        this.setDataProperty(new Vector3fEntityData(DATA_RIDER_SEAT_POSITION, pos));
    }

    public Vector3f getSeatPosition() {
        return this.getDataPropertyVector3f(DATA_RIDER_SEAT_POSITION);
    }

    public Vector3f getMountedOffset(Entity entity) {
        return new Vector3f(0.0f, this.getHeight() * 0.75f);
    }

    public final void scheduleUpdate() {
        this.level.updateEntities.put(this.id, (Object)this);
    }

    public boolean isOnFire() {
        return this.fireTicks > 0;
    }

    public void setOnFire(int seconds) {
        int ticks = seconds * 20;
        if (ticks > this.fireTicks) {
            this.fireTicks = ticks;
        }
    }

    public float getAbsorption() {
        return this.absorption;
    }

    public void setAbsorption(float absorption) {
        if (absorption != this.absorption) {
            this.absorption = absorption;
            if (this instanceof Player) {
                ((Player)this).setAttribute(Attribute.getAttribute(0).setValue(absorption));
            }
        }
    }

    public boolean canBePushed() {
        return true;
    }

    public BlockFace getDirection() {
        double rotation = this.yaw % 360.0;
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        if (0.0 <= rotation && rotation < 45.0 || 315.0 <= rotation && rotation < 360.0) {
            return BlockFace.SOUTH;
        }
        if (45.0 <= rotation && rotation < 135.0) {
            return BlockFace.WEST;
        }
        if (135.0 <= rotation && rotation < 225.0) {
            return BlockFace.NORTH;
        }
        if (225.0 <= rotation && rotation < 315.0) {
            return BlockFace.EAST;
        }
        return null;
    }

    public void extinguish() {
        this.fireTicks = 0;
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_ONFIRE, false);
    }

    public boolean canTriggerWalking() {
        return true;
    }

    public void resetFallDistance() {
        this.highestPosition = 0.0;
    }

    protected void updateFallState(boolean onGround) {
        if (onGround) {
            this.fallDistance = (float)(this.highestPosition - this.y);
            if (this.fallDistance > 0.0f) {
                if (this instanceof EntityLiving && !(this.getLevelBlock() instanceof BlockWater)) {
                    this.fall(this.fallDistance);
                }
                this.resetFallDistance();
            }
        }
    }

    public AxisAlignedBB getBoundingBox() {
        return this.boundingBox;
    }

    public void fall(float fallDistance) {
        if (this.hasEffect(27)) {
            return;
        }
        float damage = (float)Math.floor(fallDistance - 3.0f - (float)(this.hasEffect(8) ? this.getEffect(8).getAmplifier() + 1 : 0));
        Location floorLocation = this.floor();
        Block down = this.level.getBlock(floorLocation.down());
        if (damage > 0.0f) {
            if (down instanceof BlockHayBale) {
                damage -= damage * 0.8f;
            }
            if (down.getId() == 475) {
                damage *= 0.2f;
            }
            if (!this.isPlayer || this.level.getGameRules().getBoolean(GameRule.FALL_DAMAGE)) {
                this.attack(new EntityDamageEvent(this, EntityDamageEvent.DamageCause.FALL, damage));
            }
        }
        if ((double)fallDistance > 0.75) {
            if (down.getId() == 60) {
                if (this.onPhysicalInteraction(down, false)) {
                    return;
                }
                this.level.setBlock((Vector3)down, new BlockDirt(), false, true);
                return;
            }
            Block floor = this.level.getBlock(floorLocation);
            if (floor instanceof BlockTurtleEgg) {
                if (this.onPhysicalInteraction(floor, ThreadLocalRandom.current().nextInt(10) >= 3)) {
                    return;
                }
                this.level.useBreakOn(this, null, null, true);
            }
        }
    }

    private boolean onPhysicalInteraction(Block block, boolean cancelled) {
        Event ev = this instanceof Player ? new PlayerInteractEvent((Player)this, null, block, null, PlayerInteractEvent.Action.PHYSICAL) : new EntityInteractEvent(this, block);
        ev.setCancelled(cancelled);
        this.server.getPluginManager().callEvent(ev);
        return ev.isCancelled();
    }

    public void handleLavaMovement() {
    }

    public void moveFlying(float strafe, float forward, float friction) {
        float speed = strafe * strafe + forward * forward;
        if (speed >= 1.0E-4f) {
            if ((speed = MathHelper.sqrt(speed)) < 1.0f) {
                speed = 1.0f;
            }
            speed = friction / speed;
            float nest = MathHelper.sin((float)(this.yaw * 3.1415927410125732 / 180.0));
            float place = MathHelper.cos((float)(this.yaw * 3.1415927410125732 / 180.0));
            this.motionX += (double)((strafe *= speed) * place - (forward *= speed) * nest);
            this.motionZ += (double)(forward * place + strafe * nest);
        }
    }

    public void onCollideWithPlayer(EntityHuman entityPlayer) {
    }

    public void applyEntityCollision(Entity entity) {
        double dy;
        double dx;
        double dz;
        if (entity.riding != this && !entity.passengers.contains(this) && (dz = NukkitMath.getDirection(dx = entity.x - this.x, dy = entity.z - this.z)) >= (double)0.01f) {
            dz = MathHelper.sqrt((float)dz);
            dx /= dz;
            dy /= dz;
            double d3 = 1.0 / dz;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            dx *= d3;
            dy *= d3;
            dx *= (double)0.05f;
            dy *= (double)0.05f;
            dx *= 1.0 + this.entityCollisionReduction;
            if (this.riding == null) {
                this.motionX -= dx;
                this.motionZ -= dy;
            }
        }
    }

    public void onStruckByLightning(Entity entity) {
        if (this.attack(new EntityDamageByEntityEvent(entity, this, EntityDamageEvent.DamageCause.LIGHTNING, 5.0f)) && this.fireTicks < 160) {
            this.setOnFire(8);
        }
    }

    public void onPushByPiston(BlockEntityPistonArm piston) {
    }

    public boolean onInteract(Player player, Item item, Vector3 clickedPos) {
        return this.onInteract(player, item);
    }

    public boolean onInteract(Player player, Item item) {
        return false;
    }

    protected boolean switchLevel(Level targetLevel) {
        if (this.closed) {
            return false;
        }
        if (this.isValid()) {
            EntityLevelChangeEvent ev = new EntityLevelChangeEvent(this, this.level, targetLevel);
            this.server.getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return false;
            }
            this.level.removeEntity(this);
            if (this.chunk != null) {
                this.chunk.removeEntity(this);
            }
            this.despawnFromAll();
        }
        this.setLevel(targetLevel);
        this.level.addEntity(this);
        this.chunk = null;
        return true;
    }

    public Position getPosition() {
        return new Position(this.x, this.y, this.z, this.level);
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return new Location(this.x, this.y, this.z, this.yaw, this.pitch, this.level);
    }

    public boolean isTouchingWater() {
        return this.hasWaterAt(0.0f) || this.hasWaterAt(this.getEyeHeight());
    }

    public boolean isInsideOfWater() {
        return this.hasWaterAt(this.getEyeHeight());
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected boolean hasWaterAt(float height) {
        double y = this.y + (double)height;
        Block block = this.level.getBlock(this.temporalVector.setComponents(NukkitMath.floorDouble(this.x), NukkitMath.floorDouble(y), NukkitMath.floorDouble(this.z)));
        boolean layer1 = false;
        if (!(block instanceof BlockBubbleColumn) && (block instanceof BlockWater || (layer1 = block.getLevelBlockAtLayer(1) instanceof BlockWater))) {
            BlockWater water = (BlockWater)(layer1 ? block.getLevelBlockAtLayer(1) : block);
            double f = block.y + 1.0 - ((double)water.getFluidHeightPercent() - 0.1111111);
            return y < f;
        }
        return false;
    }

    public boolean isInsideOfSolid() {
        double y = this.y + (double)this.getEyeHeight();
        Block block = this.level.getBlock(this.temporalVector.setComponents(NukkitMath.floorDouble(this.x), NukkitMath.floorDouble(y), NukkitMath.floorDouble(this.z)));
        AxisAlignedBB bb = block.getBoundingBox();
        return bb != null && block.isSolid() && !block.isTransparent() && bb.intersectsWith(this.getBoundingBox());
    }

    public boolean isInsideOfFire() {
        for (Block block : this.getCollisionBlocks()) {
            if (!(block instanceof BlockFire)) continue;
            return true;
        }
        return false;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public <T extends Block> boolean collideWithBlock(Class<T> classType) {
        for (Block block : this.getCollisionBlocks()) {
            if (!classType.isInstance(block)) continue;
            return true;
        }
        return false;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isInsideOfLava() {
        for (Block block : this.getCollisionBlocks()) {
            if (!(block instanceof BlockLava)) continue;
            return true;
        }
        return false;
    }

    public boolean isOnLadder() {
        Block b = this.getLevelBlock();
        return b.getId() == 65;
    }

    public boolean fastMove(double dx, double dy, double dz) {
        if (dx == 0.0 && dy == 0.0 && dz == 0.0) {
            return true;
        }
        Timings.entityMoveTimer.startTiming();
        AxisAlignedBB newBB = this.boundingBox.getOffsetBoundingBox(dx, dy, dz);
        if (this.server.getAllowFlight() || this.isPlayer && ((Player)this).getAdventureSettings().get(AdventureSettings.Type.NO_CLIP) || !this.level.hasCollision(this, newBB, false)) {
            this.boundingBox = newBB;
        }
        this.x = (this.boundingBox.getMinX() + this.boundingBox.getMaxX()) / 2.0;
        this.y = this.boundingBox.getMinY() - (double)this.ySize;
        this.z = (this.boundingBox.getMinZ() + this.boundingBox.getMaxZ()) / 2.0;
        this.checkChunks();
        if (!(this.onGround && dy == 0.0 || this.noClip)) {
            AxisAlignedBB bb = this.boundingBox.clone();
            bb.setMinY(bb.getMinY() - 0.75);
            this.onGround = this.level.getCollisionBlocks(bb).length > 0;
        }
        this.isCollided = this.onGround;
        this.updateFallState(this.onGround);
        Timings.entityMoveTimer.stopTiming();
        return true;
    }

    public boolean move(double dx, double dy, double dz) {
        AxisAlignedBB[] list;
        if (dx == 0.0 && dz == 0.0 && dy == 0.0) {
            return true;
        }
        if (this.keepMovement) {
            this.boundingBox.offset(dx, dy, dz);
            this.setPosition(this.temporalVector.setComponents((this.boundingBox.getMinX() + this.boundingBox.getMaxX()) / 2.0, this.boundingBox.getMinY(), (this.boundingBox.getMinZ() + this.boundingBox.getMaxZ()) / 2.0));
            this.onGround = this.isPlayer;
            return true;
        }
        Timings.entityMoveTimer.startTiming();
        this.ySize = (float)((double)this.ySize * 0.4);
        double movX = dx;
        double movY = dy;
        double movZ = dz;
        AxisAlignedBB axisalignedbb = this.boundingBox.clone();
        for (AxisAlignedBB bb : list = this.noClip ? AxisAlignedBB.EMPTY_ARRAY : this.level.getCollisionCubes(this, this.boundingBox.addCoord(dx, dy, dz), false)) {
            dy = bb.calculateYOffset(this.boundingBox, dy);
        }
        this.boundingBox.offset(0.0, dy, 0.0);
        boolean fallingFlag = this.onGround || dy != movY && movY < 0.0;
        for (AxisAlignedBB bb : list) {
            dx = bb.calculateXOffset(this.boundingBox, dx);
        }
        this.boundingBox.offset(dx, 0.0, 0.0);
        for (AxisAlignedBB bb : list) {
            dz = bb.calculateZOffset(this.boundingBox, dz);
        }
        this.boundingBox.offset(0.0, 0.0, dz);
        if (this.getStepHeight() > 0.0 && fallingFlag && (double)this.ySize < 0.05 && (movX != dx || movZ != dz)) {
            double cx = dx;
            double cy = dy;
            double cz = dz;
            dx = movX;
            dy = this.getStepHeight();
            dz = movZ;
            AxisAlignedBB axisalignedbb1 = this.boundingBox.clone();
            this.boundingBox.setBB(axisalignedbb);
            for (AxisAlignedBB bb : list = this.level.getCollisionCubes(this, this.boundingBox.addCoord(dx, dy, dz), false)) {
                dy = bb.calculateYOffset(this.boundingBox, dy);
            }
            this.boundingBox.offset(0.0, dy, 0.0);
            for (AxisAlignedBB bb : list) {
                dx = bb.calculateXOffset(this.boundingBox, dx);
            }
            this.boundingBox.offset(dx, 0.0, 0.0);
            for (AxisAlignedBB bb : list) {
                dz = bb.calculateZOffset(this.boundingBox, dz);
            }
            this.boundingBox.offset(0.0, 0.0, dz);
            this.boundingBox.offset(0.0, 0.0, dz);
            if (cx * cx + cz * cz >= dx * dx + dz * dz) {
                dx = cx;
                dy = cy;
                dz = cz;
                this.boundingBox.setBB(axisalignedbb1);
            } else {
                this.ySize = (float)((double)this.ySize + 0.5);
            }
        }
        this.x = (this.boundingBox.getMinX() + this.boundingBox.getMaxX()) / 2.0;
        this.y = this.boundingBox.getMinY() - (double)this.ySize;
        this.z = (this.boundingBox.getMinZ() + this.boundingBox.getMaxZ()) / 2.0;
        this.checkChunks();
        this.checkGroundState(movX, movY, movZ, dx, dy, dz);
        this.updateFallState(this.onGround);
        if (movX != dx) {
            this.motionX = 0.0;
        }
        if (movY != dy) {
            this.motionY = 0.0;
        }
        if (movZ != dz) {
            this.motionZ = 0.0;
        }
        Timings.entityMoveTimer.stopTiming();
        return true;
    }

    @PowerNukkitDifference(since="1.4.0.0-PN", info="Will do nothing if the entity is on ground and all args are 0")
    protected void checkGroundState(double movX, double movY, double movZ, double dx, double dy, double dz) {
        if (this.onGround && movX == 0.0 && movY == 0.0 && movZ == 0.0 && dx == 0.0 && dy == 0.0 && dz == 0.0) {
            return;
        }
        if (this.noClip) {
            this.isCollidedVertically = false;
            this.isCollidedHorizontally = false;
            this.isCollided = false;
            this.onGround = false;
        } else {
            this.isCollidedVertically = movY != dy;
            this.isCollidedHorizontally = movX != dx || movZ != dz;
            this.isCollided = this.isCollidedHorizontally || this.isCollidedVertically;
            this.onGround = movY != dy && movY < 0.0;
        }
    }

    public List<Block> getBlocksAround() {
        if (this.blocksAround == null) {
            int minX = NukkitMath.floorDouble(this.boundingBox.getMinX());
            int minY = NukkitMath.floorDouble(this.boundingBox.getMinY());
            int minZ = NukkitMath.floorDouble(this.boundingBox.getMinZ());
            int maxX = NukkitMath.ceilDouble(this.boundingBox.getMaxX());
            int maxY = NukkitMath.ceilDouble(this.boundingBox.getMaxY());
            int maxZ = NukkitMath.ceilDouble(this.boundingBox.getMaxZ());
            this.blocksAround = new ArrayList<Block>();
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        Block block = this.level.getBlock(this.temporalVector.setComponents(x, y, z));
                        this.blocksAround.add(block);
                    }
                }
            }
        }
        return this.blocksAround;
    }

    public List<Block> getCollisionBlocks() {
        if (this.collisionBlocks == null) {
            this.collisionBlocks = new ArrayList<Block>();
            for (Block b : this.getBlocksAround()) {
                if (!b.collidesWithBB(this.getBoundingBox(), true)) continue;
                this.collisionBlocks.add(b);
            }
        }
        return this.collisionBlocks;
    }

    public boolean canBeMovedByCurrents() {
        return true;
    }

    protected void checkBlockCollision() {
        if (this.noClip) {
            return;
        }
        Vector3 vector = new Vector3(0.0, 0.0, 0.0);
        boolean portal = false;
        boolean scaffolding = false;
        boolean endPortal = false;
        for (Block block : this.getCollisionBlocks()) {
            switch (block.getId()) {
                case 90: {
                    portal = true;
                    break;
                }
                case 420: {
                    scaffolding = true;
                    break;
                }
                case 119: {
                    endPortal = true;
                }
            }
            block.onEntityCollide(this);
            block.getLevelBlockAtLayer(1).onEntityCollide(this);
            block.addVelocityToEntity(this, vector);
        }
        this.setDataFlag(DATA_FLAGS_EXTENDED, DATA_FLAG_IN_SCAFFOLDING, scaffolding);
        AxisAlignedBB scanBoundingBox = this.boundingBox.getOffsetBoundingBox(0.0, -0.125, 0.0);
        scanBoundingBox.setMaxY(this.boundingBox.getMinY());
        Block[] scaffoldingUnder = this.level.getCollisionBlocks(scanBoundingBox, true, true, b -> b.getId() == 420);
        this.setDataFlag(DATA_FLAGS_EXTENDED, DATA_FLAG_OVER_SCAFFOLDING, scaffoldingUnder.length > 0);
        if (endPortal) {
            if (!this.inEndPortal) {
                this.inEndPortal = true;
                EntityPortalEnterEvent ev = new EntityPortalEnterEvent(this, EntityPortalEnterEvent.PortalType.END);
                this.getServer().getPluginManager().callEvent(ev);
            }
        } else {
            this.inEndPortal = false;
        }
        if (portal) {
            if (this.inPortalTicks <= 80) {
                ++this.inPortalTicks;
            }
        } else {
            this.inPortalTicks = 0;
        }
        if (vector.lengthSquared() > 0.0) {
            vector = vector.normalize();
            double d = 0.014;
            this.motionX += vector.x * d;
            this.motionY += vector.y * d;
            this.motionZ += vector.z * d;
        }
    }

    public boolean setPositionAndRotation(Vector3 pos, double yaw, double pitch) {
        if (this.setPosition(pos)) {
            this.setRotation(yaw, pitch);
            return true;
        }
        return false;
    }

    public void setRotation(double yaw, double pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.scheduleUpdate();
    }

    public boolean doesTriggerPressurePlate() {
        return true;
    }

    public boolean canPassThrough() {
        return true;
    }

    protected void checkChunks() {
        if (this.chunk == null || this.chunk.getX() != (int)this.x >> 4 || this.chunk.getZ() != (int)this.z >> 4) {
            if (this.chunk != null) {
                this.chunk.removeEntity(this);
            }
            this.chunk = this.level.getChunk((int)this.x >> 4, (int)this.z >> 4, true);
            if (!this.justCreated) {
                Map<Integer, Player> newChunk = this.level.getChunkPlayers((int)this.x >> 4, (int)this.z >> 4);
                for (Player player : new ArrayList<Player>(this.hasSpawned.values())) {
                    if (!newChunk.containsKey(player.getLoaderId())) {
                        this.despawnFrom(player);
                        continue;
                    }
                    newChunk.remove(player.getLoaderId());
                }
                for (Player player : newChunk.values()) {
                    this.spawnTo(player);
                }
            }
            if (this.chunk == null) {
                return;
            }
            this.chunk.addEntity(this);
        }
    }

    public boolean setPosition(Vector3 pos) {
        if (this.closed) {
            return false;
        }
        if (pos instanceof Position && ((Position)pos).level != null && ((Position)pos).level != this.level && !this.switchLevel(((Position)pos).getLevel())) {
            return false;
        }
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
        this.recalculateBoundingBox(false);
        this.checkChunks();
        return true;
    }

    public Vector3 getMotion() {
        return new Vector3(this.motionX, this.motionY, this.motionZ);
    }

    public boolean setMotion(Vector3 motion) {
        if (!this.justCreated) {
            EntityMotionEvent ev = new EntityMotionEvent(this, motion);
            this.server.getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return false;
            }
        }
        this.motionX = motion.x;
        this.motionY = motion.y;
        this.motionZ = motion.z;
        if (!this.justCreated) {
            this.updateMovement();
        }
        return true;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public void kill() {
        this.health = 0.0f;
        this.scheduleUpdate();
        for (Entity passenger : new ArrayList<Entity>(this.passengers)) {
            this.dismountEntity(passenger);
        }
    }

    public boolean teleport(Vector3 pos) {
        return this.teleport(pos, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public boolean teleport(Vector3 pos, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(Location.fromObject(pos, this.level, this.yaw, this.pitch), cause);
    }

    public boolean teleport(Position pos) {
        return this.teleport(pos, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public boolean teleport(Position pos, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(Location.fromObject(pos, pos.level, this.yaw, this.pitch), cause);
    }

    public boolean teleport(Location location) {
        return this.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        Entity currentRide;
        double yaw = location.yaw;
        double pitch = location.pitch;
        Location from = this.getLocation();
        Location to = location;
        if (cause != null) {
            EntityTeleportEvent ev = new EntityTeleportEvent(this, from, to);
            this.server.getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return false;
            }
            to = ev.getTo();
        }
        if ((currentRide = this.getRiding()) != null && !currentRide.dismountEntity(this)) {
            return false;
        }
        this.ySize = 0.0f;
        this.setMotion(this.temporalVector.setComponents(0.0, 0.0, 0.0));
        if (this.setPositionAndRotation(to, yaw, pitch)) {
            this.resetFallDistance();
            this.onGround = !this.noClip;
            this.updateMovement();
            return true;
        }
        return false;
    }

    public long getId() {
        return this.id;
    }

    public void respawnToAll() {
        Player[] players = this.hasSpawned.values().toArray(Player.EMPTY_ARRAY);
        this.hasSpawned.clear();
        for (Player player : players) {
            this.spawnTo(player);
        }
    }

    public void spawnToAll() {
        if (this.chunk == null || this.closed) {
            return;
        }
        for (Player player : this.level.getChunkPlayers(this.chunk.getX(), this.chunk.getZ()).values()) {
            if (!player.isOnline()) continue;
            this.spawnTo(player);
        }
    }

    public void despawnFromAll() {
        for (Player player : new ArrayList<Player>(this.hasSpawned.values())) {
            this.despawnFrom(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                EntityDespawnEvent event = new EntityDespawnEvent(this);
                this.server.getPluginManager().callEvent(event);
                if (event.isCancelled()) {
                    this.closed = false;
                    return;
                }
            }
            catch (Throwable e) {
                this.closed = false;
                throw e;
            }
            try {
                this.despawnFromAll();
            }
            finally {
                try {
                    if (this.chunk != null) {
                        this.chunk.removeEntity(this);
                    }
                }
                finally {
                    if (this.level != null) {
                        this.level.removeEntity(this);
                    }
                }
            }
        }
    }

    private void close(Boolean despawn) {
        if (!this.closed) {
            this.closed = true;
            if (despawn.booleanValue()) {
                EntityDespawnEvent event = new EntityDespawnEvent(this);
                this.server.getPluginManager().callEvent(event);
                if (event.isCancelled()) {
                    return;
                }
            }
            this.despawnFromAll();
            if (this.chunk != null) {
                this.chunk.removeEntity(this);
            }
            if (this.level != null) {
                this.level.removeEntity(this);
            }
        }
    }

    public boolean setDataProperty(EntityData data) {
        return this.setDataProperty(data, true);
    }

    public boolean setDataProperty(EntityData data, boolean send) {
        if (!Objects.equals(data, this.getDataProperties().get(data.getId()))) {
            this.getDataProperties().put(data);
            if (send) {
                this.sendData(this.hasSpawned.values().toArray(Player.EMPTY_ARRAY), new EntityMetadata().put(this.dataProperties.get(data.getId())));
            }
            return true;
        }
        return false;
    }

    public EntityMetadata getDataProperties() {
        return this.dataProperties;
    }

    public EntityData getDataProperty(int id) {
        return this.getDataProperties().get(id);
    }

    public int getDataPropertyInt(int id) {
        return this.getDataProperties().getInt(id);
    }

    public int getDataPropertyShort(int id) {
        return this.getDataProperties().getShort(id);
    }

    public int getDataPropertyByte(int id) {
        return this.getDataProperties().getByte(id);
    }

    public boolean getDataPropertyBoolean(int id) {
        return this.getDataProperties().getBoolean(id);
    }

    public long getDataPropertyLong(int id) {
        return this.getDataProperties().getLong(id);
    }

    public String getDataPropertyString(int id) {
        return this.getDataProperties().getString(id);
    }

    public float getDataPropertyFloat(int id) {
        return this.getDataProperties().getFloat(id);
    }

    public CompoundTag getDataPropertyNBT(int id) {
        return this.getDataProperties().getNBT(id);
    }

    public Vector3 getDataPropertyPos(int id) {
        return this.getDataProperties().getPosition(id);
    }

    public Vector3f getDataPropertyVector3f(int id) {
        return this.getDataProperties().getFloatPosition(id);
    }

    public int getDataPropertyType(int id) {
        return this.getDataProperties().exists(id) ? this.getDataProperty(id).getType() : -1;
    }

    public void setDataFlag(int propertyId, int id) {
        this.setDataFlag(propertyId, id, true);
    }

    public void setDataFlag(int propertyId, int id, boolean value) {
        if (this.getDataFlag(propertyId, id) != value) {
            if (propertyId == 26) {
                byte flags = (byte)this.getDataPropertyByte(propertyId);
                flags = (byte)(flags ^ 1 << id);
                this.setDataProperty(new ByteEntityData(propertyId, flags));
            } else {
                long flags = this.getDataPropertyLong(propertyId);
                this.setDataProperty(new LongEntityData(propertyId, flags ^= 1L << id));
            }
        }
    }

    public boolean getDataFlag(int propertyId, int id) {
        return ((propertyId == 26 ? (long)(this.getDataPropertyByte(propertyId) & 0xFF) : this.getDataPropertyLong(propertyId)) & 1L << id) > 0L;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getEntityMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getEntityMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getEntityMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getEntityMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isUndead() {
        return false;
    }

    @PowerNukkitOnly
    @Since(value="1.2.1.0-PN")
    public boolean isInEndPortal() {
        return this.inEndPortal;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isPreventingSleep(Player player) {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entity other = (Entity)obj;
        return this.getId() == other.getId();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = (int)((long)(29 * hash) + this.getId());
        return hash;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isSpinAttacking() {
        return this.getDataFlag(DATA_FLAGS, DATA_FLAG_SPIN_ATTACK);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setSpinAttacking() {
        this.setSpinAttacking(true);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setSpinAttacking(boolean value) {
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_SPIN_ATTACK, value);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isNoClip() {
        return this.noClip;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setNoClip(boolean noClip) {
        this.noClip = noClip;
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_HAS_COLLISION, noClip);
    }

    static {
        DATA_COLOUR = DATA_COLOR = Utils.dynamic(3);
        DATA_NAMETAG = Utils.dynamic(4);
        DATA_OWNER_EID = Utils.dynamic(5);
        DATA_TARGET_EID = Utils.dynamic(6);
        DATA_AIR = Utils.dynamic(7);
        DATA_POTION_COLOR = Utils.dynamic(8);
        DATA_POTION_AMBIENT = Utils.dynamic(9);
        DATA_JUMP_DURATION = Utils.dynamic(10);
        DATA_HURT_TIME = Utils.dynamic(11);
        DATA_HURT_DIRECTION = Utils.dynamic(12);
        DATA_PADDLE_TIME_LEFT = Utils.dynamic(13);
        DATA_PADDLE_TIME_RIGHT = Utils.dynamic(14);
        DATA_EXPERIENCE_VALUE = Utils.dynamic(15);
        DATA_DISPLAY_ITEM = Utils.dynamic(16);
        DATA_DISPLAY_OFFSET = Utils.dynamic(17);
        DATA_HAS_DISPLAY = Utils.dynamic(18);
        DATA_SWELL = Utils.dynamic(19);
        DATA_OLD_SWELL = Utils.dynamic(20);
        DATA_SWELL_DIR = Utils.dynamic(21);
        DATA_CHARGE_AMOUNT = Utils.dynamic(22);
        DATA_ENDERMAN_HELD_RUNTIME_ID = Utils.dynamic(23);
        DATA_CLIENT_EVENT = Utils.dynamic(24);
        DATA_ENTITY_AGE = Utils.dynamic(DATA_CLIENT_EVENT);
        DATA_USING_ITEM = Utils.dynamic(25);
        DATA_PLAYER_FLAGS = Utils.dynamic(26);
        DATA_PLAYER_INDEX = Utils.dynamic(27);
        DATA_PLAYER_BED_POSITION = Utils.dynamic(28);
        DATA_FIREBALL_POWER_X = Utils.dynamic(29);
        DATA_FIREBALL_POWER_Y = Utils.dynamic(30);
        DATA_FIREBALL_POWER_Z = Utils.dynamic(31);
        DATA_AUX_POWER = Utils.dynamic(32);
        DATA_FISH_X = Utils.dynamic(33);
        DATA_FISH_Z = Utils.dynamic(34);
        DATA_FISH_ANGLE = Utils.dynamic(35);
        DATA_POTION_AUX_VALUE = Utils.dynamic(36);
        DATA_LEAD_HOLDER_EID = Utils.dynamic(37);
        DATA_SCALE = Utils.dynamic(38);
        DATA_INTERACTIVE_TAG = Utils.dynamic(39);
        DATA_HAS_NPC_COMPONENT = Utils.dynamic(DATA_INTERACTIVE_TAG);
        DATA_NPC_SKIN_ID = Utils.dynamic(40);
        DATA_URL_TAG = Utils.dynamic(41);
        DATA_MAX_AIR = Utils.dynamic(42);
        DATA_MARK_VARIANT = Utils.dynamic(43);
        DATA_CONTAINER_TYPE = Utils.dynamic(44);
        DATA_CONTAINER_BASE_SIZE = Utils.dynamic(45);
        DATA_CONTAINER_EXTRA_SLOTS_PER_STRENGTH = Utils.dynamic(46);
        DATA_BLOCK_TARGET = Utils.dynamic(47);
        DATA_WITHER_INVULNERABLE_TICKS = Utils.dynamic(48);
        DATA_WITHER_TARGET_1 = Utils.dynamic(49);
        DATA_WITHER_TARGET_2 = Utils.dynamic(50);
        DATA_WITHER_TARGET_3 = Utils.dynamic(51);
        DATA_AERIAL_ATTACK = Utils.dynamic(52);
        DATA_BOUNDING_BOX_WIDTH = Utils.dynamic(53);
        DATA_BOUNDING_BOX_HEIGHT = Utils.dynamic(54);
        DATA_FUSE_LENGTH = Utils.dynamic(55);
        DATA_RIDER_SEAT_POSITION = Utils.dynamic(56);
        DATA_RIDER_ROTATION_LOCKED = Utils.dynamic(57);
        DATA_RIDER_MAX_ROTATION = Utils.dynamic(58);
        DATA_RIDER_MIN_ROTATION = Utils.dynamic(59);
        DATA_RIDER_ROTATION_OFFSET = Utils.dynamic(60);
        DATA_AREA_EFFECT_CLOUD_RADIUS = Utils.dynamic(61);
        DATA_AREA_EFFECT_CLOUD_WAITING = Utils.dynamic(62);
        DATA_AREA_EFFECT_CLOUD_PARTICLE_ID = Utils.dynamic(63);
        DATA_SHULKER_PEEK_ID = Utils.dynamic(64);
        DATA_SHULKER_ATTACH_FACE = Utils.dynamic(65);
        DATA_SHULKER_ATTACHED = Utils.dynamic(66);
        DATA_SHULKER_ATTACH_POS = Utils.dynamic(67);
        DATA_TRADING_PLAYER_EID = Utils.dynamic(68);
        DATA_TRADING_CAREER = Utils.dynamic(69);
        DATA_HAS_COMMAND_BLOCK = Utils.dynamic(70);
        DATA_COMMAND_BLOCK_COMMAND = Utils.dynamic(71);
        DATA_COMMAND_BLOCK_LAST_OUTPUT = Utils.dynamic(72);
        DATA_COMMAND_BLOCK_TRACK_OUTPUT = Utils.dynamic(73);
        DATA_CONTROLLING_RIDER_SEAT_NUMBER = Utils.dynamic(74);
        DATA_STRENGTH = Utils.dynamic(75);
        DATA_MAX_STRENGTH = Utils.dynamic(76);
        DATA_SPELL_CASTING_COLOR = Utils.dynamic(77);
        DATA_LIMITED_LIFE = Utils.dynamic(78);
        DATA_ARMOR_STAND_POSE_INDEX = Utils.dynamic(79);
        DATA_ENDER_CRYSTAL_TIME_OFFSET = Utils.dynamic(80);
        DATA_ALWAYS_SHOW_NAMETAG = Utils.dynamic(81);
        DATA_COLOR_2 = Utils.dynamic(82);
        DATA_NAME_AUTHOR = Utils.dynamic(83);
        DATA_SCORE_TAG = Utils.dynamic(84);
        DATA_BALLOON_ATTACHED_ENTITY = Utils.dynamic(85);
        DATA_PUFFERFISH_SIZE = Utils.dynamic(86);
        DATA_BUBBLE_TIME = Utils.dynamic(87);
        DATA_AGENT = Utils.dynamic(88);
        DATA_SITTING_AMOUNT = Utils.dynamic(89);
        DATA_SITTING_AMOUNT_PREVIOUS = Utils.dynamic(90);
        DATA_EATING_COUNTER = Utils.dynamic(91);
        DATA_FLAGS_EXTENDED = Utils.dynamic(92);
        DATA_LAYING_AMOUNT = Utils.dynamic(93);
        DATA_LAYING_AMOUNT_PREVIOUS = Utils.dynamic(94);
        DATA_DURATION = Utils.dynamic(95);
        DATA_SPAWN_TIME = Utils.dynamic(96);
        DATA_CHANGE_RATE = Utils.dynamic(97);
        DATA_CHANGE_ON_PICKUP = Utils.dynamic(98);
        DATA_PICKUP_COUNT = Utils.dynamic(99);
        DATA_INTERACT_TEXT = Utils.dynamic(100);
        DATA_TRADE_TIER = Utils.dynamic(101);
        DATA_MAX_TRADE_TIER = Utils.dynamic(102);
        DATA_TRADE_EXPERIENCE = Utils.dynamic(103);
        DATA_SKIN_ID = Utils.dynamic(104);
        DATA_SPAWNING_FRAMES = Utils.dynamic(105);
        DATA_COMMAND_BLOCK_TICK_DELAY = Utils.dynamic(106);
        DATA_COMMAND_BLOCK_EXECUTE_ON_FIRST_TICK = Utils.dynamic(107);
        DATA_AMBIENT_SOUND_INTERVAL = Utils.dynamic(108);
        DATA_AMBIENT_SOUND_INTERVAL_RANGE = Utils.dynamic(109);
        DATA_AMBIENT_SOUND_EVENT_NAME = Utils.dynamic(110);
        DATA_FALL_DAMAGE_MULTIPLIER = Utils.dynamic(111);
        DATA_NAME_RAW_TEXT = Utils.dynamic(112);
        DATA_CAN_RIDE_TARGET = Utils.dynamic(113);
        DATA_LOW_TIER_CURED_DISCOUNT = Utils.dynamic(114);
        DATA_HIGH_TIER_CURED_DISCOUNT = Utils.dynamic(115);
        DATA_NEARBY_CURED_DISCOUNT = Utils.dynamic(116);
        DATA_NEARBY_CURED_DISCOUNT_TIMESTAMP = Utils.dynamic(117);
        DATA_HITBOX = Utils.dynamic(118);
        DATA_IS_BUOYANT = Utils.dynamic(119);
        DATA_BASE_RUNTIME_ID = Utils.dynamic(120);
        DATA_FREEZING_EFFECT_STRENGTH = Utils.dynamic(121);
        DATA_BUOYANCY_DATA = Utils.dynamic(122);
        DATA_GOAT_HORN_COUNT = Utils.dynamic(123);
        DATA_UPDATE_PROPERTIES = Utils.dynamic(124);
        DATA_FLAG_ONFIRE = Utils.dynamic(0);
        DATA_FLAG_SNEAKING = Utils.dynamic(1);
        DATA_FLAG_RIDING = Utils.dynamic(2);
        DATA_FLAG_SPRINTING = Utils.dynamic(3);
        DATA_FLAG_ACTION = Utils.dynamic(4);
        DATA_FLAG_INVISIBLE = Utils.dynamic(5);
        DATA_FLAG_TEMPTED = Utils.dynamic(6);
        DATA_FLAG_INLOVE = Utils.dynamic(7);
        DATA_FLAG_SADDLED = Utils.dynamic(8);
        DATA_FLAG_POWERED = Utils.dynamic(9);
        DATA_FLAG_IGNITED = Utils.dynamic(10);
        DATA_FLAG_BABY = Utils.dynamic(11);
        DATA_FLAG_CONVERTING = Utils.dynamic(12);
        DATA_FLAG_CRITICAL = Utils.dynamic(13);
        DATA_FLAG_CAN_SHOW_NAMETAG = Utils.dynamic(14);
        DATA_FLAG_ALWAYS_SHOW_NAMETAG = Utils.dynamic(15);
        DATA_FLAG_NO_AI = DATA_FLAG_IMMOBILE = Utils.dynamic(16);
        DATA_FLAG_SILENT = Utils.dynamic(17);
        DATA_FLAG_WALLCLIMBING = Utils.dynamic(18);
        DATA_FLAG_CAN_CLIMB = Utils.dynamic(19);
        DATA_FLAG_SWIMMER = Utils.dynamic(20);
        DATA_FLAG_CAN_FLY = Utils.dynamic(21);
        DATA_FLAG_WALKER = Utils.dynamic(22);
        DATA_FLAG_RESTING = Utils.dynamic(23);
        DATA_FLAG_SITTING = Utils.dynamic(24);
        DATA_FLAG_ANGRY = Utils.dynamic(25);
        DATA_FLAG_INTERESTED = Utils.dynamic(26);
        DATA_FLAG_CHARGED = Utils.dynamic(27);
        DATA_FLAG_TAMED = Utils.dynamic(28);
        DATA_FLAG_ORPHANED = Utils.dynamic(29);
        DATA_FLAG_LEASHED = Utils.dynamic(30);
        DATA_FLAG_SHEARED = Utils.dynamic(31);
        DATA_FLAG_GLIDING = Utils.dynamic(32);
        DATA_FLAG_ELDER = Utils.dynamic(33);
        DATA_FLAG_MOVING = Utils.dynamic(34);
        DATA_FLAG_BREATHING = Utils.dynamic(35);
        DATA_FLAG_CHESTED = Utils.dynamic(36);
        DATA_FLAG_STACKABLE = Utils.dynamic(37);
        DATA_FLAG_SHOWBASE = Utils.dynamic(38);
        DATA_FLAG_REARING = Utils.dynamic(39);
        DATA_FLAG_VIBRATING = Utils.dynamic(40);
        DATA_FLAG_IDLING = Utils.dynamic(41);
        DATA_FLAG_EVOKER_SPELL = Utils.dynamic(42);
        DATA_FLAG_CHARGE_ATTACK = Utils.dynamic(43);
        DATA_FLAG_WASD_CONTROLLED = Utils.dynamic(44);
        DATA_FLAG_CAN_POWER_JUMP = Utils.dynamic(45);
        DATA_FLAG_LINGER = Utils.dynamic(46);
        DATA_FLAG_HAS_COLLISION = Utils.dynamic(47);
        DATA_FLAG_GRAVITY = Utils.dynamic(48);
        DATA_FLAG_FIRE_IMMUNE = Utils.dynamic(49);
        DATA_FLAG_DANCING = Utils.dynamic(50);
        DATA_FLAG_ENCHANTED = Utils.dynamic(51);
        DATA_FLAG_SHOW_TRIDENT_ROPE = Utils.dynamic(52);
        DATA_FLAG_CONTAINER_PRIVATE = Utils.dynamic(53);
        DATA_FLAG_IS_TRANSFORMING = Utils.dynamic(54);
        DATA_FLAG_SPIN_ATTACK = Utils.dynamic(55);
        DATA_FLAG_SWIMMING = Utils.dynamic(56);
        DATA_FLAG_BRIBED = Utils.dynamic(57);
        DATA_FLAG_PREGNANT = Utils.dynamic(58);
        DATA_FLAG_LAYING_EGG = Utils.dynamic(59);
        DATA_FLAG_RIDER_CAN_PICK = Utils.dynamic(60);
        DATA_FLAG_TRANSITION_SETTING = DATA_FLAG_TRANSITION_SITTING = Utils.dynamic(61);
        DATA_FLAG_EATING = Utils.dynamic(62);
        DATA_FLAG_LAYING_DOWN = Utils.dynamic(63);
        DATA_FLAG_SNEEZING = Utils.dynamic(64);
        DATA_FLAG_TRUSTING = Utils.dynamic(65);
        DATA_FLAG_ROLLING = Utils.dynamic(66);
        DATA_FLAG_SCARED = Utils.dynamic(67);
        DATA_FLAG_IN_SCAFFOLDING = Utils.dynamic(68);
        DATA_FLAG_OVER_SCAFFOLDING = Utils.dynamic(69);
        DATA_FLAG_FALL_THROUGH_SCAFFOLDING = Utils.dynamic(70);
        DATA_FLAG_BLOCKING = Utils.dynamic(71);
        DATA_FLAG_TRANSITION_BLOCKING = Utils.dynamic(72);
        DATA_FLAG_BLOCKED_USING_SHIELD = Utils.dynamic(73);
        DATA_FLAG_BLOCKED_USING_DAMAGED_SHIELD = Utils.dynamic(74);
        DATA_FLAG_SLEEPING = Utils.dynamic(75);
        DATA_FLAG_WANTS_TO_WAKE = Utils.dynamic(76);
        DATA_FLAG_TRADE_INTEREST = Utils.dynamic(77);
        DATA_FLAG_DOOR_BREAKER = Utils.dynamic(78);
        DATA_FLAG_BREAKING_OBSTRUCTION = Utils.dynamic(79);
        DATA_FLAG_DOOR_OPENER = Utils.dynamic(80);
        DATA_FLAG_IS_ILLAGER_CAPTAIN = Utils.dynamic(81);
        DATA_FLAG_STUNNED = Utils.dynamic(82);
        DATA_FLAG_ROARING = Utils.dynamic(83);
        DATA_FLAG_DELAYED_ATTACK = Utils.dynamic(84);
        DATA_FLAG_IS_AVOIDING_MOBS = Utils.dynamic(85);
        DATA_FLAG_IS_AVOIDING_BLOCKS = Utils.dynamic(86);
        DATA_FLAG_FACING_TARGET_TO_RANGE_ATTACK = Utils.dynamic(87);
        DATA_FLAG_HIDDEN_WHEN_INVISIBLE = Utils.dynamic(88);
        DATA_FLAG_IS_IN_UI = Utils.dynamic(89);
        DATA_FLAG_STALKING = Utils.dynamic(90);
        DATA_FLAG_EMOTING = Utils.dynamic(91);
        DATA_FLAG_CELEBRATING = Utils.dynamic(92);
        DATA_FLAG_ADMIRING = Utils.dynamic(93);
        DATA_FLAG_CELEBRATING_SPECIAL = Utils.dynamic(94);
        DATA_FLAG_RAM_ATTACK = Utils.dynamic(96);
        DATA_FLAG_PLAYING_DEAD = Utils.dynamic(97);
        entityCount = 1L;
        knownEntities = new HashMap<String, Class<? extends Entity>>();
        shortNames = new HashMap<String, String>();
    }
}

