/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.data;

import cn.nukkit.entity.Entity;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class EntityData<T> {
    private static final Int2ObjectMap<String> KNOWN_ENTITY_DATA = new Int2ObjectOpenHashMap();
    private static final Int2ObjectMap<String> KNOWN_ENTITY_FLAGS = new Int2ObjectOpenHashMap();
    private int id;

    protected EntityData(int id) {
        this.id = id;
    }

    public abstract int getType();

    public abstract T getData();

    public abstract void setData(T var1);

    public int getId() {
        return this.id;
    }

    public EntityData setId(int id) {
        this.id = id;
        return this;
    }

    public boolean equals(Object obj) {
        return obj instanceof EntityData && ((EntityData)obj).getId() == this.getId() && Objects.equals(((EntityData)obj).getData(), this.getData());
    }

    private SortedSet<String> readFlags(int offset, long flags) {
        TreeSet<String> flagSet = new TreeSet<String>();
        int limit = offset + 64;
        for (Int2ObjectMap.Entry flag : KNOWN_ENTITY_FLAGS.int2ObjectEntrySet()) {
            long bit;
            if (flag.getIntKey() >= limit || (flags & (bit = 1L << flag.getIntKey() - offset)) == 0L) continue;
            flagSet.add((String)flag.getValue());
        }
        return flagSet;
    }

    public String toString() {
        String idStr = (String)KNOWN_ENTITY_DATA.get(this.id);
        if (idStr == null) {
            idStr = Integer.toString(this.id);
        }
        Object data = this.getData();
        if (this.id == Entity.DATA_FLAGS) {
            data = this.readFlags(0, (Long)data);
        } else if (this.id == Entity.DATA_FLAGS_EXTENDED) {
            data = this.readFlags(64, (Long)data);
        }
        return this.getClass().getSimpleName() + "{id=" + idStr + ",data=" + data + '}';
    }

    static {
        Arrays.stream(Entity.class.getDeclaredFields()).filter(it -> it.getModifiers() == 25).filter(it -> it.getType().equals(Integer.TYPE)).filter(it -> it.getName().startsWith("DATA_")).filter(it -> !it.getName().startsWith("DATA_FLAG_")).filter(it -> !it.getName().startsWith("DATA_TYPE_")).forEachOrdered(it -> {
            try {
                KNOWN_ENTITY_DATA.put(it.getInt(null), (Object)it.getName().substring(5));
            }
            catch (IllegalAccessException e) {
                throw new InternalError(e);
            }
        });
        Arrays.stream(Entity.class.getDeclaredFields()).filter(it -> it.getModifiers() == 25).filter(it -> it.getType().equals(Integer.TYPE)).filter(it -> it.getName().startsWith("DATA_FLAG_")).forEachOrdered(it -> {
            try {
                KNOWN_ENTITY_FLAGS.put(it.getInt(null), (Object)it.getName().substring(10));
            }
            catch (IllegalAccessException e) {
                throw new InternalError(e);
            }
        });
    }
}

