/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.passive;

import cn.nukkit.Player;
import cn.nukkit.entity.EntityOwnable;
import cn.nukkit.entity.data.ByteEntityData;
import cn.nukkit.entity.data.StringEntityData;
import cn.nukkit.entity.passive.EntityAnimal;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;

public abstract class EntityTameable
extends EntityAnimal
implements EntityOwnable {
    public static final int DATA_TAMED_FLAG = 16;
    public static final int DATA_OWNER_NAME = 17;

    public EntityTameable(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        if (this.getDataProperty(16) == null) {
            this.setDataProperty(new ByteEntityData(16, 0));
        }
        if (this.getDataProperty(17) == null) {
            this.setDataProperty(new StringEntityData(17, ""));
        }
        String ownerName = "";
        if (this.namedTag != null) {
            if (this.namedTag.contains("Owner")) {
                ownerName = this.namedTag.getString("Owner");
            }
            if (ownerName.length() > 0) {
                this.setOwnerName(ownerName);
                this.setTamed(true);
            }
            this.setSitting(this.namedTag.getBoolean("Sitting"));
        }
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        if (this.getOwnerName() == null) {
            this.namedTag.putString("Owner", "");
        } else {
            this.namedTag.putString("Owner", this.getOwnerName());
        }
        this.namedTag.putBoolean("Sitting", this.isSitting());
    }

    @Override
    public String getOwnerName() {
        return this.getDataPropertyString(17);
    }

    @Override
    public void setOwnerName(String playerName) {
        this.setDataProperty(new StringEntityData(17, playerName));
    }

    @Override
    public Player getOwner() {
        return this.getServer().getPlayer(this.getOwnerName());
    }

    public boolean isTamed() {
        return (this.getDataPropertyByte(16) & 4) != 0;
    }

    public void setTamed(boolean flag) {
        int var = this.getDataPropertyByte(16);
        if (flag) {
            this.setDataProperty(new ByteEntityData(16, (byte)(var | 4)));
        } else {
            this.setDataProperty(new ByteEntityData(16, (byte)(var & 0xFFFFFFFB)));
        }
    }

    public boolean isSitting() {
        return (this.getDataPropertyByte(16) & 1) != 0;
    }

    public void setSitting(boolean flag) {
        int var = this.getDataPropertyByte(16);
        if (flag) {
            this.setDataProperty(new ByteEntityData(16, (byte)(var | 1)));
        } else {
            this.setDataProperty(new ByteEntityData(16, (byte)(var & 0xFFFFFFFE)));
        }
    }
}

