/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.inventory.CraftingManager;
import cn.nukkit.inventory.RecipeType;
import cn.nukkit.item.Item;
import java.util.ArrayList;
import java.util.List;

public interface Recipe {
    public Item getResult();

    public void registerToCraftingManager(CraftingManager var1);

    public RecipeType getType();

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static boolean matchItemList(List<Item> haveItems, List<Item> needItems) {
        block0: for (Item needItem : new ArrayList<Item>(needItems)) {
            for (Item haveItem : new ArrayList<Item>(haveItems)) {
                if (!needItem.equals(haveItem, needItem.hasMeta(), needItem.hasCompoundTag())) continue;
                int amount = Math.min(haveItem.getCount(), needItem.getCount());
                needItem.setCount(needItem.getCount() - amount);
                haveItem.setCount(haveItem.getCount() - amount);
                if (haveItem.getCount() == 0) {
                    haveItems.remove(haveItem);
                }
                if (needItem.getCount() != 0) continue;
                needItems.remove(needItem);
                continue block0;
            }
        }
        return haveItems.isEmpty() && needItems.isEmpty();
    }
}

