/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityFirework;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemElytra;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.DyeColor;
import java.util.ArrayList;
import java.util.List;

public class ItemFirework
extends Item {
    public ItemFirework() {
        this((Integer)0);
    }

    public ItemFirework(Integer meta) {
        this(meta, 1);
    }

    @PowerNukkitDifference(info="Will not add compound tag automatically")
    public ItemFirework(Integer meta, int count) {
        super(401, meta, count, "Fireworks");
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Level level, Player player, Block block, Block target, BlockFace face, double fx, double fy, double fz) {
        if (player.isAdventure()) {
            return false;
        }
        if (block.canPassThrough()) {
            this.spawnFirework(level, block);
            if (!player.isCreative()) {
                player.getInventory().decreaseCount(player.getInventory().getHeldItemIndex());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onClickAir(Player player, Vector3 directionVector) {
        if (player.getInventory().getChestplate() instanceof ItemElytra && player.isGliding()) {
            this.spawnFirework(player.getLevel(), player);
            player.setMotion(new Vector3(-Math.sin(Math.toRadians(player.yaw)) * Math.cos(Math.toRadians(player.pitch)) * 2.0, -Math.sin(Math.toRadians(player.pitch)) * 2.0, Math.cos(Math.toRadians(player.yaw)) * Math.cos(Math.toRadians(player.pitch)) * 2.0));
            if (!player.isCreative()) {
                --this.count;
            }
            return true;
        }
        return false;
    }

    public void addExplosion(FireworkExplosion explosion) {
        List<DyeColor> colors = explosion.getColors();
        List<DyeColor> fades = explosion.getFades();
        if (colors.isEmpty()) {
            return;
        }
        byte[] clrs = new byte[colors.size()];
        for (int i = 0; i < clrs.length; ++i) {
            clrs[i] = (byte)colors.get(i).getDyeData();
        }
        byte[] fds = new byte[fades.size()];
        for (int i = 0; i < fds.length; ++i) {
            fds[i] = (byte)fades.get(i).getDyeData();
        }
        ListTag<CompoundTag> explosions = this.getNamedTag().getCompound("Fireworks").getList("Explosions", CompoundTag.class);
        CompoundTag tag = new CompoundTag().putByteArray("FireworkColor", clrs).putByteArray("FireworkFade", fds).putBoolean("FireworkFlicker", explosion.flicker).putBoolean("FireworkTrail", explosion.trail).putByte("FireworkType", explosion.type.ordinal());
        explosions.add(tag);
    }

    public void clearExplosions() {
        this.getNamedTag().getCompound("Fireworks").putList(new ListTag("Explosions"));
    }

    private void spawnFirework(Level level, Vector3 pos) {
        CompoundTag nbt = new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", pos.x + 0.5)).add(new DoubleTag("", pos.y + 0.5)).add(new DoubleTag("", pos.z + 0.5))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", 0.0f)).add(new FloatTag("", 0.0f))).putCompound("FireworkItem", NBTIO.putItemHelper(this));
        EntityFirework entity = (EntityFirework)Entity.createEntity("Firework", (FullChunk)level.getChunk(pos.getFloorX() >> 4, pos.getFloorZ() >> 4), nbt, new Object[0]);
        if (entity != null) {
            entity.spawnToAll();
        }
    }

    public static class FireworkExplosion {
        private List<DyeColor> colors = new ArrayList<DyeColor>();
        private List<DyeColor> fades = new ArrayList<DyeColor>();
        private boolean flicker = false;
        private boolean trail = false;
        private ExplosionType type = ExplosionType.CREEPER_SHAPED;

        public List<DyeColor> getColors() {
            return this.colors;
        }

        public List<DyeColor> getFades() {
            return this.fades;
        }

        public boolean hasFlicker() {
            return this.flicker;
        }

        public boolean hasTrail() {
            return this.trail;
        }

        public ExplosionType getType() {
            return this.type;
        }

        public FireworkExplosion setFlicker(boolean flicker) {
            this.flicker = flicker;
            return this;
        }

        public FireworkExplosion setTrail(boolean trail) {
            this.trail = trail;
            return this;
        }

        public FireworkExplosion type(ExplosionType type) {
            this.type = type;
            return this;
        }

        public FireworkExplosion addColor(DyeColor color) {
            this.colors.add(color);
            return this;
        }

        public FireworkExplosion addFade(DyeColor fade) {
            this.fades.add(fade);
            return this;
        }

        public static enum ExplosionType {
            SMALL_BALL,
            LARGE_BALL,
            STAR_SHAPED,
            CREEPER_SHAPED,
            BURST;

        }
    }
}

