/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.level.format.anvil.MultiLayerStorage;
import cn.nukkit.level.format.anvil.SingleLayerStorage;
import cn.nukkit.level.format.anvil.util.BlockStorage;
import cn.nukkit.level.format.anvil.util.ImmutableBlockStorage;
import cn.nukkit.level.format.updater.ChunkUpdater;
import cn.nukkit.utils.BinaryStream;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class LayerStorage
implements Cloneable {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final LayerStorage EMPTY = new LayerStorage();

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected LayerStorage() {
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean hasBlocks() {
        return false;
    }

    public LayerStorage clone() throws CloneNotSupportedException {
        if (this.getClass() == LayerStorage.class) {
            return this;
        }
        return (LayerStorage)super.clone();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockStorage getStorageOrEmpty(int layer) {
        return ImmutableBlockStorage.EMPTY;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockStorage getOrSetStorage(Consumer<LayerStorage> setLayerStorage, IntSupplier contentVersion, int layer) {
        LayerStorage populatedLayerStorage = layer == 0 ? new SingleLayerStorage() : new MultiLayerStorage();
        setLayerStorage.accept(populatedLayerStorage);
        return populatedLayerStorage.getOrSetStorage(setLayerStorage, contentVersion, layer);
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockStorage getStorageOrNull(int layer) {
        return null;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void delayPaletteUpdates() {
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void writeTo(BinaryStream stream) {
        stream.putByte((byte)8);
        stream.putByte((byte)0);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int size() {
        return 0;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void compress(Consumer<LayerStorage> setLayerStorage) {
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected BlockStorage createBlockStorage(int contentVersion) {
        BlockStorage storage = new BlockStorage();
        if (contentVersion < ChunkUpdater.getCurrentContentVersion()) {
            storage.delayPaletteUpdates();
        }
        return storage;
    }
}

