/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.object.tree;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.blockproperty.value.WoodType;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.generator.object.tree.ObjectBirchTree;
import cn.nukkit.level.generator.object.tree.ObjectJungleTree;
import cn.nukkit.level.generator.object.tree.ObjectOakTree;
import cn.nukkit.level.generator.object.tree.ObjectSpruceTree;
import cn.nukkit.level.generator.object.tree.ObjectTallBirchTree;
import cn.nukkit.math.NukkitRandom;

public abstract class ObjectTree {
    protected boolean overridable(int id) {
        switch (id) {
            case 0: 
            case 6: 
            case 17: 
            case 18: 
            case 78: 
            case 161: 
            case 162: {
                return true;
            }
        }
        return false;
    }

    public int getType() {
        return 0;
    }

    public int getTrunkBlock() {
        return 17;
    }

    public int getLeafBlock() {
        return 18;
    }

    public int getTreeHeight() {
        return 7;
    }

    public static void growTree(ChunkManager level, int x, int y, int z, NukkitRandom random) {
        ObjectTree.growTree(level, x, y, z, random, 0);
    }

    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", reason="Magic value in type", replaceWith="growTree(ChunkManager level, int x, int y, int z, NukkitRandom random, WoodType type, boolean tall)")
    public static void growTree(ChunkManager level, int x, int y, int z, NukkitRandom random, int type) {
        WoodType woodType;
        boolean tall = false;
        switch (type) {
            case 1: {
                woodType = WoodType.SPRUCE;
                break;
            }
            case 2: {
                woodType = WoodType.BIRCH;
                break;
            }
            case 3: {
                woodType = WoodType.JUNGLE;
                break;
            }
            case 10: {
                woodType = WoodType.BIRCH;
                tall = true;
                break;
            }
            default: {
                woodType = WoodType.OAK;
            }
        }
        ObjectTree.growTree(level, x, y, z, random, woodType, tall);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void growTree(ChunkManager level, int x, int y, int z, NukkitRandom random, WoodType type, boolean tall) {
        ObjectTree tree;
        switch (type) {
            case SPRUCE: {
                tree = new ObjectSpruceTree();
                break;
            }
            case BIRCH: {
                if (tall) {
                    tree = new ObjectTallBirchTree();
                    break;
                }
                tree = new ObjectBirchTree();
                break;
            }
            case JUNGLE: {
                tree = new ObjectJungleTree();
                break;
            }
            default: {
                tree = new ObjectOakTree();
            }
        }
        if (tree.canPlaceObject(level, x, y, z, random)) {
            tree.placeObject(level, x, y, z, random);
        }
    }

    public boolean canPlaceObject(ChunkManager level, int x, int y, int z, NukkitRandom random) {
        int radiusToCheck = 0;
        for (int yy = 0; yy < this.getTreeHeight() + 3; ++yy) {
            if (yy == 1 || yy == this.getTreeHeight()) {
                ++radiusToCheck;
            }
            for (int xx = -radiusToCheck; xx < radiusToCheck + 1; ++xx) {
                for (int zz = -radiusToCheck; zz < radiusToCheck + 1; ++zz) {
                    if (this.overridable(level.getBlockIdAt(x + xx, y + yy, z + zz))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void placeObject(ChunkManager level, int x, int y, int z, NukkitRandom random) {
        this.placeTrunk(level, x, y, z, random, this.getTreeHeight() - 1);
        for (int yy = y - 3 + this.getTreeHeight(); yy <= y + this.getTreeHeight(); ++yy) {
            double yOff = yy - (y + this.getTreeHeight());
            int mid = (int)(1.0 - yOff / 2.0);
            for (int xx = x - mid; xx <= x + mid; ++xx) {
                int xOff = Math.abs(xx - x);
                for (int zz = z - mid; zz <= z + mid; ++zz) {
                    int zOff = Math.abs(zz - z);
                    if (xOff == mid && zOff == mid && (yOff == 0.0 || random.nextBoundedInt(2) == 0) || Block.solid[level.getBlockIdAt(xx, yy, zz)]) continue;
                    level.setBlockAt(xx, yy, zz, this.getLeafBlock(), this.getType());
                }
            }
        }
    }

    protected void placeTrunk(ChunkManager level, int x, int y, int z, NukkitRandom random, int trunkHeight) {
        level.setBlockAt(x, y - 1, z, 3);
        for (int yy = 0; yy < trunkHeight; ++yy) {
            int blockId = level.getBlockIdAt(x, y + yy, z);
            if (!this.overridable(blockId)) continue;
            level.setBlockAt(x, y + yy, z, this.getTrunkBlock(), this.getType());
        }
    }
}

