/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.metrics;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.metrics.Metrics;
import cn.nukkit.utils.Config;
import cn.nukkit.utils.LoginChainData;
import cn.nukkit.utils.NukkitCollectors;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Since(value="1.4.0.0-PN")
public class NukkitMetrics {
    private static final Logger log = LogManager.getLogger(NukkitMetrics.class);
    private static final AtomicReference<Map<Server, NukkitMetrics>> metricsStarted = new AtomicReference(Collections.emptyMap());
    private final Server server;
    private boolean enabled;
    private String serverUUID;
    private boolean logFailedRequests;
    private Metrics metrics;

    @Deprecated
    @DeprecationDetails(by="PowerNukkit", since="1.4.0.0-PN", replaceWith="NukkitMetrics.startNow(Server)", reason="The original cloudburst nukkit constructor implementation behaves like a stateful static method and don't comply with Java standards. Use the static method startNow(server) instead.")
    @Since(value="1.4.0.0-PN")
    public NukkitMetrics(Server server) {
        this(server, true);
    }

    private NukkitMetrics(Server server, boolean start) {
        this.server = server;
        try {
            this.loadConfig();
        }
        catch (Exception e) {
            log.warn("Failed to load the bStats configuration file", (Throwable)e);
        }
        if (start && this.enabled) {
            NukkitMetrics.startNow(server);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static boolean startNow(Server server) {
        NukkitMetrics nukkitMetrics = NukkitMetrics.getOrCreateMetrics(server);
        return nukkitMetrics.metrics != null;
    }

    private static NukkitMetrics getOrCreateMetrics(@Nonnull Server server) {
        Map<Server, NukkitMetrics> current = metricsStarted.get();
        NukkitMetrics metrics = current.get(server);
        if (metrics != null) {
            return metrics;
        }
        current = metricsStarted.updateAndGet(before -> {
            WeakHashMap<Server, NukkitMetrics> mutable = before;
            if (before.isEmpty()) {
                mutable = new WeakHashMap<Server, NukkitMetrics>(1);
            }
            mutable.computeIfAbsent(server, NukkitMetrics::createMetrics);
            return mutable;
        });
        metrics = current.get(server);
        assert (metrics != null);
        return metrics;
    }

    @Nonnull
    private static NukkitMetrics createMetrics(@Nonnull Server server) {
        Metrics metrics;
        NukkitMetrics nukkitMetrics = new NukkitMetrics(server, false);
        if (!nukkitMetrics.enabled) {
            return nukkitMetrics;
        }
        nukkitMetrics.metrics = metrics = new Metrics("Nukkit", nukkitMetrics.serverUUID, nukkitMetrics.logFailedRequests);
        metrics.addCustomChart(new Metrics.SingleLineChart("players", () -> server.getOnlinePlayers().size()));
        metrics.addCustomChart(new Metrics.SimplePie("codename", server::getCodename));
        metrics.addCustomChart(new Metrics.SimplePie("minecraft_version", server::getVersion));
        metrics.addCustomChart(new Metrics.SimplePie("nukkit_version", server::getNukkitVersion));
        metrics.addCustomChart(new Metrics.SimplePie("xbox_auth", () -> server.getPropertyBoolean("xbox-auth") ? "Required" : "Not required"));
        metrics.addCustomChart(new Metrics.AdvancedPie("player_platform", () -> server.getOnlinePlayers().values().stream().map(Player::getLoginChainData).map(LoginChainData::getDeviceOS).collect(Collectors.groupingBy(nukkitMetrics::mapDeviceOSToString, NukkitCollectors.countingInt()))));
        metrics.addCustomChart(new Metrics.AdvancedPie("player_game_version", () -> server.getOnlinePlayers().values().stream().map(Player::getLoginChainData).collect(Collectors.groupingBy(LoginChainData::getGameVersion, NukkitCollectors.countingInt()))));
        metrics.addCustomChart(new Metrics.DrilldownPie("java_version", new JavaVersionRetriever()));
        return nukkitMetrics;
    }

    private void loadConfig() throws IOException {
        File bStatsFolder = new File(this.server.getPluginPath(), "bStats");
        if (!bStatsFolder.exists() && !bStatsFolder.mkdirs()) {
            log.warn("Failed to create bStats metrics directory");
            return;
        }
        File configFile = new File(bStatsFolder, "config.yml");
        if (!configFile.exists()) {
            this.writeFile(configFile, "# bStats collects some data for plugin authors like how many servers are using their plugins.", "# To honor their work, you should not disable it.", "# This has nearly no effect on the server performance!", "# Check out https://bStats.org/ to learn more :)", "enabled: true", "serverUuid: \"" + UUID.randomUUID().toString() + "\"", "logFailedRequests: false");
        }
        Config config = new Config(configFile, 2);
        this.enabled = config.getBoolean("enabled", true);
        this.serverUUID = config.getString("serverUuid");
        this.logFailedRequests = config.getBoolean("logFailedRequests", false);
    }

    private void writeFile(File file, String ... lines) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
        }
    }

    private String mapDeviceOSToString(int os) {
        switch (os) {
            case 1: {
                return "Android";
            }
            case 2: {
                return "iOS";
            }
            case 3: {
                return "macOS";
            }
            case 4: {
                return "FireOS";
            }
            case 5: {
                return "Gear VR";
            }
            case 6: {
                return "Hololens";
            }
            case 7: {
                return "Windows 10";
            }
            case 8: {
                return "Windows";
            }
            case 9: {
                return "Dedicated";
            }
            case 10: {
                return "PS4";
            }
            case 11: 
            case 12: {
                return "Switch";
            }
            case 13: {
                return "Xbox One";
            }
            case 14: {
                return "Windows Phone";
            }
        }
        return "Unknown";
    }

    private static class JavaVersionRetriever
    implements Callable<Map<String, Map<String, Integer>>> {
        private JavaVersionRetriever() {
        }

        @Override
        public Map<String, Map<String, Integer>> call() {
            String release;
            HashMap<String, Map<String, Integer>> map = new HashMap<String, Map<String, Integer>>();
            String javaVersion = System.getProperty("java.version");
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(javaVersion, 1);
            String majorVersion = javaVersion.split("\\.")[0];
            int indexOf = javaVersion.lastIndexOf(46);
            if (majorVersion.equals("1")) {
                release = "Java " + javaVersion.substring(0, indexOf);
            } else {
                Matcher versionMatcher = Pattern.compile("\\d+").matcher(majorVersion);
                if (versionMatcher.find()) {
                    majorVersion = versionMatcher.group(0);
                }
                release = "Java " + majorVersion;
            }
            map.put(release, entry);
            return map;
        }
    }
}

