/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.network.protocol.DataPacket;
import java.util.Arrays;

public class LevelChunkPacket
extends DataPacket {
    public static final byte NETWORK_ID = 58;
    public int chunkX;
    public int chunkZ;
    public int subChunkCount;
    public boolean cacheEnabled;
    public long[] blobIds;
    public byte[] data;

    @Override
    public byte pid() {
        return 58;
    }

    @Override
    public void decode() {
    }

    @Override
    public void encode() {
        this.reset();
        this.putVarInt(this.chunkX);
        this.putVarInt(this.chunkZ);
        this.putUnsignedVarInt(this.subChunkCount);
        this.putBoolean(this.cacheEnabled);
        if (this.cacheEnabled) {
            this.putUnsignedVarInt(this.blobIds.length);
            for (long blobId : this.blobIds) {
                this.putLLong(blobId);
            }
        }
        this.putByteArray(this.data);
    }

    public String toString() {
        return "LevelChunkPacket(chunkX=" + this.chunkX + ", chunkZ=" + this.chunkZ + ", subChunkCount=" + this.subChunkCount + ", cacheEnabled=" + this.cacheEnabled + ", blobIds=" + Arrays.toString(this.blobIds) + ")";
    }
}

