/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.rcon;

import cn.nukkit.Server;
import cn.nukkit.command.RemoteConsoleCommandSender;
import cn.nukkit.event.server.RemoteServerCommandEvent;
import cn.nukkit.network.rcon.RCONCommand;
import cn.nukkit.network.rcon.RCONServer;
import cn.nukkit.utils.TextFormat;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RCON {
    private static final Logger log = LogManager.getLogger(RCON.class);
    private final Server server;
    private final RCONServer serverThread;

    public RCON(Server server, String password, String address, int port) {
        if (password.isEmpty()) {
            throw new IllegalArgumentException("nukkit.server.rcon.emptyPasswordError");
        }
        this.server = server;
        try {
            this.serverThread = new RCONServer(address, port, password);
            this.serverThread.start();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("nukkit.server.rcon.startupError", e);
        }
        log.info(this.server.getLanguage().translateString("nukkit.server.rcon.running", new String[]{address, String.valueOf(port)}));
    }

    public void check() {
        RCONCommand command;
        if (this.serverThread == null) {
            return;
        }
        if (!this.serverThread.isAlive()) {
            return;
        }
        while ((command = this.serverThread.receive()) != null) {
            RemoteConsoleCommandSender sender = new RemoteConsoleCommandSender();
            RemoteServerCommandEvent event = new RemoteServerCommandEvent(sender, command.getCommand());
            this.server.getPluginManager().callEvent(event);
            if (!event.isCancelled()) {
                this.server.dispatchCommand(sender, command.getCommand());
            }
            this.serverThread.respond(command.getSender(), command.getId(), TextFormat.clean(sender.getMessages()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            RCONServer rCONServer = this.serverThread;
            synchronized (rCONServer) {
                this.serverThread.close();
                this.serverThread.wait(5000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

