/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import java.util.Comparator;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class HumanStringComparator
implements Comparator<String> {
    private static final HumanStringComparator INSTANCE = new HumanStringComparator();

    @Override
    public int compare(String o1, String o2) {
        String o2StringPart;
        String o1StringPart = o1.replaceAll("\\d", "");
        if (o1StringPart.equalsIgnoreCase(o2StringPart = o2.replaceAll("\\d", ""))) {
            return this.extractInt(o1) - this.extractInt(o2);
        }
        return o1.compareTo(o2);
    }

    int extractInt(String s) {
        String num = s.replaceAll("\\D", "");
        try {
            return num.isEmpty() ? 0 : Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static HumanStringComparator getInstance() {
        return INSTANCE;
    }
}

