/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nullable;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public final class Validation {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void checkPositive(@Nullable String arg, byte value) {
        if (value < 0) {
            throw new IllegalArgumentException((arg != null ? arg + ": " : "") + "Negative value is not allowed: " + value);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void checkPositive(@Nullable String arg, short value) {
        if (value < 0) {
            throw new IllegalArgumentException((arg != null ? arg + ": " : "") + "Negative value is not allowed: " + value);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void checkPositive(@Nullable String arg, int value) {
        if (value < 0) {
            throw new IllegalArgumentException((arg != null ? arg + ": " : "") + "Negative value is not allowed: " + value);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void checkPositive(@Nullable String arg, long value) {
        if (value < 0L) {
            throw new IllegalArgumentException((arg != null ? arg + ": " : "") + "Negative value is not allowed: " + value);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void checkPositive(@Nullable String arg, float value) {
        if (value < 0.0f) {
            throw new IllegalArgumentException((arg != null ? arg + ": " : "") + "Negative value is not allowed: " + value);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void checkPositive(@Nullable String arg, double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException((arg != null ? arg + ": " : "") + "Negative value is not allowed: " + value);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void checkPositive(@Nullable String arg, BigInteger value) {
        if (value.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException((arg != null ? arg + ": " : "") + "Negative value is not allowed: " + value);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void checkPositive(@Nullable String arg, BigDecimal value) {
        if (value.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException((arg != null ? arg + ": " : "") + "Negative value is not allowed: " + value);
        }
    }

    private Validation() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

