/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.command.Command;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.Event;
import cn.nukkit.event.Listener;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.plugin.EventExecutor;
import cn.nukkit.plugin.MethodEventExecutor;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.scheduler.PluginTask;
import cn.nukkit.scheduler.TaskHandler;
import co.aikar.timings.FullServerTickTiming;
import co.aikar.timings.Timing;
import co.aikar.timings.TimingIdentifier;
import co.aikar.timings.TimingsHistory;
import co.aikar.timings.TimingsManager;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Timings {
    private static final Logger log = LogManager.getLogger(Timings.class);
    private static boolean timingsEnabled = false;
    private static boolean verboseEnabled = false;
    private static boolean privacy = false;
    private static Set<String> ignoredConfigSections = new HashSet<String>();
    private static final int MAX_HISTORY_FRAMES = 12;
    private static int historyInterval = -1;
    private static int historyLength = -1;
    public static final FullServerTickTiming fullServerTickTimer;
    public static final Timing timingsTickTimer;
    public static final Timing pluginEventTimer;
    public static final Timing connectionTimer;
    public static final Timing schedulerTimer;
    public static final Timing schedulerAsyncTimer;
    public static final Timing schedulerSyncTimer;
    public static final Timing commandTimer;
    public static final Timing serverCommandTimer;
    public static final Timing levelSaveTimer;
    public static final Timing playerNetworkSendTimer;
    public static final Timing playerNetworkReceiveTimer;
    public static final Timing playerChunkOrderTimer;
    public static final Timing playerChunkSendTimer;
    public static final Timing playerCommandTimer;
    public static final Timing tickEntityTimer;
    public static final Timing tickBlockEntityTimer;
    public static final Timing entityMoveTimer;
    public static final Timing entityBaseTickTimer;
    public static final Timing livingEntityBaseTickTimer;
    public static final Timing generationTimer;
    public static final Timing populationTimer;
    public static final Timing generationCallbackTimer;
    public static final Timing permissibleCalculationTimer;
    public static final Timing permissionDefaultTimer;

    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public static void init() {
    }

    public static boolean isTimingsEnabled() {
        return timingsEnabled;
    }

    public static void setTimingsEnabled(boolean enabled) {
        timingsEnabled = enabled;
        TimingsManager.reset();
    }

    public static boolean isVerboseEnabled() {
        return verboseEnabled;
    }

    public static void setVerboseEnabled(boolean enabled) {
        verboseEnabled = enabled;
        TimingsManager.needsRecheckEnabled = true;
    }

    public static boolean isPrivacy() {
        return privacy;
    }

    public static Set<String> getIgnoredConfigSections() {
        return ignoredConfigSections;
    }

    public static int getHistoryInterval() {
        return historyInterval;
    }

    public static void setHistoryInterval(int interval) {
        historyInterval = Math.max(1200, interval);
        if (historyLength != -1) {
            Timings.setHistoryLength(historyLength);
        }
    }

    public static int getHistoryLength() {
        return historyLength;
    }

    public static void setHistoryLength(int length) {
        int maxLength = historyInterval * 12;
        if (Server.getInstance().getConfig().getBoolean("timings.bypass-max", false)) {
            maxLength = Integer.MAX_VALUE;
        }
        historyLength = Math.max(Math.min(maxLength, length), historyInterval);
        Queue<TimingsHistory> oldQueue = TimingsManager.HISTORY;
        int frames = Timings.getHistoryLength() / Timings.getHistoryInterval();
        if (length > maxLength) {
            log.warn("Timings Length too high. Requested {}, max is {}. To get longer history, you must increase your interval. Set Interval to {} to achieve this length.", (Object)length, (Object)maxLength, (Object)Math.ceil((float)length / 12.0f));
        }
        TimingsManager.HISTORY = new TimingsManager.BoundedQueue<TimingsHistory>(frames);
        TimingsManager.HISTORY.addAll(oldQueue);
    }

    public static void reset() {
        TimingsManager.reset();
    }

    public static Timing getCommandTiming(Command command) {
        return TimingsManager.getTiming(TimingIdentifier.DEFAULT_GROUP.name, "Command: " + command.getLabel(), commandTimer);
    }

    public static Timing getTaskTiming(TaskHandler handler, long period) {
        String repeating = " ";
        repeating = period > 0L ? repeating + "(interval:" + period + ")" : repeating + "(Single)";
        if (handler.getTask() instanceof PluginTask) {
            String owner = ((PluginTask)handler.getTask()).getOwner().getName();
            return TimingsManager.getTiming(owner, "PluginTask: " + handler.getTaskId() + repeating, schedulerSyncTimer);
        }
        if (!handler.isAsynchronous()) {
            return TimingsManager.getTiming(TimingIdentifier.DEFAULT_GROUP.name, "Task: " + handler.getTaskId() + repeating, schedulerSyncTimer);
        }
        return null;
    }

    public static Timing getPluginEventTiming(Class<? extends Event> event, Listener listener, EventExecutor executor, Plugin plugin) {
        Timing group = TimingsManager.getTiming(plugin.getName(), "Combined Total", pluginEventTimer);
        return TimingsManager.getTiming(plugin.getName(), "Event: " + listener.getClass().getName() + "." + (executor instanceof MethodEventExecutor ? ((MethodEventExecutor)executor).getMethod().getName() : "???") + " (" + event.getSimpleName() + ")", group);
    }

    public static Timing getEntityTiming(Entity entity) {
        return TimingsManager.getTiming(TimingIdentifier.DEFAULT_GROUP.name, "## Entity Tick: " + entity.getClass().getSimpleName(), tickEntityTimer);
    }

    public static Timing getBlockEntityTiming(BlockEntity blockEntity) {
        return TimingsManager.getTiming(TimingIdentifier.DEFAULT_GROUP.name, "## BlockEntity Tick: " + blockEntity.getClass().getSimpleName(), tickBlockEntityTimer);
    }

    public static Timing getReceiveDataPacketTiming(DataPacket pk) {
        return TimingsManager.getTiming(TimingIdentifier.DEFAULT_GROUP.name, "## Receive Packet: " + pk.getClass().getSimpleName(), playerNetworkReceiveTimer);
    }

    public static Timing getSendDataPacketTiming(DataPacket pk) {
        return TimingsManager.getTiming(TimingIdentifier.DEFAULT_GROUP.name, "## Send Packet: " + pk.getClass().getSimpleName(), playerNetworkSendTimer);
    }

    public static void stopServer() {
        Timings.setTimingsEnabled(false);
        TimingsManager.recheckEnabled();
    }

    static {
        Timings.setTimingsEnabled(Server.getInstance().getConfig("timings.enabled", false));
        Timings.setVerboseEnabled(Server.getInstance().getConfig("timings.verbose", false));
        Timings.setHistoryInterval(Server.getInstance().getConfig("timings.history-interval", 6000));
        Timings.setHistoryLength(Server.getInstance().getConfig("timings.history-length", 72000));
        privacy = Server.getInstance().getConfig("timings.privacy", false);
        ignoredConfigSections.addAll(Server.getInstance().getConfig().getStringList("timings.ignore"));
        log.debug("Timings: \nEnabled - {}\nVerbose - {}\nHistory Interval - {}\nHistory Length - {}", (Object)Timings.isTimingsEnabled(), (Object)Timings.isVerboseEnabled(), (Object)Timings.getHistoryInterval(), (Object)Timings.getHistoryLength());
        fullServerTickTimer = new FullServerTickTiming();
        timingsTickTimer = TimingsManager.getTiming(TimingIdentifier.DEFAULT_GROUP.name, "Timings Tick", fullServerTickTimer);
        pluginEventTimer = TimingsManager.getTiming("Plugin Events");
        connectionTimer = TimingsManager.getTiming("Connection Handler");
        schedulerTimer = TimingsManager.getTiming("Scheduler");
        schedulerAsyncTimer = TimingsManager.getTiming("## Scheduler - Async Tasks");
        schedulerSyncTimer = TimingsManager.getTiming("## Scheduler - Sync Tasks");
        commandTimer = TimingsManager.getTiming("Commands");
        serverCommandTimer = TimingsManager.getTiming("Server Command");
        levelSaveTimer = TimingsManager.getTiming("Level Save");
        playerNetworkSendTimer = TimingsManager.getTiming("Player Network Send");
        playerNetworkReceiveTimer = TimingsManager.getTiming("Player Network Receive");
        playerChunkOrderTimer = TimingsManager.getTiming("Player Order Chunks");
        playerChunkSendTimer = TimingsManager.getTiming("Player Send Chunks");
        playerCommandTimer = TimingsManager.getTiming("Player Command");
        tickEntityTimer = TimingsManager.getTiming("## Entity Tick");
        tickBlockEntityTimer = TimingsManager.getTiming("## BlockEntity Tick");
        entityMoveTimer = TimingsManager.getTiming("## Entity Move");
        entityBaseTickTimer = TimingsManager.getTiming("## Entity Base Tick");
        livingEntityBaseTickTimer = TimingsManager.getTiming("## LivingEntity Base Tick");
        generationTimer = TimingsManager.getTiming("Level Generation");
        populationTimer = TimingsManager.getTiming("Level Population");
        generationCallbackTimer = TimingsManager.getTiming("Level Generation Callback");
        permissibleCalculationTimer = TimingsManager.getTiming("Permissible Calculation");
        permissionDefaultTimer = TimingsManager.getTiming("Default Permission Calculation");
    }
}

