/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.utils.TextFormat;
import java.util.HashMap;

public class Achievement {
    public static final HashMap<String, Achievement> achievements = new HashMap<String, Achievement>(){
        {
            this.put("mineWood", new Achievement("Getting Wood", new String[0]));
            this.put("buildWorkBench", new Achievement("Benchmarking", "mineWood"));
            this.put("buildPickaxe", new Achievement("Time to Mine!", "buildWorkBench"));
            this.put("buildFurnace", new Achievement("Hot Topic", "buildPickaxe"));
            this.put("acquireIron", new Achievement("Acquire hardware", "buildFurnace"));
            this.put("buildHoe", new Achievement("Time to Farm!", "buildWorkBench"));
            this.put("makeBread", new Achievement("Bake Bread", "buildHoe"));
            this.put("bakeCake", new Achievement("The Lie", "buildHoe"));
            this.put("buildBetterPickaxe", new Achievement("Getting an Upgrade", "buildPickaxe"));
            this.put("buildSword", new Achievement("Time to Strike!", "buildWorkBench"));
            this.put("diamonds", new Achievement("DIAMONDS!", "acquireIron"));
        }
    };
    public final String message;
    public final String[] requires;

    public static boolean broadcast(Player player, String achievementId) {
        if (!achievements.containsKey(achievementId)) {
            return false;
        }
        String translation = Server.getInstance().getLanguage().translateString("chat.type.achievement", player.getDisplayName(), (Object)((Object)TextFormat.GREEN) + achievements.get(achievementId).getMessage() + (Object)((Object)TextFormat.RESET));
        if (Server.getInstance().getPropertyBoolean("announce-player-achievements", true)) {
            Server.getInstance().broadcastMessage(translation);
        } else {
            player.sendMessage(translation);
        }
        return true;
    }

    public static boolean add(String name, Achievement achievement) {
        if (achievements.containsKey(name)) {
            return false;
        }
        achievements.put(name, achievement);
        return true;
    }

    public Achievement(String message, String ... requires) {
        this.message = message;
        this.requires = requires;
    }

    public String getMessage() {
        return this.message;
    }

    public void broadcast(Player player) {
        String translation = Server.getInstance().getLanguage().translateString("chat.type.achievement", player.getDisplayName(), (Object)((Object)TextFormat.GREEN) + this.getMessage(), null);
        if (Server.getInstance().getPropertyBoolean("announce-player-achievements", true)) {
            Server.getInstance().broadcastMessage(translation);
        } else {
            player.sendMessage(translation);
        }
    }
}

