/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.IntBlockProperty;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

public abstract class BlockCrops
extends BlockFlowable {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final IntBlockProperty GROWTH = new IntBlockProperty("growth", false, 7);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(GROWTH);
    @PowerNukkitOnly
    public static final int MINIMUM_LIGHT_LEVEL = 9;

    protected BlockCrops(int meta) {
        super(meta);
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getMinimumLightLevel() {
        return 9;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getMaxGrowth() {
        return GROWTH.getMaxValue();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getGrowth() {
        return this.getIntValue(GROWTH);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setGrowth(int growth) {
        this.setIntValue(GROWTH, growth);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isFullyGrown() {
        return this.getGrowth() >= this.getMaxGrowth();
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (block.down().getId() == 60) {
            this.getLevel().setBlock((Vector3)block, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (item.isFertilizer()) {
            int max = this.getMaxGrowth();
            int growth = this.getGrowth();
            if (growth < max) {
                BlockCrops block = (BlockCrops)this.clone();
                block.setGrowth(Math.min(growth += ThreadLocalRandom.current().nextInt(3) + 2, max));
                BlockGrowEvent ev = new BlockGrowEvent(this, block);
                Server.getInstance().getPluginManager().callEvent(ev);
                if (ev.isCancelled()) {
                    return false;
                }
                this.getLevel().setBlock((Vector3)this, ev.getNewState(), false, true);
                this.level.addParticle(new BoneMealParticle(this));
                if (player != null && !player.isCreative()) {
                    --item.count;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (this.down().getId() == 60) return 0;
            this.getLevel().useBreakOn(this);
            return 1;
        }
        if (type != 2) return 0;
        if (ThreadLocalRandom.current().nextInt(2) != 1 || this.getLevel().getFullLight(this) < this.getMinimumLightLevel()) return 2;
        int growth = this.getGrowth();
        if (growth >= this.getMaxGrowth()) return 0;
        BlockCrops block = (BlockCrops)this.clone();
        block.setGrowth(growth + 1);
        BlockGrowEvent ev = new BlockGrowEvent(this, block);
        Server.getInstance().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) return 2;
        this.getLevel().setBlock((Vector3)this, ev.getNewState(), false, true);
        return 0;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }
}

