/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockCauldron;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.event.block.DoorToggleEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Location;
import cn.nukkit.level.Sound;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.RedstoneComponent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitDifference(info="Implements RedstoneComponent.", since="1.4.0.0-PN")
public abstract class BlockDoor
extends BlockTransparentMeta
implements RedstoneComponent,
Faceable {
    private static final double THICKNESS = 0.1875;
    private static final List<Location> manualOverrides = new ArrayList<Location>();
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BooleanBlockProperty DOOR_HINGE = new BooleanBlockProperty("door_hinge_bit", false);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperty<BlockFace> DOOR_DIRECTION = new ArrayBlockProperty("direction", false, (Serializable[])new BlockFace[]{BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH}).ordinal(true);
    protected static final BlockProperties PROPERTIES = new BlockProperties(DOOR_DIRECTION, CommonBlockProperties.OPEN, CommonBlockProperties.UPPER_BLOCK, DOOR_HINGE);
    @Deprecated
    @DeprecationDetails(reason="Use the accessors or properties instead", since="1.4.0.0-PN", replaceWith="CommonBlockProperties.OPEN")
    public static final int DOOR_OPEN_BIT = PROPERTIES.getOffset(CommonBlockProperties.OPEN.getName());
    @Deprecated
    @DeprecationDetails(reason="Use the accessors or properties instead", since="1.4.0.0-PN", replaceWith="UPPER_BLOCK")
    public static final int DOOR_TOP_BIT = PROPERTIES.getOffset(CommonBlockProperties.UPPER_BLOCK.getName());
    @Deprecated
    @DeprecationDetails(reason="Use the accessors or properties instead", since="1.4.0.0-PN", replaceWith="DOOR_HINGE")
    public static final int DOOR_HINGE_BIT = PROPERTIES.getOffset(DOOR_HINGE.getName());
    @Deprecated
    @DeprecationDetails(reason="Was removed from the game", since="1.4.0.0-PN", replaceWith="#isGettingPower()")
    public static final int DOOR_POWERED_BIT = PROPERTIES.getBitSize();

    protected BlockDoor(int meta) {
        super(meta);
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public boolean isSolid(BlockFace side) {
        return false;
    }

    @Deprecated
    @DeprecationDetails(reason="Limited amount of state data", since="1.4.0.0-PN", replaceWith="getCurrentState()")
    public int getFullDamage() {
        return this.getSignedBigDamage();
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        BlockFace position = this.getBlockFace().getOpposite();
        boolean isOpen = this.isOpen();
        boolean isRight = this.isRightHinged();
        if (isOpen) {
            return this.recalculateBoundingBoxWithPos(isRight ? position.rotateYCCW() : position.rotateY());
        }
        return this.recalculateBoundingBoxWithPos(position);
    }

    private AxisAlignedBB recalculateBoundingBoxWithPos(BlockFace pos) {
        if (pos.getAxisDirection() == BlockFace.AxisDirection.NEGATIVE) {
            return new SimpleAxisAlignedBB(this.x, this.y, this.z, this.x + 1.0 + (double)pos.getXOffset() - 0.1875 * (double)pos.getXOffset(), this.y + 1.0, this.z + 1.0 + (double)pos.getZOffset() - 0.1875 * (double)pos.getZOffset());
        }
        return new SimpleAxisAlignedBB(this.x + (double)pos.getXOffset() - 0.1875 * (double)pos.getXOffset(), this.y, this.z + (double)pos.getZOffset() - 0.1875 * (double)pos.getZOffset(), this.x + 1.0, this.y + 1.0, this.z + 1.0);
    }

    @Override
    @PowerNukkitDifference(info="Will drop the iron door item if the support is broken", since="1.3.1.2-PN")
    public int onUpdate(int type) {
        if (type == 1) {
            this.onNormalUpdate();
            return type;
        }
        if (type == 6 && this.level.getServer().isRedstoneEnabled()) {
            this.onRedstoneUpdate();
            return type;
        }
        return 0;
    }

    private void onNormalUpdate() {
        Block down = this.down();
        if (this.isTop()) {
            if (down.getId() != this.getId() || down.getBooleanValue(CommonBlockProperties.UPPER_BLOCK)) {
                this.level.setBlock((Vector3)this, Block.get(0), false);
            }
            return;
        }
        if (down.getId() == 0) {
            this.level.useBreakOn(this, this.getToolType() == 3 ? Item.get(278) : null);
        }
    }

    @PowerNukkitDifference(info="Checking if the door was opened/closed manually.")
    private void onRedstoneUpdate() {
        if (this.isOpen() != this.isGettingPower() && !this.getManualOverride()) {
            if (this.isOpen() != this.isGettingPower()) {
                this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, this.isOpen() ? 15 : 0, this.isOpen() ? 0 : 15));
                this.setOpen(null, this.isGettingPower());
            }
        } else if (this.getManualOverride() && this.isGettingPower() == this.isOpen()) {
            this.setManualOverride(false);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setManualOverride(boolean val) {
        Location up;
        Location down;
        if (this.isTop()) {
            down = this.down().getLocation();
            up = this.getLocation();
        } else {
            down = this.getLocation();
            up = this.up().getLocation();
        }
        if (val) {
            manualOverrides.add(up);
            manualOverrides.add(down);
        } else {
            manualOverrides.remove(up);
            manualOverrides.remove(down);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean getManualOverride() {
        Location up;
        Location down;
        if (this.isTop()) {
            down = this.down().getLocation();
            up = this.getLocation();
        } else {
            down = this.getLocation();
            up = this.up().getLocation();
        }
        return manualOverrides.contains(up) || manualOverrides.contains(down);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isGettingPower() {
        Location up;
        Location down;
        if (this.isTop()) {
            down = this.down().getLocation();
            up = this.getLocation();
        } else {
            down = this.getLocation();
            up = this.up().getLocation();
        }
        for (BlockFace side : BlockFace.values()) {
            Block blockDown = down.getSide(side).getLevelBlock();
            Block blockUp = up.getSide(side).getLevelBlock();
            if (!this.level.isSidePowered(blockDown.getLocation(), side) && !this.level.isSidePowered(blockUp.getLocation(), side)) continue;
            return true;
        }
        return this.level.isBlockPowered(down) || this.level.isBlockPowered(up);
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed support logic")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        if (this.y > 254.0 || face != BlockFace.UP) {
            return false;
        }
        Block blockUp = this.up();
        Block blockDown = this.down();
        if (!blockUp.canBeReplaced() || !blockDown.isSolid(BlockFace.UP) && !(blockDown instanceof BlockCauldron)) {
            return false;
        }
        BlockFace direction = player.getDirection();
        this.setBlockFace(direction);
        Block left = this.getSide(direction.rotateYCCW());
        Block right = this.getSide(direction.rotateY());
        if (left.getId() == this.getId() || !right.isTransparent() && left.isTransparent()) {
            this.setRightHinged(true);
        }
        this.setTop(false);
        this.level.setBlock((Vector3)block, this, true, false);
        if (blockUp instanceof BlockLiquid && ((BlockLiquid)blockUp).usesWaterLogging()) {
            this.level.setBlock(blockUp, 1, blockUp, true, false);
        }
        BlockDoor doorTop = (BlockDoor)this.clone();
        doorTop.y += 1.0;
        doorTop.setTop(true);
        this.level.setBlock((Vector3)doorTop, doorTop, true, true);
        this.level.updateAround(block);
        if (this.level.getServer().isRedstoneEnabled() && !this.isOpen() && this.isGettingPower()) {
            this.setOpen(null, true);
        }
        return true;
    }

    @Override
    public boolean onBreak(Item item) {
        this.setManualOverride(false);
        if (this.isTop()) {
            Block down = this.down();
            if (down.getId() == this.getId() && !down.getBooleanValue(CommonBlockProperties.UPPER_BLOCK)) {
                this.level.setBlock((Vector3)down, Block.get(0), true);
            }
        } else {
            Block up = this.up();
            if (up.getId() == this.getId() && up.getBooleanValue(CommonBlockProperties.UPPER_BLOCK)) {
                this.level.setBlock((Vector3)up, Block.get(0), true);
            }
        }
        this.getLevel().setBlock((Vector3)this, Block.get(0), true);
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        return this.toggle(player);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void playOpenCloseSound() {
        if (this.isTop() && this.down() instanceof BlockDoor) {
            if (((BlockDoor)this.down()).isOpen()) {
                this.playOpenSound();
            } else {
                this.playCloseSound();
            }
        } else if (this.up() instanceof BlockDoor) {
            if (this.isOpen()) {
                this.playOpenSound();
            } else {
                this.playCloseSound();
            }
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void playOpenSound() {
        this.level.addSound(this, Sound.RANDOM_DOOR_OPEN);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void playCloseSound() {
        this.level.addSound(this, Sound.RANDOM_DOOR_CLOSE);
    }

    @PowerNukkitDifference(info="Just call the #setOpen() method.", since="1.4.0.0-PN")
    public boolean toggle(Player player) {
        return this.setOpen(player, !this.isOpen());
    }

    @PowerNukkitDifference(info="Using direct values, instead of toggling (fixes a redstone bug, that the door won't open). Also adding possibility to detect, whether a player or redstone recently opened/closed the door.", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean setOpen(Player player, boolean open) {
        Block up;
        Block down;
        if (open == this.isOpen()) {
            return false;
        }
        DoorToggleEvent event = new DoorToggleEvent(this, player);
        this.level.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        player = event.getPlayer();
        if (this.isTop()) {
            down = this.down();
            up = this;
        } else {
            down = this;
            up = this.up();
        }
        up.setBooleanValue(CommonBlockProperties.OPEN, open);
        up.level.setBlock((Vector3)up, up, true, true);
        down.setBooleanValue(CommonBlockProperties.OPEN, open);
        down.level.setBlock((Vector3)down, down, true, true);
        if (player != null) {
            this.setManualOverride(this.isGettingPower() || this.isOpen());
        }
        this.playOpenCloseSound();
        return true;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setOpen(boolean open) {
        this.setBooleanValue(CommonBlockProperties.OPEN, open);
    }

    public boolean isOpen() {
        return this.getBooleanValue(CommonBlockProperties.OPEN);
    }

    public boolean isTop() {
        return this.getBooleanValue(CommonBlockProperties.UPPER_BLOCK);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setTop(boolean top) {
        this.setBooleanValue(CommonBlockProperties.UPPER_BLOCK, top);
    }

    @Deprecated
    @DeprecationDetails(reason="Use the properties API instead", since="1.4.0.0-PN")
    public boolean isTop(int meta) {
        return PROPERTIES.getBooleanValue(meta, CommonBlockProperties.UPPER_BLOCK.getName());
    }

    public boolean isRightHinged() {
        return this.getBooleanValue(DOOR_HINGE);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setRightHinged(boolean rightHinged) {
        this.setBooleanValue(DOOR_HINGE, rightHinged);
    }

    @Override
    public BlockFace getBlockFace() {
        return this.getPropertyValue(DOOR_DIRECTION);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setBlockFace(BlockFace face) {
        this.setPropertyValue(DOOR_DIRECTION, face);
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }
}

