/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.blockproperty.value.DoublePlantType;
import cn.nukkit.item.Item;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

public class BlockDoublePlant
extends BlockFlowable {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final ArrayBlockProperty<DoublePlantType> DOUBLE_PLANT_TYPE = new ArrayBlockProperty<DoublePlantType>("double_plant_type", true, DoublePlantType.class);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(DOUBLE_PLANT_TYPE, CommonBlockProperties.UPPER_BLOCK);
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", replaceWith="DoublePlantType.SUNFLOWER", reason="Magic values may change in future without backward compatibility.")
    public static final int SUNFLOWER = 0;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", replaceWith="DoublePlantType.LILAC", reason="Magic values may change in future without backward compatibility.")
    public static final int LILAC = 1;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", replaceWith="DoublePlantType.TALL_GRASS", reason="Magic values may change in future without backward compatibility.")
    public static final int TALL_GRASS = 2;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", replaceWith="DoublePlantType.LARGE_FERN", reason="Magic values may change in future without backward compatibility.")
    public static final int LARGE_FERN = 3;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", replaceWith="DoublePlantType.ROSE_BUSH", reason="Magic values may change in future without backward compatibility.")
    public static final int ROSE_BUSH = 4;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", replaceWith="DoublePlantType.PEONY", reason="Magic values may change in future without backward compatibility.")
    public static final int PEONY = 5;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", replaceWith="CommonBlockProperties.UPPER_BLOCK", reason="Magic values may change in future without backward compatibility.")
    public static final int TOP_HALF_BITMASK = 8;

    public BlockDoublePlant() {
        this(0);
    }

    public BlockDoublePlant(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 175;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public DoublePlantType getDoublePlantType() {
        return this.getPropertyValue(DOUBLE_PLANT_TYPE);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setDoublePlantType(@Nonnull DoublePlantType type) {
        this.setPropertyValue(DOUBLE_PLANT_TYPE, type);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isTopHalf() {
        return this.getBooleanValue(CommonBlockProperties.UPPER_BLOCK);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setTopHalf(boolean topHalf) {
        this.setBooleanValue(CommonBlockProperties.UPPER_BLOCK, topHalf);
    }

    @Override
    public boolean canBeReplaced() {
        return this.getDoublePlantType().isReplaceable();
    }

    @Override
    public String getName() {
        return this.getDoublePlantType().getEnglishName();
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Bottom part will break if the supporting block is invalid on normal update")
    public int onUpdate(int type) {
        if (type == 1) {
            if (this.isTopHalf()) {
                if (this.down().getId() != 175) {
                    this.getLevel().setBlock((Vector3)this, Block.get(0), false, true);
                    return 1;
                }
            } else if (this.up().getId() != 175 || !this.isSupportValid(this.down())) {
                this.getLevel().useBreakOn(this);
                return 1;
            }
        }
        return 0;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        Block up = this.up();
        if (up.getId() == 0 && this.isSupportValid(this.down())) {
            this.setTopHalf(false);
            this.getLevel().setBlock((Vector3)block, this, true, false);
            this.setTopHalf(true);
            this.getLevel().setBlock((Vector3)up, this, true, true);
            this.getLevel().updateAround(this);
            return true;
        }
        return false;
    }

    private boolean isSupportValid(Block support) {
        switch (support.getId()) {
            case 2: 
            case 3: 
            case 60: 
            case 243: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onBreak(Item item) {
        Block down = this.down();
        if (this.isTopHalf()) {
            this.getLevel().useBreakOn(down);
        } else {
            this.getLevel().setBlock((Vector3)this, Block.get(0), true, true);
        }
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (this.isTopHalf()) {
            return Item.EMPTY_ARRAY;
        }
        switch (this.getDoublePlantType()) {
            case GRASS: 
            case FERN: {
                boolean dropSeeds;
                boolean bl = dropSeeds = ThreadLocalRandom.current().nextInt(10) == 0;
                if (item.isShears()) {
                    if (dropSeeds) {
                        return new Item[]{Item.get(295), this.toItem()};
                    }
                    return new Item[]{this.toItem()};
                }
                if (dropSeeds) {
                    return new Item[]{Item.get(295)};
                }
                return Item.EMPTY_ARRAY;
            }
        }
        return new Item[]{this.toItem()};
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (item.isFertilizer()) {
            switch (this.getDoublePlantType()) {
                case SUNFLOWER: 
                case SYRINGA: 
                case ROSE: 
                case PAEONIA: {
                    if (player != null && (player.gamemode & 1) == 0) {
                        --item.count;
                    }
                    this.level.addParticle(new BoneMealParticle(this));
                    this.level.dropItem(this, this.toItem());
                }
            }
            return true;
        }
        return false;
    }
}

