/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockTransparent;
import cn.nukkit.blockentity.BlockEntityEnchantTable;
import cn.nukkit.inventory.EnchantInventory;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.StringTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BlockColor;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitDifference(since="1.4.0.0-PN", info="Implements BlockEntityHolder only in PowerNukkit")
public class BlockEnchantingTable
extends BlockTransparent
implements BlockEntityHolder<BlockEntityEnchantTable> {
    @Override
    public int getId() {
        return 116;
    }

    @Override
    public String getName() {
        return "Enchanting Table";
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "EnchantTable";
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityEnchantTable> getBlockEntityClass() {
        return BlockEntityEnchantTable.class;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public double getHardness() {
        return 5.0;
    }

    @Override
    public double getResistance() {
        return 6000.0;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public int getLightLevel() {
        return 12;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Will return the right BB height")
    public double getMaxY() {
        return this.getY() + 0.75;
    }

    @Override
    public int getToolTier() {
        return 1;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        CompoundTag nbt = new CompoundTag();
        if (item.hasCustomName()) {
            nbt.putString("CustomName", item.getCustomName());
        }
        if (item.hasCustomBlockData()) {
            Map<String, Tag> customData = item.getCustomBlockData().getTags();
            for (Map.Entry<String, Tag> tag : customData.entrySet()) {
                nbt.put(tag.getKey(), tag.getValue());
            }
        }
        return BlockEntityHolder.setBlockAndCreateEntity(this, true, true, nbt, new Object[0]) != null;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, @Nullable Player player) {
        if (player == null) {
            return true;
        }
        BlockEntityEnchantTable enchantTable = (BlockEntityEnchantTable)this.getOrCreateBlockEntity();
        if (enchantTable.namedTag.contains("Lock") && enchantTable.namedTag.get("Lock") instanceof StringTag && !enchantTable.namedTag.getString("Lock").equals(item.getCustomName())) {
            return false;
        }
        player.addWindow(new EnchantInventory(player.getUIInventory(), this.getLocation()), 3);
        return true;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.RED_BLOCK_COLOR;
    }

    @Override
    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public boolean isSolid(BlockFace side) {
        return false;
    }
}

