/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockCrops;
import cn.nukkit.block.BlockIceFrosted;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.block.BlockWater;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.IntBlockProperty;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import javax.annotation.Nonnull;

public class BlockFarmland
extends BlockTransparentMeta {
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final IntBlockProperty MOISTURIZED_AMOUNT = new IntBlockProperty("moisturized_amount", false, 7);
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(MOISTURIZED_AMOUNT);

    public BlockFarmland() {
        this(0);
    }

    public BlockFarmland(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Farmland";
    }

    @Override
    public int getId() {
        return 60;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public double getResistance() {
        return 3.0;
    }

    @Override
    public double getHardness() {
        return 0.6;
    }

    @Override
    public int getToolType() {
        return 2;
    }

    @Override
    public double getMaxY() {
        return this.y + 1.0;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 2) {
            Vector3 v = new Vector3();
            if (this.level.getBlock(v.setComponents(this.x, this.y + 1.0, this.z)) instanceof BlockCrops) {
                return 0;
            }
            if (this.level.getBlock(v.setComponents(this.x, this.y + 1.0, this.z)).isSolid()) {
                this.level.setBlock((Vector3)this, Block.get(3), false, true);
                return 2;
            }
            boolean found = false;
            if (this.level.isRaining()) {
                found = true;
            } else {
                int x = (int)this.x - 4;
                while ((double)x <= this.x + 4.0) {
                    int z = (int)this.z - 4;
                    while ((double)z <= this.z + 4.0) {
                        int y = (int)this.y;
                        while ((double)y <= this.y + 1.0) {
                            if ((double)z != this.z || (double)x != this.x || (double)y != this.y) {
                                v.setComponents(x, y, z);
                                int block = this.level.getBlockIdAt(v.getFloorX(), v.getFloorY(), v.getFloorZ());
                                if (block == 8 || block == 9 || block == 207) {
                                    found = true;
                                    break;
                                }
                                block = this.level.getBlockIdAt(v.getFloorX(), v.getFloorY(), v.getFloorZ(), 1);
                                if (block == 8 || block == 9 || block == 207) {
                                    found = true;
                                    break;
                                }
                            }
                            ++y;
                        }
                        ++z;
                    }
                    ++x;
                }
            }
            Block block = this.level.getBlock(v.setComponents(this.x, this.y - 1.0, this.z));
            int damage = this.getDamage();
            if (found || block instanceof BlockWater || block instanceof BlockIceFrosted) {
                if (damage < 7) {
                    this.setDamage(7);
                    this.level.setBlock((Vector3)this, this, false, damage == 0);
                }
                return 2;
            }
            if (damage > 0) {
                this.setDamage(damage - 1);
                this.level.setBlock((Vector3)this, this, false, damage == 1);
            } else {
                this.level.setBlock((Vector3)this, Block.get(3), false, true);
            }
            return 2;
        }
        return 0;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(3));
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.DIRT_BLOCK_COLOR;
    }

    @Override
    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public boolean isSolid(BlockFace side) {
        return true;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Will return true")
    public boolean isTransparent() {
        return true;
    }
}

