/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.event.redstone.RedstoneUpdateEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.RedstoneComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitDifference(info="Implements RedstoneComponent.", since="1.4.0.0-PN")
public class BlockRedstoneLamp
extends BlockSolid
implements RedstoneComponent {
    @Override
    public String getName() {
        return "Redstone Lamp";
    }

    @Override
    public int getId() {
        return 123;
    }

    @Override
    public double getHardness() {
        return 0.3;
    }

    @Override
    public double getResistance() {
        return 1.5;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    @PowerNukkitDifference(info="Using new method for checking if powered", since="1.4.0.0-PN")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        if (this.isGettingPower()) {
            this.level.setBlock((Vector3)this, Block.get(124), false, true);
        } else {
            this.level.setBlock((Vector3)this, this, false, true);
        }
        return true;
    }

    @Override
    @PowerNukkitDifference(info="Redstone Event after Block powered check + use #isGettingPower() method + trigger observer.", since="1.4.0.0-PN")
    public int onUpdate(int type) {
        if (type == 1 || type == 6) {
            if (!this.level.getServer().isRedstoneEnabled()) {
                return 0;
            }
            if (this.isGettingPower()) {
                RedstoneUpdateEvent ev = new RedstoneUpdateEvent(this);
                this.getLevel().getServer().getPluginManager().callEvent(ev);
                if (ev.isCancelled()) {
                    return 0;
                }
                this.level.updateComparatorOutputLevelSelective(this, true);
                this.level.setBlock((Vector3)this, Block.get(124), false, false);
                return 1;
            }
        }
        return 0;
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{new ItemBlock(Block.get(123))};
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }
}

