/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockCauldron;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.level.Location;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.BlockColor;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import lombok.Generated;

public class BlockEntityCauldron
extends BlockEntitySpawnable {
    @Deprecated
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Using -1 instead of the overflown 0xFFFF")
    @DeprecationDetails(by="PowerNukkit", since="1.4.0.0-PN", reason="Magic value", replaceWith="PotionType")
    public static final int POTION_TYPE_EMPTY = -1;
    @Deprecated
    @DeprecationDetails(by="PowerNukkit", since="1.4.0.0-PN", reason="Magic value", replaceWith="PotionType")
    public static final int POTION_TYPE_NORMAL = 0;
    @Deprecated
    @DeprecationDetails(by="PowerNukkit", since="1.4.0.0-PN", reason="Magic value", replaceWith="PotionType")
    public static final int POTION_TYPE_SPLASH = 1;
    @Deprecated
    @DeprecationDetails(by="PowerNukkit", since="1.4.0.0-PN", reason="Magic value", replaceWith="PotionType")
    public static final int POTION_TYPE_LINGERING = 2;
    @Deprecated
    @DeprecationDetails(by="PowerNukkit", since="1.4.0.0-PN", reason="Magic value", replaceWith="PotionType")
    public static final int POTION_TYPE_LAVA = 61851;

    public BlockEntityCauldron(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        int potionId;
        int potionType;
        if (!this.namedTag.contains("PotionId")) {
            this.namedTag.putShort("PotionId", 65535);
        }
        int n = potionType = ((potionId = this.namedTag.getShort("PotionId")) & 0xFFFF) == 65535 ? -1 : 0;
        if (this.namedTag.getBoolean("SplashPotion")) {
            potionType = 1;
            this.namedTag.remove("SplashPotion");
        }
        if (!this.namedTag.contains("PotionType")) {
            this.namedTag.putShort("PotionType", potionType);
        }
        super.initBlockEntity();
    }

    public int getPotionId() {
        return this.namedTag.getShort("PotionId");
    }

    public void setPotionId(int potionId) {
        this.namedTag.putShort("PotionId", potionId);
        this.spawnToAll();
    }

    public boolean hasPotion() {
        return (this.getPotionId() & 0xFFFF) != 65535;
    }

    public void setPotionType(int potionType) {
        this.namedTag.putShort("PotionType", (short)(potionType & 0xFFFF));
    }

    public int getPotionType() {
        return (short)(this.namedTag.getShort("PotionType") & 0xFFFF);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public PotionType getType() {
        return PotionType.getByTypeData(this.getPotionType());
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setType(PotionType type) {
        this.setPotionType(type.potionTypeData);
    }

    public boolean isSplashPotion() {
        return this.namedTag.getShort("PotionType") == 1;
    }

    @Deprecated
    public void setSplashPotion(boolean value) {
        this.namedTag.putShort("PotionType", value ? 1 : 0);
    }

    public BlockColor getCustomColor() {
        if (this.isCustomColor()) {
            int color = this.namedTag.getInt("CustomColor");
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            return new BlockColor(red, green, blue);
        }
        return null;
    }

    public boolean isCustomColor() {
        return this.namedTag.contains("CustomColor");
    }

    public void setCustomColor(BlockColor color) {
        this.setCustomColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public void setCustomColor(int r, int g, int b) {
        int color = (r << 16 | g << 8 | b) & 0xFFFFFF;
        this.namedTag.putInt("CustomColor", color);
        this.spawnToAll();
    }

    public void clearCustomColor() {
        this.namedTag.remove("CustomColor");
        this.spawnToAll();
    }

    @Override
    public void spawnToAll() {
        BlockCauldron block = (BlockCauldron)this.getBlock();
        Player[] viewers = this.level.getChunkPlayers(this.getChunkX(), this.getChunkZ()).values().toArray(Player.EMPTY_ARRAY);
        this.level.sendBlocks(viewers, new Vector3[]{block});
        super.spawnToAll();
        Location location = this.getLocation();
        Server.getInstance().getScheduler().scheduleTask(null, () -> {
            BlockEntity cauldron;
            if (this.isValid() && (cauldron = this.level.getBlockEntity(location)) == this) {
                this.level.sendBlocks(viewers, new Vector3[]{location});
                super.spawnToAll();
            }
        });
    }

    @Override
    public boolean isBlockEntityValid() {
        int id = this.getBlock().getId();
        return id == 118 || id == 465;
    }

    @Override
    public CompoundTag getSpawnCompound() {
        CompoundTag compoundTag = new CompoundTag().putString("id", "Cauldron").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putBoolean("isMovable", this.isMovable()).putList(new ListTag("Items")).putShort("PotionId", (short)this.namedTag.getShort("PotionId")).putShort("PotionType", (short)this.namedTag.getShort("PotionType"));
        if (this.namedTag.contains("CustomColor")) {
            compoundTag.putInt("CustomColor", this.namedTag.getInt("CustomColor") << 8 >> 8);
        }
        return compoundTag;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static enum PotionType {
        EMPTY(-1),
        NORMAL(0),
        SPLASH(1),
        LINGERING(2),
        LAVA(61851),
        UNKNOWN(-2);

        private final int potionTypeData;
        private static final Int2ObjectMap<PotionType> BY_DATA;

        @Nonnull
        @PowerNukkitOnly
        @Since(value="1.4.0.0-PN")
        public static PotionType getByTypeData(int typeData) {
            return (PotionType)((Object)BY_DATA.getOrDefault(typeData, (Object)UNKNOWN));
        }

        @Generated
        private PotionType(int potionTypeData) {
            this.potionTypeData = potionTypeData;
        }

        static {
            PotionType[] types = PotionType.values();
            BY_DATA = new Int2ObjectOpenHashMap(types.length);
            for (PotionType type : types) {
                BY_DATA.put(type.potionTypeData, (Object)type);
            }
        }
    }
}

