/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockproperty;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.blockproperty.IntBlockProperty;
import cn.nukkit.blockproperty.UnsignedIntBlockProperty;
import cn.nukkit.blockproperty.exception.BlockPropertyNotFoundException;
import cn.nukkit.blockstate.BigIntegerMutableBlockState;
import cn.nukkit.blockstate.ByteMutableBlockState;
import cn.nukkit.blockstate.IntMutableBlockState;
import cn.nukkit.blockstate.LongMutableBlockState;
import cn.nukkit.blockstate.MutableBlockState;
import cn.nukkit.blockstate.ZeroMutableBlockState;
import cn.nukkit.utils.functional.ToIntTriFunctionTwoInts;
import cn.nukkit.utils.functional.ToLongTriFunctionOneIntOneLong;
import cn.nukkit.utils.functional.TriFunction;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;

@ParametersAreNonnullByDefault
@PowerNukkitOnly
@Since(value="1.4.0.0")
public final class BlockProperties {
    private final Map<String, RegisteredBlockProperty> byName;
    private final int bitSize;
    private final BlockProperties itemBlockProperties;

    @PowerNukkitOnly
    @Since(value="1.4.0.0")
    public BlockProperties(BlockProperty<?> ... properties) {
        this((BlockProperties)null, properties);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0")
    public BlockProperties(@Nullable BlockProperties itemBlockProperties, BlockProperty<?> ... properties) {
        this.itemBlockProperties = itemBlockProperties == null ? this : itemBlockProperties;
        LinkedHashMap<String, RegisteredBlockProperty> registry = new LinkedHashMap<String, RegisteredBlockProperty>(properties.length);
        LinkedHashMap<String, RegisteredBlockProperty> byPersistenceName = new LinkedHashMap<String, RegisteredBlockProperty>(properties.length);
        int offset = 0;
        boolean allowItemExport = true;
        for (BlockProperty<?> property : properties) {
            Preconditions.checkArgument((property != null ? 1 : 0) != 0, (Object)"The properties can not contains null values");
            if (property.isExportedToItem()) {
                Preconditions.checkArgument((boolean)allowItemExport, (Object)"Cannot export a property to item if the previous property does not export");
                Preconditions.checkArgument((offset <= 6 ? 1 : 0) != 0);
            } else {
                allowItemExport = false;
            }
            RegisteredBlockProperty register = new RegisteredBlockProperty(property, offset);
            offset += property.getBitSize();
            Preconditions.checkArgument((registry.put(property.getName(), register) == null ? 1 : 0) != 0, (String)"The property %s is duplicated by it's normal name", (Object)property.getName());
            Preconditions.checkArgument((byPersistenceName.put(property.getPersistenceName(), register) == null ? 1 : 0) != 0, (String)"The property %s is duplicated by it's persistence name", (Object)property.getPersistenceName());
        }
        this.byName = Collections.unmodifiableMap(registry);
        this.bitSize = offset;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockProperties getItemBlockProperties() {
        return this.itemBlockProperties;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public MutableBlockState createMutableState(int blockId) {
        if (this.bitSize == 0) {
            return new ZeroMutableBlockState(blockId, this);
        }
        if (this.bitSize < 8) {
            return new ByteMutableBlockState(blockId, this);
        }
        if (this.bitSize < 32) {
            return new IntMutableBlockState(blockId, this);
        }
        if (this.bitSize < 64) {
            return new LongMutableBlockState(blockId, this);
        }
        return new BigIntegerMutableBlockState(blockId, this);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean contains(String propertyName) {
        return this.byName.containsKey(propertyName);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean contains(BlockProperty<?> property) {
        RegisteredBlockProperty registry = this.byName.get(property.getName());
        if (registry == null) {
            return false;
        }
        return registry.getProperty().getValueClass().equals(property.getValueClass());
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockProperty<?> getBlockProperty(String propertyName) {
        return this.requireRegisteredProperty(propertyName).property;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public <T extends BlockProperty<?>> T getBlockProperty(String propertyName, Class<T> tClass) {
        return (T)((BlockProperty)tClass.cast(this.requireRegisteredProperty(propertyName).property));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getOffset(String propertyName) {
        return this.requireRegisteredProperty(propertyName).offset;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Set<String> getNames() {
        return this.byName.keySet();
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Collection<RegisteredBlockProperty> getAllProperties() {
        return this.byName.values();
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public RegisteredBlockProperty requireRegisteredProperty(String propertyName) {
        RegisteredBlockProperty registry = this.byName.get(propertyName);
        if (registry == null) {
            throw new BlockPropertyNotFoundException(propertyName, this);
        }
        return registry;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int setValue(int currentMeta, String propertyName, @Nullable Serializable value) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        BlockProperty unchecked = registry.property;
        return unchecked.setValue(currentMeta, registry.offset, value);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public long setValue(long currentMeta, String propertyName, @Nullable Serializable value) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        BlockProperty unchecked = registry.property;
        return unchecked.setValue(currentMeta, registry.offset, value);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int setBooleanValue(int currentMeta, String propertyName, boolean value) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        BlockProperty property = registry.property;
        if (BooleanBlockProperty.class == property.getClass()) {
            return ((BooleanBlockProperty)property).setValue(currentMeta, registry.offset, value);
        }
        BlockProperty unchecked = registry.property;
        return unchecked.setValue(currentMeta, registry.offset, Boolean.valueOf(value));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public long setBooleanValue(long currentMeta, String propertyName, boolean value) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        BlockProperty property = registry.property;
        if (BooleanBlockProperty.class == property.getClass()) {
            return ((BooleanBlockProperty)property).setValue(currentMeta, registry.offset, value);
        }
        BlockProperty unchecked = registry.property;
        return unchecked.setValue(currentMeta, registry.offset, Boolean.valueOf(value));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BigInteger setBooleanValue(BigInteger currentMeta, String propertyName, boolean value) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        BlockProperty property = registry.property;
        if (BooleanBlockProperty.class == property.getClass()) {
            return ((BooleanBlockProperty)property).setValue(currentMeta, registry.offset, Boolean.valueOf(value));
        }
        BlockProperty unchecked = registry.property;
        return unchecked.setValue(currentMeta, registry.offset, Boolean.valueOf(value));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int setIntValue(int currentMeta, String propertyName, int value) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        BlockProperty property = registry.property;
        if (IntBlockProperty.class == property.getClass()) {
            return ((IntBlockProperty)property).setValue(currentMeta, registry.offset, Integer.valueOf(value));
        }
        if (UnsignedIntBlockProperty.class == property.getClass()) {
            return ((UnsignedIntBlockProperty)property).setValue(currentMeta, registry.offset, Integer.valueOf(value));
        }
        BlockProperty unchecked = registry.property;
        return unchecked.setValue(currentMeta, registry.offset, Integer.valueOf(value));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public long setIntValue(long currentMeta, String propertyName, int value) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        BlockProperty property = registry.property;
        if (IntBlockProperty.class == property.getClass()) {
            return ((IntBlockProperty)property).setValue(currentMeta, registry.offset, Integer.valueOf(value));
        }
        if (UnsignedIntBlockProperty.class == property.getClass()) {
            return ((UnsignedIntBlockProperty)property).setValue(currentMeta, registry.offset, Integer.valueOf(value));
        }
        BlockProperty unchecked = registry.property;
        return unchecked.setValue(currentMeta, registry.offset, Integer.valueOf(value));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BigInteger setIntValue(BigInteger currentMeta, String propertyName, int value) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        BlockProperty property = registry.property;
        if (IntBlockProperty.class == property.getClass()) {
            return ((IntBlockProperty)property).setValue(currentMeta, registry.offset, Integer.valueOf(value));
        }
        if (UnsignedIntBlockProperty.class == property.getClass()) {
            return ((UnsignedIntBlockProperty)property).setValue(currentMeta, registry.offset, Integer.valueOf(value));
        }
        BlockProperty unchecked = registry.property;
        return unchecked.setValue(currentMeta, registry.offset, Integer.valueOf(value));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int setPersistenceValue(int currentMeta, String propertyName, String persistenceValue) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        BlockProperty property = registry.property;
        int meta = property.getMetaForPersistenceValue(persistenceValue);
        Object value = property.getValueForMeta(meta);
        return property.setValue(currentMeta, registry.offset, value);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public long setPersistenceValue(long currentMeta, String propertyName, String persistenceValue) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        BlockProperty property = registry.property;
        int meta = property.getMetaForPersistenceValue(persistenceValue);
        Object value = property.getValueForMeta(meta);
        return property.setValue(currentMeta, registry.offset, value);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BigInteger setPersistenceValue(BigInteger currentMeta, String propertyName, String persistenceValue) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        BlockProperty property = registry.property;
        int meta = property.getMetaForPersistenceValue(persistenceValue);
        Object value = property.getValueForMeta(meta);
        return property.setValue(currentMeta, registry.offset, value);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BigInteger setValue(BigInteger currentMeta, String propertyName, @Nullable Serializable value) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        BlockProperty unchecked = registry.property;
        return unchecked.setValue(currentMeta, registry.offset, value);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Serializable getValue(int currentMeta, String propertyName) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        return registry.property.getValue(currentMeta, registry.offset);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Serializable getValue(long currentMeta, String propertyName) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        return registry.property.getValue(currentMeta, registry.offset);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Serializable getValue(BigInteger currentMeta, String propertyName) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        return registry.property.getValue(currentMeta, registry.offset);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public <T> T getCheckedValue(int currentMeta, String propertyName, Class<T> tClass) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        return tClass.cast(registry.property.getValue(currentMeta, registry.offset));
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public <T> T getCheckedValue(long currentMeta, String propertyName, Class<T> tClass) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        return tClass.cast(registry.property.getValue(currentMeta, registry.offset));
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public <T> T getCheckedValue(BigInteger currentMeta, String propertyName, Class<T> tClass) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        return tClass.cast(registry.property.getValue(currentMeta, registry.offset));
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public <T> T getUncheckedValue(int currentMeta, String propertyName) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        return registry.property.getValue(currentMeta, registry.offset);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public <T> T getUncheckedValue(long currentMeta, String propertyName) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        return registry.property.getValue(currentMeta, registry.offset);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public <T> T getUncheckedValue(BigInteger currentMeta, String propertyName) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        return registry.property.getValue(currentMeta, registry.offset);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getIntValue(int currentMeta, String propertyName) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        return registry.property.getIntValue(currentMeta, registry.offset);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getIntValue(long currentMeta, String propertyName) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        return registry.property.getIntValue(currentMeta, registry.offset);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getIntValue(BigInteger currentMeta, String propertyName) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        return registry.property.getIntValue(currentMeta, registry.offset);
    }

    public String getPersistenceValue(int currentMeta, String propertyName) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        return registry.property.getPersistenceValue(currentMeta, registry.offset);
    }

    public String getPersistenceValue(long currentMeta, String propertyName) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        return registry.property.getPersistenceValue(currentMeta, registry.offset);
    }

    public String getPersistenceValue(BigInteger currentMeta, String propertyName) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        return registry.property.getPersistenceValue(currentMeta, registry.offset);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean getBooleanValue(int currentMeta, String propertyName) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        if (registry.property instanceof BooleanBlockProperty) {
            return ((BooleanBlockProperty)registry.property).getBooleanValue(currentMeta, registry.offset);
        }
        return (Boolean)registry.property.getValue(currentMeta, registry.offset);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean getBooleanValue(long currentMeta, String propertyName) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        if (registry.property instanceof BooleanBlockProperty) {
            return ((BooleanBlockProperty)registry.property).getBooleanValue(currentMeta, registry.offset);
        }
        return (Boolean)registry.property.getValue(currentMeta, registry.offset);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean getBooleanValue(BigInteger currentMeta, String propertyName) {
        RegisteredBlockProperty registry = this.requireRegisteredProperty(propertyName);
        if (registry.property instanceof BooleanBlockProperty) {
            return ((BooleanBlockProperty)registry.property).getBooleanValue(currentMeta, registry.offset);
        }
        return (Boolean)registry.property.getValue(currentMeta, registry.offset);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getBitSize() {
        return this.bitSize;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void forEach(ObjIntConsumer<BlockProperty<?>> consumer) {
        for (RegisteredBlockProperty registry : this.byName.values()) {
            consumer.accept(registry.property, registry.offset);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void forEach(Consumer<BlockProperty<?>> consumer) {
        for (RegisteredBlockProperty registry : this.byName.values()) {
            consumer.accept(registry.property);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public <R> R reduce(R identity, TriFunction<BlockProperty<?>, Integer, R, R> accumulator) {
        R result = identity;
        for (RegisteredBlockProperty registry : this.byName.values()) {
            result = accumulator.apply(registry.property, registry.offset, result);
        }
        return result;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int reduceInt(int identity, ToIntTriFunctionTwoInts<BlockProperty<?>> accumulator) {
        int result = identity;
        for (RegisteredBlockProperty registry : this.byName.values()) {
            result = accumulator.apply(registry.property, registry.offset, result);
        }
        return result;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public long reduceLong(long identity, ToLongTriFunctionOneIntOneLong<BlockProperty<?>> accumulator) {
        long result = identity;
        for (RegisteredBlockProperty registry : this.byName.values()) {
            result = accumulator.apply(registry.property, registry.offset, result);
        }
        return result;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public List<String> getItemPropertyNames() {
        ArrayList<String> itemProperties = new ArrayList<String>(this.byName.size());
        for (RegisteredBlockProperty registry : this.byName.values()) {
            if (!registry.property.isExportedToItem()) break;
            itemProperties.add(registry.property.getName());
        }
        return itemProperties;
    }

    public String toString() {
        return "BlockProperties{bitSize=" + this.bitSize + ", properties=" + this.byName.values() + '}';
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isDefaultValue(String propertyName, @Nullable Serializable value) {
        BlockProperty<?> blockProperty = this.getBlockProperty(propertyName);
        return blockProperty.isDefaultValue(value);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public <T extends Serializable> boolean isDefaultValue(BlockProperty<T> property, @Nullable T value) {
        return this.isDefaultValue(property.getName(), value);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isDefaultIntValue(String propertyName, int value) {
        BlockProperty<?> blockProperty = this.getBlockProperty(propertyName);
        return blockProperty.isDefaultIntValue(value);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public <T extends Serializable> boolean isDefaultIntValue(BlockProperty<T> property, int value) {
        return this.isDefaultIntValue(property.getName(), value);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isDefaultBooleanValue(String propertyName, boolean value) {
        BlockProperty<?> blockProperty = this.getBlockProperty(propertyName);
        return blockProperty.isDefaultBooleanValue(value);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public <T extends Serializable> boolean isDefaultBooleanValue(BlockProperty<T> property, boolean value) {
        return this.isDefaultBooleanValue(property.getName(), value);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final class RegisteredBlockProperty {
        @Nonnull
        @PowerNukkitOnly
        @Since(value="1.4.0.0-PN")
        private final BlockProperty<?> property;
        @PowerNukkitOnly
        @Since(value="1.4.0.0-PN")
        private final int offset;

        @PowerNukkitOnly
        @Since(value="1.4.0.0-PN")
        public void validateMeta(int meta) {
            this.property.validateMeta(meta, this.offset);
        }

        @PowerNukkitOnly
        @Since(value="1.4.0.0-PN")
        public void validateMeta(long meta) {
            this.property.validateMeta(meta, this.offset);
        }

        @PowerNukkitOnly
        @Since(value="1.4.0.0-PN")
        public void validateMeta(BigInteger meta) {
            this.property.validateMeta(meta, this.offset);
        }

        public String toString() {
            return this.offset + "-" + (this.offset + this.property.getBitSize()) + ":" + this.property.getName();
        }

        @Generated
        public RegisteredBlockProperty(@Nonnull BlockProperty<?> property, int offset) {
            if (property == null) {
                throw new NullPointerException("property is marked @NonNull but is null");
            }
            this.property = property;
            this.offset = offset;
        }

        @Nonnull
        @Generated
        public BlockProperty<?> getProperty() {
            return this.property;
        }

        @Generated
        public int getOffset() {
            return this.offset;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegisteredBlockProperty)) {
                return false;
            }
            RegisteredBlockProperty other = (RegisteredBlockProperty)o;
            BlockProperty<?> this$property = this.getProperty();
            BlockProperty<?> other$property = other.getProperty();
            if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
                return false;
            }
            return this.getOffset() == other.getOffset();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BlockProperty<?> $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            result = result * 59 + this.getOffset();
            return result;
        }
    }
}

