/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.projectile;

import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.level.Sound;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.EntityEventPacket;
import java.util.concurrent.ThreadLocalRandom;

public class EntityArrow
extends EntityProjectile {
    public static final int NETWORK_ID = 80;
    public static final int DATA_SOURCE_ID = 17;
    public static final int PICKUP_NONE = 0;
    public static final int PICKUP_ANY = 1;
    public static final int PICKUP_CREATIVE = 2;
    protected int pickupMode;

    @Override
    public int getNetworkId() {
        return 80;
    }

    @Override
    public float getWidth() {
        return 0.5f;
    }

    @Override
    public float getLength() {
        return 0.5f;
    }

    @Override
    public float getHeight() {
        return 0.5f;
    }

    @Override
    public float getGravity() {
        return 0.05f;
    }

    @Override
    public float getDrag() {
        return 0.01f;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    protected void updateMotion() {
        if (!this.isInsideOfWater()) {
            super.updateMotion();
            return;
        }
        float drag = 1.0f - this.getDrag() * 20.0f;
        this.motionY -= (double)(this.getGravity() * 2.0f);
        if (this.motionY < 0.0) {
            this.motionY *= (double)drag / 1.5;
        }
        this.motionX *= (double)drag;
        this.motionZ *= (double)drag;
    }

    public EntityArrow(FullChunk chunk, CompoundTag nbt) {
        this(chunk, nbt, null);
    }

    public EntityArrow(FullChunk chunk, CompoundTag nbt, Entity shootingEntity) {
        this(chunk, nbt, shootingEntity, false);
    }

    public EntityArrow(FullChunk chunk, CompoundTag nbt, Entity shootingEntity, boolean critical) {
        super(chunk, nbt, shootingEntity);
        this.closeOnCollide = false;
        this.setCritical(critical);
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        this.damage = this.namedTag.contains("damage") ? this.namedTag.getDouble("damage") : 2.0;
        this.pickupMode = this.namedTag.contains("pickup") ? this.namedTag.getByte("pickup") : 1;
    }

    public void setCritical() {
        this.setCritical(true);
    }

    public void setCritical(boolean value) {
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_CRITICAL, value);
    }

    public boolean isCritical() {
        return this.getDataFlag(DATA_FLAGS, DATA_FLAG_CRITICAL);
    }

    @Override
    public int getResultDamage() {
        int base = super.getResultDamage();
        if (this.isCritical()) {
            base += ThreadLocalRandom.current().nextInt(base / 2 + 2);
        }
        return base;
    }

    @Override
    protected double getBaseDamage() {
        return 2.0;
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        this.timing.startTiming();
        boolean hasUpdate = super.onUpdate(currentTick);
        if (this.onGround || this.hadCollision) {
            this.setCritical(false);
        }
        if (this.age > 1200) {
            this.close();
            hasUpdate = true;
        }
        if (this.level.isRaining() && this.fireTicks > 0 && this.level.canBlockSeeSky(this)) {
            this.extinguish();
            hasUpdate = true;
        }
        this.timing.stopTiming();
        return hasUpdate;
    }

    @Override
    public boolean canBeMovedByCurrents() {
        return !this.hadCollision;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    protected void afterCollisionWithEntity(Entity entity) {
        if (this.hadCollision) {
            this.close();
        } else {
            this.setMotion(this.getMotion().divide(-4.0));
        }
    }

    @Override
    protected void addHitEffect() {
        this.level.addSound(this, Sound.RANDOM_BOWHIT);
        EntityEventPacket packet = new EntityEventPacket();
        packet.eid = this.getId();
        packet.event = 39;
        packet.data = 7;
        Server.broadcastPacket(this.hasSpawned.values(), (DataPacket)packet);
        this.onGround = true;
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putByte("pickup", this.pickupMode);
    }

    public int getPickupMode() {
        return this.pickupMode;
    }

    public void setPickupMode(int pickupMode) {
        this.pickupMode = pickupMode;
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public String getOriginalName() {
        return "Arrow";
    }
}

