/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.event.entity;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.Cancellable;
import cn.nukkit.event.HandlerList;
import cn.nukkit.event.entity.EntityEvent;
import cn.nukkit.item.enchantment.sideeffect.SideEffect;
import cn.nukkit.utils.EventException;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class EntityDamageEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private int attackCooldown = 10;
    private final DamageCause cause;
    private final Map<DamageModifier, Float> modifiers;
    private final Map<DamageModifier, Float> originals;
    private SideEffect[] sideEffects = SideEffect.EMPTY_ARRAY;

    public static HandlerList getHandlers() {
        return handlers;
    }

    private static Map<DamageModifier, Float> createDamageModifierMap(float baseDamage) {
        EnumMap<DamageModifier, Float> modifiers = new EnumMap<DamageModifier, Float>(DamageModifier.class);
        modifiers.put(DamageModifier.BASE, Float.valueOf(baseDamage));
        return modifiers;
    }

    public EntityDamageEvent(Entity entity, DamageCause cause, float damage) {
        this(entity, cause, EntityDamageEvent.createDamageModifierMap(damage));
    }

    public EntityDamageEvent(Entity entity, DamageCause cause, Map<DamageModifier, Float> modifiers) {
        this.entity = entity;
        this.cause = cause;
        this.modifiers = new EnumMap<DamageModifier, Float>(modifiers);
        this.originals = ImmutableMap.copyOf(this.modifiers);
        if (!this.modifiers.containsKey((Object)DamageModifier.BASE)) {
            throw new EventException("BASE Damage modifier missing");
        }
        if (entity.hasEffect(11)) {
            this.setDamage((float)(-((double)this.getDamage(DamageModifier.BASE) * 0.2 * (double)(entity.getEffect(11).getAmplifier() + 1))), DamageModifier.RESISTANCE);
        }
    }

    public DamageCause getCause() {
        return this.cause;
    }

    public float getOriginalDamage() {
        return this.getOriginalDamage(DamageModifier.BASE);
    }

    public float getOriginalDamage(DamageModifier type) {
        if (this.originals.containsKey((Object)type)) {
            return this.originals.get((Object)type).floatValue();
        }
        return 0.0f;
    }

    public float getDamage() {
        return this.getDamage(DamageModifier.BASE);
    }

    public float getDamage(DamageModifier type) {
        if (this.modifiers.containsKey((Object)type)) {
            return this.modifiers.get((Object)type).floatValue();
        }
        return 0.0f;
    }

    public void setDamage(float damage) {
        this.setDamage(damage, DamageModifier.BASE);
    }

    public void setDamage(float damage, DamageModifier type) {
        this.modifiers.put(type, Float.valueOf(damage));
    }

    public boolean isApplicable(DamageModifier type) {
        return this.modifiers.containsKey((Object)type);
    }

    public float getFinalDamage() {
        float damage = 0.0f;
        for (Float d : this.modifiers.values()) {
            if (d == null) continue;
            damage += d.floatValue();
        }
        return damage;
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public void setAttackCooldown(int attackCooldown) {
        this.attackCooldown = attackCooldown;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public SideEffect[] getSideEffects() {
        SideEffect[] sideEffectsArray = this.sideEffects;
        if (sideEffectsArray.length == 0) {
            return sideEffectsArray;
        }
        return (SideEffect[])Arrays.stream(sideEffectsArray).map(SideEffect::clone).toArray(SideEffect[]::new);
    }

    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public void setSideEffects(SideEffect ... sideEffects) {
        this.sideEffects = (SideEffect[])Arrays.stream(sideEffects).filter(Objects::nonNull).map(SideEffect::clone).toArray(SideEffect[]::new);
    }

    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public void setSideEffects(@Nonnull Collection<SideEffect> sideEffects) {
        this.setSideEffects(sideEffects.toArray(SideEffect.EMPTY_ARRAY));
    }

    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public void addSideEffects(SideEffect ... sideEffects) {
        Stream<SideEffect> safeStream = Arrays.stream(sideEffects).filter(Objects::nonNull).map(SideEffect::clone);
        this.sideEffects = (SideEffect[])Stream.concat(Arrays.stream(this.sideEffects), safeStream).toArray(SideEffect[]::new);
    }

    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public void addSideEffects(@Nonnull Collection<SideEffect> sideEffects) {
        this.addSideEffects(sideEffects.toArray(SideEffect.EMPTY_ARRAY));
    }

    public boolean canBeReducedByArmor() {
        switch (this.cause) {
            case FIRE_TICK: 
            case SUFFOCATION: 
            case DROWNING: 
            case HUNGER: 
            case FALL: 
            case VOID: 
            case MAGIC: 
            case SUICIDE: {
                return false;
            }
        }
        return true;
    }

    public static enum DamageCause {
        CONTACT,
        ENTITY_ATTACK,
        PROJECTILE,
        SUFFOCATION,
        FALL,
        FIRE,
        FIRE_TICK,
        LAVA,
        DROWNING,
        BLOCK_EXPLOSION,
        ENTITY_EXPLOSION,
        VOID,
        SUICIDE,
        MAGIC,
        CUSTOM,
        LIGHTNING,
        HUNGER,
        WITHER,
        THORNS,
        FALLING_BLOCK,
        FLYING_INTO_WALL,
        HOT_FLOOR,
        FIREWORKS,
        FREEZING;

    }

    public static enum DamageModifier {
        BASE,
        ARMOR,
        STRENGTH,
        WEAKNESS,
        RESISTANCE,
        ABSORPTION,
        ARMOR_ENCHANTMENTS;

    }
}

