/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory.transaction;

import cn.nukkit.Player;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.event.block.AnvilDamageEvent;
import cn.nukkit.event.inventory.RepairItemEvent;
import cn.nukkit.inventory.AnvilInventory;
import cn.nukkit.inventory.FakeBlockMenu;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.transaction.InventoryTransaction;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.inventory.transaction.action.RepairItemAction;
import cn.nukkit.item.Item;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.math.Vector3;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

@Since(value="1.4.0.0-PN")
public class RepairItemTransaction
extends InventoryTransaction {
    private Item inputItem;
    private Item materialItem;
    private Item outputItem;
    private int cost;

    @Since(value="1.4.0.0-PN")
    public RepairItemTransaction(Player source, List<InventoryAction> actions) {
        super(source, actions);
    }

    @Override
    public boolean canExecute() {
        Inventory inventory = this.getSource().getWindowById(2);
        if (inventory == null) {
            return false;
        }
        AnvilInventory anvilInventory = (AnvilInventory)inventory;
        return this.inputItem != null && this.outputItem != null && this.inputItem.equals(anvilInventory.getInputSlot(), true, true) && (!this.hasMaterial() || this.materialItem.equals(anvilInventory.getMaterialSlot(), true, true)) && this.checkRecipeValid();
    }

    @Override
    public boolean execute() {
        if (this.hasExecuted() || !this.canExecute()) {
            this.source.removeAllWindows(false);
            this.sendInventories();
            return false;
        }
        AnvilInventory inventory = (AnvilInventory)this.getSource().getWindowById(2);
        if (inventory.getCost() != this.cost && !this.source.isCreative()) {
            this.source.getServer().getLogger().debug("Got unexpected cost " + inventory.getCost() + " from " + this.source.getName() + "(expected " + this.cost + ")");
        }
        RepairItemEvent event = new RepairItemEvent(inventory, this.inputItem, this.outputItem, this.materialItem, this.cost, this.source);
        this.source.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            this.source.removeAllWindows(false);
            this.sendInventories();
            return true;
        }
        for (InventoryAction action : this.actions) {
            if (action.execute(this.source)) {
                action.onExecuteSuccess(this.source);
                continue;
            }
            action.onExecuteFail(this.source);
        }
        FakeBlockMenu holder = inventory.getHolder();
        Block block = this.source.level.getBlock(holder.getFloorX(), holder.getFloorY(), holder.getFloorZ());
        if (block.getId() == 145) {
            int oldDamage = block.getDamage() >= 8 ? 2 : (block.getDamage() >= 4 ? 1 : 0);
            int newDamage = !this.source.isCreative() && ThreadLocalRandom.current().nextInt(100) < 12 ? oldDamage + 1 : oldDamage;
            AnvilDamageEvent ev = new AnvilDamageEvent(block, oldDamage, newDamage, AnvilDamageEvent.DamageCause.USE, this.source);
            ev.setCancelled(oldDamage == newDamage);
            this.source.getServer().getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                newDamage = ev.getNewDamage();
                if (newDamage > 2) {
                    this.source.level.setBlock((Vector3)block, Block.get(0), true);
                    this.source.level.addLevelEvent(block, 1020);
                } else {
                    if (newDamage < 0) {
                        newDamage = 0;
                    }
                    if (newDamage != oldDamage) {
                        block.setDamage(newDamage << 2 | block.getDamage() & 3);
                        this.source.level.setBlock((Vector3)block, block, true);
                    }
                    this.source.level.addLevelEvent(block, 1021);
                }
            } else {
                this.source.level.addLevelEvent(block, 1021);
            }
        }
        if (!this.source.isCreative()) {
            this.source.setExperience(this.source.getExperience(), this.source.getExperienceLevel() - event.getCost());
        }
        return true;
    }

    @Override
    public void addAction(InventoryAction action) {
        super.addAction(action);
        if (action instanceof RepairItemAction) {
            switch (((RepairItemAction)action).getType()) {
                case -10: {
                    this.inputItem = action.getTargetItem();
                    break;
                }
                case -12: {
                    this.outputItem = action.getSourceItem();
                    break;
                }
                case -11: {
                    this.materialItem = action.getTargetItem();
                }
            }
        }
    }

    private boolean checkRecipeValid() {
        int cost;
        int baseRepairCost = this.inputItem.getRepairCost();
        if (this.isMapRecipe()) {
            if (!this.matchMapRecipe()) {
                return false;
            }
            baseRepairCost = 0;
        } else if (this.hasMaterial()) {
            baseRepairCost += this.materialItem.getRepairCost();
            if (this.inputItem.getMaxDurability() != -1 && this.matchRepairItem()) {
                int maxRepairDamage = this.inputItem.getMaxDurability() / 4;
                int repairDamage = Math.min(this.inputItem.getDamage(), maxRepairDamage);
                if (repairDamage <= 0) {
                    return false;
                }
                int damage = this.inputItem.getDamage();
                for (cost = 0; repairDamage > 0 && cost < this.materialItem.getCount(); ++cost) {
                    repairDamage = Math.min(damage -= repairDamage, maxRepairDamage);
                }
                if (this.outputItem.getDamage() != damage) {
                    return false;
                }
            } else {
                boolean consumeEnchantedBook;
                boolean bl = consumeEnchantedBook = this.materialItem.getId() == 403 && this.materialItem.hasEnchantments();
                if (!(consumeEnchantedBook || this.inputItem.getMaxDurability() != -1 && this.inputItem.getId() == this.materialItem.getId())) {
                    return false;
                }
                if (!consumeEnchantedBook && this.inputItem.getMaxDurability() != -1) {
                    int damage = this.inputItem.getDamage() - this.inputItem.getMaxDurability() + this.materialItem.getDamage() - this.inputItem.getMaxDurability() * 12 / 100 + 1;
                    if (damage < 0) {
                        damage = 0;
                    }
                    if (damage < this.inputItem.getDamage()) {
                        if (this.outputItem.getDamage() != damage) {
                            return false;
                        }
                        cost += 2;
                    }
                }
                Int2IntOpenHashMap enchantments = new Int2IntOpenHashMap();
                enchantments.defaultReturnValue(-1);
                for (Enchantment enchantment : this.inputItem.getEnchantments()) {
                    enchantments.put(enchantment.getId(), enchantment.getLevel());
                }
                boolean hasCompatibleEnchantments = false;
                boolean hasIncompatibleEnchantments = false;
                for (Enchantment materialEnchantment : this.materialItem.getEnchantments()) {
                    int rarityFactor;
                    Enchantment enchantment = this.inputItem.getEnchantment(materialEnchantment.getId());
                    int inputLevel = enchantment != null ? enchantment.getLevel() : 0;
                    int materialLevel = materialEnchantment.getLevel();
                    int outputLevel = inputLevel == materialLevel ? materialLevel + 1 : Math.max(materialLevel, inputLevel);
                    boolean canEnchant = materialEnchantment.canEnchant(this.inputItem) || this.inputItem.getId() == 403;
                    for (Enchantment inputEnchantment : this.inputItem.getEnchantments()) {
                        if (inputEnchantment.getId() == materialEnchantment.getId() || materialEnchantment.isCompatibleWith(inputEnchantment)) continue;
                        canEnchant = false;
                        ++cost;
                    }
                    if (!canEnchant) {
                        hasIncompatibleEnchantments = true;
                        continue;
                    }
                    hasCompatibleEnchantments = true;
                    if (outputLevel > materialEnchantment.getMaxLevel()) {
                        outputLevel = materialEnchantment.getMaxLevel();
                    }
                    enchantments.put(materialEnchantment.getId(), outputLevel);
                    switch (materialEnchantment.getRarity()) {
                        case COMMON: {
                            rarityFactor = 1;
                            break;
                        }
                        case UNCOMMON: {
                            rarityFactor = 2;
                            break;
                        }
                        case RARE: {
                            rarityFactor = 4;
                            break;
                        }
                        default: {
                            rarityFactor = 8;
                        }
                    }
                    if (consumeEnchantedBook) {
                        rarityFactor = Math.max(1, rarityFactor / 2);
                    }
                    cost += rarityFactor * Math.max(0, outputLevel - inputLevel);
                    if (this.inputItem.getCount() <= 1) continue;
                    cost = 40;
                }
                Enchantment[] outputEnchantments = this.outputItem.getEnchantments();
                if (hasIncompatibleEnchantments && !hasCompatibleEnchantments || enchantments.size() != outputEnchantments.length) {
                    return false;
                }
                for (Enchantment enchantment : outputEnchantments) {
                    if (enchantments.get(enchantment.getId()) == enchantment.getLevel()) continue;
                    return false;
                }
            }
        }
        int renameCost = 0;
        if (!this.inputItem.getCustomName().equals(this.outputItem.getCustomName())) {
            if (this.outputItem.getCustomName().length() > 30) {
                return false;
            }
            renameCost = 1;
            cost += renameCost;
        }
        this.cost = baseRepairCost + cost;
        if (renameCost == cost && renameCost > 0 && this.cost >= 40) {
            this.cost = 39;
        }
        if (baseRepairCost < 0 || cost < 0 || cost == 0 && !this.isMapRecipe() || this.cost > 39 && !this.source.isCreative()) {
            return false;
        }
        int nextBaseRepairCost = this.inputItem.getRepairCost();
        if (!this.isMapRecipe()) {
            if (this.hasMaterial() && nextBaseRepairCost < this.materialItem.getRepairCost()) {
                nextBaseRepairCost = this.materialItem.getRepairCost();
            }
            if (renameCost == 0 || renameCost != cost) {
                nextBaseRepairCost = 2 * nextBaseRepairCost + 1;
            }
        }
        if (this.outputItem.getRepairCost() != nextBaseRepairCost) {
            this.source.getServer().getLogger().debug("Got unexpected base cost " + this.outputItem.getRepairCost() + " from " + this.source.getName() + "(expected " + nextBaseRepairCost + ")");
            return false;
        }
        return true;
    }

    private boolean hasMaterial() {
        return this.materialItem != null && !this.materialItem.isNull();
    }

    private boolean isMapRecipe() {
        return !(!this.hasMaterial() || this.inputItem.getId() != 358 && this.inputItem.getId() != 395 || this.materialItem.getId() != 395 && this.materialItem.getId() != 339 && this.materialItem.getId() != 345);
    }

    private boolean matchMapRecipe() {
        if (this.inputItem.getId() == 395) {
            return this.inputItem.getDamage() != 2 && this.materialItem.getId() == 345 && this.outputItem.getId() == 395 && this.outputItem.getDamage() == 2 && this.outputItem.getCount() == 1;
        }
        if (this.inputItem.getId() == 358 && this.outputItem.getDamage() == this.inputItem.getDamage()) {
            if (this.materialItem.getId() == 345) {
                return this.inputItem.getDamage() != 2 && this.outputItem.getId() == 358 && this.outputItem.getCount() == 1;
            }
            if (this.materialItem.getId() == 395) {
                return this.outputItem.getId() == 358 && this.outputItem.getCount() == 2;
            }
            if (this.materialItem.getId() == 339 && this.materialItem.getCount() >= 8) {
                return this.inputItem.getDamage() < 3 && this.outputItem.getId() == 358 && this.outputItem.getCount() == 1;
            }
        }
        return false;
    }

    private boolean matchRepairItem() {
        switch (this.inputItem.getId()) {
            case 298: 
            case 299: 
            case 300: 
            case 301: {
                return this.materialItem.getId() == 334;
            }
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 290: {
                return this.materialItem.getId() == 5;
            }
            case 256: 
            case 257: 
            case 258: 
            case 267: 
            case 292: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: {
                return this.materialItem.getId() == 265;
            }
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 294: 
            case 314: 
            case 315: 
            case 316: 
            case 317: {
                return this.materialItem.getId() == 266;
            }
            case 276: 
            case 277: 
            case 278: 
            case 279: 
            case 293: 
            case 310: 
            case 311: 
            case 312: 
            case 313: {
                return this.materialItem.getId() == 264;
            }
            case 743: 
            case 744: 
            case 745: 
            case 746: 
            case 747: 
            case 748: 
            case 749: 
            case 750: 
            case 751: {
                return this.materialItem.getId() == 742;
            }
            case 469: {
                return this.materialItem.getId() == 468;
            }
            case 444: {
                return this.materialItem.getId() == 470;
            }
        }
        return false;
    }

    @Since(value="1.4.0.0-PN")
    public Item getInputItem() {
        return this.inputItem;
    }

    @Since(value="1.4.0.0-PN")
    public Item getMaterialItem() {
        return this.materialItem;
    }

    @Since(value="1.4.0.0-PN")
    public Item getOutputItem() {
        return this.outputItem;
    }

    @Since(value="1.4.0.0-PN")
    public int getCost() {
        return this.cost;
    }

    @Since(value="1.4.0.0-PN")
    public static boolean checkForRepairItemPart(List<InventoryAction> actions) {
        for (InventoryAction action : actions) {
            if (!(action instanceof RepairItemAction)) continue;
            return true;
        }
        return false;
    }
}

