/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory.transaction;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.event.inventory.SmithingTableEvent;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.SmithingInventory;
import cn.nukkit.inventory.transaction.InventoryTransaction;
import cn.nukkit.inventory.transaction.action.CreativeInventoryAction;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.inventory.transaction.action.SmithingItemAction;
import cn.nukkit.item.Item;
import java.util.List;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class SmithingTransaction
extends InventoryTransaction {
    private Item equipmentItem;
    private Item ingredientItem;
    private Item outputItem;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public SmithingTransaction(Player source, List<InventoryAction> actions) {
        super(source, actions);
    }

    @Override
    public void addAction(InventoryAction action) {
        CreativeInventoryAction creativeAction;
        super.addAction(action);
        if (action instanceof SmithingItemAction) {
            switch (((SmithingItemAction)action).getType()) {
                case 0: {
                    this.equipmentItem = action.getTargetItem();
                    break;
                }
                case 2: {
                    this.outputItem = action.getSourceItem();
                    break;
                }
                case 1: {
                    this.ingredientItem = action.getTargetItem();
                }
            }
        } else if (action instanceof CreativeInventoryAction && (creativeAction = (CreativeInventoryAction)action).getActionType() == 0 && creativeAction.getSourceItem().isNull() && !creativeAction.getTargetItem().isNull() && creativeAction.getTargetItem().getId() == 742) {
            this.ingredientItem = action.getTargetItem();
        }
    }

    @Override
    public boolean canExecute() {
        Inventory inventory = this.getSource().getWindowById(Player.SMITHING_WINDOW_ID);
        if (inventory == null) {
            return false;
        }
        SmithingInventory grindstoneInventory = (SmithingInventory)inventory;
        if (this.outputItem == null || this.outputItem.isNull() || (this.equipmentItem == null || this.equipmentItem.isNull()) && (this.ingredientItem == null || this.ingredientItem.isNull())) {
            return false;
        }
        Item air = Item.get(0);
        Item equipment = this.equipmentItem != null ? this.equipmentItem : air;
        Item ingredient = this.ingredientItem != null ? this.ingredientItem : air;
        return equipment.equals(grindstoneInventory.getEquipment(), true, true) && ingredient.equals(grindstoneInventory.getIngredient(), true, true) && this.outputItem.equals(grindstoneInventory.getResult(), true, true);
    }

    @Override
    public boolean execute() {
        if (this.hasExecuted() || !this.canExecute()) {
            this.source.removeAllWindows(false);
            this.sendInventories();
            return false;
        }
        SmithingInventory inventory = (SmithingInventory)this.getSource().getWindowById(Player.SMITHING_WINDOW_ID);
        Item air = Item.get(0);
        Item equipment = this.equipmentItem != null ? this.equipmentItem : air;
        Item ingredient = this.ingredientItem != null ? this.ingredientItem : air;
        SmithingTableEvent event = new SmithingTableEvent(inventory, equipment, this.outputItem, ingredient, this.source);
        this.source.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            this.source.removeAllWindows(false);
            this.sendInventories();
            return true;
        }
        for (InventoryAction action : this.actions) {
            if (action.execute(this.source)) {
                action.onExecuteSuccess(this.source);
                continue;
            }
            action.onExecuteFail(this.source);
        }
        if (!this.source.isCreative()) {
            this.source.sendAllInventories();
            this.source.getCursorInventory().sendContents(this.source);
        }
        return true;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getEquipmentItem() {
        return this.equipmentItem == null ? null : this.equipmentItem.clone();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getIngredientItem() {
        return this.ingredientItem == null ? null : this.ingredientItem.clone();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getOutputItem() {
        return this.outputItem == null ? null : this.outputItem.clone();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static boolean checkForItemPart(List<InventoryAction> actions) {
        return actions.stream().anyMatch(it -> it instanceof SmithingItemAction);
    }
}

