/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory.transaction.action;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAnvil;
import cn.nukkit.event.block.AnvilDamageEvent;
import cn.nukkit.inventory.AnvilInventory;
import cn.nukkit.inventory.transaction.CraftingTransaction;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.item.Item;
import cn.nukkit.level.Sound;
import cn.nukkit.math.Vector3;
import lombok.Generated;

public class DamageAnvilAction
extends InventoryAction {
    private final AnvilInventory anvil;
    private boolean shouldDamage;
    private CraftingTransaction transaction;

    public DamageAnvilAction(AnvilInventory anvil, boolean shouldDamage, CraftingTransaction transaction) {
        super(Item.get(0), Item.get(0));
        this.anvil = anvil;
        this.shouldDamage = shouldDamage;
        this.transaction = transaction;
    }

    @Override
    public boolean isValid(Player source) {
        return true;
    }

    @Override
    public boolean execute(Player source) {
        Block levelBlock = this.anvil.getHolder().getLevelBlock();
        if (!(levelBlock instanceof BlockAnvil)) {
            return false;
        }
        Block newState = levelBlock.clone();
        int damage = (newState.getDamage() >> 2 & 3) + 1;
        if (damage >= 3) {
            newState = Block.get(0, 0, newState, newState.layer);
        } else {
            newState.setDamage(newState.getDamage() & (Block.DATA_MASK ^ 0xC) | damage << 2);
        }
        AnvilDamageEvent ev = new AnvilDamageEvent(levelBlock, newState, source, this.transaction, AnvilDamageEvent.Cause.USE);
        ev.setCancelled(!this.shouldDamage);
        source.getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            levelBlock.getLevel().addSound(levelBlock, Sound.RANDOM_ANVIL_USE);
            return true;
        }
        if (newState.getId() == 0) {
            levelBlock.getLevel().addSound(levelBlock, Sound.RANDOM_ANVIL_BREAK);
        } else {
            levelBlock.getLevel().addSound(levelBlock, Sound.RANDOM_ANVIL_USE);
        }
        return levelBlock.getLevel().setBlock((Vector3)levelBlock, newState, true, true);
    }

    @Override
    public void onExecuteSuccess(Player source) {
    }

    @Override
    public void onExecuteFail(Player source) {
    }

    @Override
    @Generated
    public String toString() {
        return "DamageAnvilAction(super=" + super.toString() + ", anvil=" + this.anvil + ", shouldDamage=" + this.shouldDamage + ", transaction=" + this.transaction + ")";
    }
}

