/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.projectile.EntityArrow;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.event.entity.EntityShootBowEvent;
import cn.nukkit.event.entity.ProjectileLaunchEvent;
import cn.nukkit.inventory.BaseInventory;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemTool;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.level.Sound;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import java.util.Random;
import java.util.stream.Stream;

public class ItemBow
extends ItemTool {
    public ItemBow() {
        this((Integer)0, 1);
    }

    public ItemBow(Integer meta) {
        this(meta, 1);
    }

    public ItemBow(Integer meta, int count) {
        super(261, meta, count, "Bow");
    }

    @Override
    public int getMaxDurability() {
        return ItemTool.DURABILITY_BOW;
    }

    @Override
    public int getEnchantAbility() {
        return 1;
    }

    @Override
    public boolean onClickAir(Player player, Vector3 directionVector) {
        return player.isCreative() || Stream.of(player.getInventory(), player.getOffhandInventory()).anyMatch(inv -> inv.contains(Item.get(262)));
    }

    @Override
    @PowerNukkitDifference(info="Using new method to play sounds", since="1.4.0.0-PN")
    public boolean onRelease(Player player, int ticksUsed) {
        Enchantment flameEnchant;
        Item itemArrow = Item.get(262, 0, 1);
        BaseInventory inventory = player.getOffhandInventory();
        if (!inventory.contains(itemArrow) && !(inventory = player.getInventory()).contains(itemArrow) && (player.isAdventure() || player.isSurvival())) {
            player.getOffhandInventory().sendContents(player);
            inventory.sendContents(player);
            return false;
        }
        double damage = 2.0;
        Enchantment bowDamage = this.getEnchantment(19);
        if (bowDamage != null && bowDamage.getLevel() > 0) {
            damage += 0.25 * (double)(bowDamage.getLevel() + 1);
        }
        boolean flame = (flameEnchant = this.getEnchantment(21)) != null && flameEnchant.getLevel() > 0;
        CompoundTag nbt = new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", player.x)).add(new DoubleTag("", player.y + (double)player.getEyeHeight())).add(new DoubleTag("", player.z))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", -Math.sin(player.yaw / 180.0 * Math.PI) * Math.cos(player.pitch / 180.0 * Math.PI))).add(new DoubleTag("", -Math.sin(player.pitch / 180.0 * Math.PI))).add(new DoubleTag("", Math.cos(player.yaw / 180.0 * Math.PI) * Math.cos(player.pitch / 180.0 * Math.PI)))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", (float)(player.yaw > 180.0 ? 360 : 0) - (float)player.yaw)).add(new FloatTag("", (float)(-player.pitch)))).putShort("Fire", flame ? 2700 : 0).putDouble("damage", damage);
        double p = (double)ticksUsed / 20.0;
        double f = Math.min((p * p + p * 2.0) / 3.0, 1.0) * 2.0;
        EntityArrow arrow = (EntityArrow)Entity.createEntity("Arrow", player.chunk, nbt, player, f == 2.0);
        if (arrow == null) {
            return false;
        }
        EntityShootBowEvent entityShootBowEvent = new EntityShootBowEvent(player, this, arrow, f);
        if (f < 0.1 || ticksUsed < 3) {
            entityShootBowEvent.setCancelled();
        }
        Server.getInstance().getPluginManager().callEvent(entityShootBowEvent);
        if (entityShootBowEvent.isCancelled()) {
            entityShootBowEvent.getProjectile().kill();
            player.getInventory().sendContents(player);
            player.getOffhandInventory().sendContents(player);
        } else {
            EntityProjectile projectile;
            boolean infinity;
            entityShootBowEvent.getProjectile().setMotion(entityShootBowEvent.getProjectile().getMotion().multiply(entityShootBowEvent.getForce()));
            Enchantment infinityEnchant = this.getEnchantment(22);
            boolean bl = infinity = infinityEnchant != null && infinityEnchant.getLevel() > 0;
            if (infinity && (projectile = entityShootBowEvent.getProjectile()) instanceof EntityArrow) {
                ((EntityArrow)projectile).setPickupMode(2);
            }
            if (player.isAdventure() || player.isSurvival()) {
                Enchantment durability;
                if (!infinity) {
                    inventory.removeItem(itemArrow);
                }
                if (!(this.isUnbreakable() || (durability = this.getEnchantment(17)) != null && durability.getLevel() > 0 && 100 / (durability.getLevel() + 1) <= new Random().nextInt(100))) {
                    this.setDamage(this.getDamage() + 1);
                    if (this.getDamage() >= this.getMaxDurability()) {
                        player.getLevel().addSound(player, Sound.RANDOM_BREAK);
                        --this.count;
                    }
                    player.getInventory().setItemInHand(this);
                }
            }
            if (entityShootBowEvent.getProjectile() != null) {
                ProjectileLaunchEvent projectev = new ProjectileLaunchEvent(entityShootBowEvent.getProjectile());
                Server.getInstance().getPluginManager().callEvent(projectev);
                if (projectev.isCancelled()) {
                    entityShootBowEvent.getProjectile().kill();
                } else {
                    entityShootBowEvent.getProjectile().spawnToAll();
                    player.getLevel().addSound(player, Sound.RANDOM_BOW);
                }
            }
        }
        return true;
    }
}

