/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.math;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockSignPost;
import cn.nukkit.math.BlockFace;
import javax.annotation.Nonnull;
import lombok.Generated;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public enum CompassRoseDirection {
    NORTH(0, -1, BlockFace.NORTH, 0.0),
    EAST(1, 0, BlockFace.EAST, 90.0),
    SOUTH(0, 1, BlockFace.SOUTH, 180.0),
    WEST(-1, 0, BlockFace.WEST, 270.0),
    NORTH_EAST(NORTH, EAST, BlockFace.NORTH, 45.0),
    NORTH_WEST(NORTH, WEST, BlockFace.WEST, 315.0),
    SOUTH_EAST(SOUTH, EAST, BlockFace.EAST, 135.0),
    SOUTH_WEST(SOUTH, WEST, BlockFace.SOUTH, 225.0),
    WEST_NORTH_WEST(WEST, NORTH_WEST, BlockFace.WEST, 292.5),
    NORTH_NORTH_WEST(NORTH, NORTH_WEST, BlockFace.NORTH, 337.5),
    NORTH_NORTH_EAST(NORTH, NORTH_EAST, BlockFace.NORTH, 22.5),
    EAST_NORTH_EAST(EAST, NORTH_EAST, BlockFace.EAST, 67.5),
    EAST_SOUTH_EAST(EAST, SOUTH_EAST, BlockFace.EAST, 112.5),
    SOUTH_SOUTH_EAST(SOUTH, SOUTH_EAST, BlockFace.SOUTH, 157.5),
    SOUTH_SOUTH_WEST(SOUTH, SOUTH_WEST, BlockFace.SOUTH, 202.5),
    WEST_SOUTH_WEST(WEST, SOUTH_WEST, BlockFace.WEST, 247.5);

    private final int modX;
    private final int modZ;
    private final BlockFace closestBlockFace;
    private final float yaw;

    private CompassRoseDirection(int modX, int modZ, BlockFace closestBlockFace, double yaw) {
        this.modX = modX;
        this.modZ = modZ;
        this.closestBlockFace = closestBlockFace;
        this.yaw = (float)yaw;
    }

    private CompassRoseDirection(CompassRoseDirection face1, CompassRoseDirection face2, BlockFace closestBlockFace, double yaw) {
        this.modX = face1.getModX() + face2.getModX();
        this.modZ = face1.getModZ() + face2.getModZ();
        this.closestBlockFace = closestBlockFace;
        this.yaw = (float)yaw;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getModX() {
        return this.modX;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getModZ() {
        return this.modZ;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockFace getClosestBlockFace() {
        return this.closestBlockFace;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static CompassRoseDirection getClosestFromYaw(double yaw, @Nonnull Precision precision) {
        return BlockSignPost.GROUND_SIGN_DIRECTION.getValueForMeta((int)Math.round((double)Math.round((yaw + 180.0) * (double)precision.directions / 360.0) * (16.0 / (double)precision.directions)) & 0xF);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static CompassRoseDirection getClosestFromYaw(double yaw) {
        return CompassRoseDirection.getClosestFromYaw(yaw, Precision.SECONDARY_INTER_CARDINAL);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public CompassRoseDirection getOppositeFace() {
        switch (this) {
            case NORTH: {
                return SOUTH;
            }
            case SOUTH: {
                return NORTH;
            }
            case EAST: {
                return WEST;
            }
            case WEST: {
                return EAST;
            }
            case NORTH_EAST: {
                return SOUTH_WEST;
            }
            case NORTH_WEST: {
                return SOUTH_EAST;
            }
            case SOUTH_EAST: {
                return NORTH_WEST;
            }
            case SOUTH_WEST: {
                return NORTH_EAST;
            }
            case WEST_NORTH_WEST: {
                return EAST_SOUTH_EAST;
            }
            case NORTH_NORTH_WEST: {
                return SOUTH_SOUTH_EAST;
            }
            case NORTH_NORTH_EAST: {
                return SOUTH_SOUTH_WEST;
            }
            case EAST_NORTH_EAST: {
                return WEST_SOUTH_WEST;
            }
            case EAST_SOUTH_EAST: {
                return WEST_NORTH_WEST;
            }
            case SOUTH_SOUTH_EAST: {
                return NORTH_NORTH_WEST;
            }
            case SOUTH_SOUTH_WEST: {
                return NORTH_NORTH_EAST;
            }
            case WEST_SOUTH_WEST: {
                return EAST_NORTH_EAST;
            }
        }
        throw new IncompatibleClassChangeError("New values was added to the enum");
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public float getYaw() {
        return this.yaw;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static enum Precision {
        CARDINAL(4),
        PRIMARY_INTER_CARDINAL(8),
        SECONDARY_INTER_CARDINAL(16);

        protected final int directions;

        @Generated
        private Precision(int directions) {
            this.directions = directions;
        }
    }
}

