/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.metrics;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.utils.MainLogger;
import io.netty.util.internal.EmptyArrays;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import lombok.Generated;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Since(value="1.4.0.0-PN")
public class Metrics {
    @Generated
    private static final Logger log = LogManager.getLogger(Metrics.class);
    @Since(value="1.4.0.0-PN")
    public static final int B_STATS_VERSION = 1;
    private static final String VALUES = "values";
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final String URL = "https://bStats.org/submitData/server-implementation";
    private final List<CustomChart> charts = new ArrayList<CustomChart>();
    private final String name;
    private final String serverUUID;
    private final boolean logFailedRequests;

    @Since(value="1.4.0.0-PN")
    public Metrics(String name, String serverUUID, boolean logFailedRequests, MainLogger logger) {
        this(name, serverUUID, logFailedRequests);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Metrics(String name, String serverUUID, boolean logFailedRequests) {
        this.name = name;
        this.serverUUID = serverUUID;
        this.logFailedRequests = logFailedRequests;
        this.startSubmitting();
    }

    @Since(value="1.4.0.0-PN")
    public void addCustomChart(CustomChart chart) {
        if (chart == null) {
            throw new IllegalArgumentException("Chart cannot be null!");
        }
        this.charts.add(chart);
    }

    private void startSubmitting() {
        Runnable submitTask = this::submitData;
        long initialDelay = (long)(60000.0 * (3.0 + Math.random() * 3.0));
        long secondDelay = (long)(60000.0 * (Math.random() * 30.0));
        this.scheduler.schedule(submitTask, initialDelay, TimeUnit.MILLISECONDS);
        this.scheduler.scheduleAtFixedRate(submitTask, initialDelay + secondDelay, 1800000L, TimeUnit.MILLISECONDS);
    }

    private JSONObject getPluginData() {
        JSONObject data = new JSONObject();
        data.put((Object)"pluginName", (Object)this.name);
        JSONArray customCharts = new JSONArray();
        for (CustomChart customChart : this.charts) {
            JSONObject chart = customChart.getRequestJsonObject();
            if (chart == null) continue;
            customCharts.add((Object)chart);
        }
        data.put((Object)"customCharts", (Object)customCharts);
        return data;
    }

    private JSONObject getServerData() {
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        String osVersion = System.getProperty("os.version");
        int coreCount = Runtime.getRuntime().availableProcessors();
        JSONObject data = new JSONObject();
        data.put((Object)"serverUUID", (Object)this.serverUUID);
        data.put((Object)"osName", (Object)osName);
        data.put((Object)"osArch", (Object)osArch);
        data.put((Object)"osVersion", (Object)osVersion);
        data.put((Object)"coreCount", (Object)coreCount);
        return data;
    }

    private void submitData() {
        block2: {
            JSONObject data = this.getServerData();
            JSONArray pluginData = new JSONArray();
            pluginData.add((Object)this.getPluginData());
            data.put((Object)"plugins", (Object)pluginData);
            try {
                Metrics.sendData(data);
            }
            catch (Exception e) {
                if (!this.logFailedRequests) break block2;
                log.warn("Could not submit stats of {}", (Object)this.name, (Object)e);
            }
        }
    }

    private static void sendData(JSONObject data) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null!");
        }
        HttpsURLConnection connection = (HttpsURLConnection)new URL(URL).openConnection();
        byte[] compressedData = Metrics.compress(data.toString());
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Connection", "close");
        connection.addRequestProperty("Content-Encoding", "gzip");
        connection.addRequestProperty("Content-Length", String.valueOf(compressedData.length));
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "MC-Server/1");
        connection.setDoOutput(true);
        DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
        outputStream.write(compressedData);
        outputStream.flush();
        outputStream.close();
        connection.getInputStream().close();
    }

    private static byte[] compress(String str) throws IOException {
        if (str == null) {
            return EmptyArrays.EMPTY_BYTES;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(outputStream);
        gzip.write(str.getBytes(StandardCharsets.UTF_8));
        gzip.close();
        return outputStream.toByteArray();
    }

    private static JSONObject createAdvancedChartData(Callable<Map<String, Integer>> callable) throws Exception {
        JSONObject data = new JSONObject();
        JSONObject values = new JSONObject();
        Map<String, Integer> map = callable.call();
        if (map == null || map.isEmpty()) {
            return null;
        }
        boolean allSkipped = true;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            if (entry.getValue() == 0) continue;
            allSkipped = false;
            values.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        if (allSkipped) {
            return null;
        }
        data.put((Object)VALUES, (Object)values);
        return data;
    }

    @Since(value="1.4.0.0-PN")
    public static class AdvancedBarChart
    extends CustomChart {
        private final Callable<Map<String, int[]>> callable;

        @Since(value="1.4.0.0-PN")
        public AdvancedBarChart(String chartId, Callable<Map<String, int[]>> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected JSONObject getChartData() throws Exception {
            JSONObject data = new JSONObject();
            JSONObject values = new JSONObject();
            Map<String, int[]> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean allSkipped = true;
            for (Map.Entry<String, int[]> entry : map.entrySet()) {
                if (entry.getValue().length == 0) continue;
                allSkipped = false;
                JSONArray categoryValues = new JSONArray();
                for (int categoryValue : entry.getValue()) {
                    categoryValues.add((Object)categoryValue);
                }
                values.put((Object)entry.getKey(), (Object)categoryValues);
            }
            if (allSkipped) {
                return null;
            }
            data.put((Object)Metrics.VALUES, (Object)values);
            return data;
        }
    }

    @Since(value="1.4.0.0-PN")
    public static class SimpleBarChart
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        @Since(value="1.4.0.0-PN")
        public SimpleBarChart(String chartId, Callable<Map<String, Integer>> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected JSONObject getChartData() throws Exception {
            JSONObject data = new JSONObject();
            JSONObject values = new JSONObject();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                JSONArray categoryValues = new JSONArray();
                categoryValues.add((Object)entry.getValue());
                values.put((Object)entry.getKey(), (Object)categoryValues);
            }
            data.put((Object)Metrics.VALUES, (Object)values);
            return data;
        }
    }

    @Since(value="1.4.0.0-PN")
    public static class MultiLineChart
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        @Since(value="1.4.0.0-PN")
        public MultiLineChart(String chartId, Callable<Map<String, Integer>> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected JSONObject getChartData() throws Exception {
            return Metrics.createAdvancedChartData(this.callable);
        }
    }

    @Since(value="1.4.0.0-PN")
    public static class SingleLineChart
    extends CustomChart {
        private final Callable<Integer> callable;

        @Since(value="1.4.0.0-PN")
        public SingleLineChart(String chartId, Callable<Integer> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected JSONObject getChartData() throws Exception {
            JSONObject data = new JSONObject();
            int value = this.callable.call();
            if (value == 0) {
                return null;
            }
            data.put((Object)"value", (Object)value);
            return data;
        }
    }

    @Since(value="1.4.0.0-PN")
    public static class DrilldownPie
    extends CustomChart {
        private final Callable<Map<String, Map<String, Integer>>> callable;

        @Since(value="1.4.0.0-PN")
        public DrilldownPie(String chartId, Callable<Map<String, Map<String, Integer>>> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        public JSONObject getChartData() throws Exception {
            JSONObject data = new JSONObject();
            JSONObject values = new JSONObject();
            Map<String, Map<String, Integer>> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean reallyAllSkipped = true;
            for (Map.Entry<String, Map<String, Integer>> entryValues : map.entrySet()) {
                JSONObject value = new JSONObject();
                boolean allSkipped = true;
                for (Map.Entry<String, Integer> valueEntry : map.get(entryValues.getKey()).entrySet()) {
                    value.put((Object)valueEntry.getKey(), (Object)valueEntry.getValue());
                    allSkipped = false;
                }
                if (allSkipped) continue;
                reallyAllSkipped = false;
                values.put((Object)entryValues.getKey(), (Object)value);
            }
            if (reallyAllSkipped) {
                return null;
            }
            data.put((Object)Metrics.VALUES, (Object)values);
            return data;
        }
    }

    @Since(value="1.4.0.0-PN")
    public static class AdvancedPie
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        @Since(value="1.4.0.0-PN")
        public AdvancedPie(String chartId, Callable<Map<String, Integer>> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected JSONObject getChartData() throws Exception {
            return Metrics.createAdvancedChartData(this.callable);
        }
    }

    @Since(value="1.4.0.0-PN")
    public static class SimplePie
    extends CustomChart {
        private final Callable<String> callable;

        @Since(value="1.4.0.0-PN")
        public SimplePie(String chartId, Callable<String> callable) {
            super(chartId);
            this.callable = callable;
        }

        @Override
        protected JSONObject getChartData() throws Exception {
            JSONObject data = new JSONObject();
            String value = this.callable.call();
            if (value == null || value.isEmpty()) {
                return null;
            }
            data.put((Object)"value", (Object)value);
            return data;
        }
    }

    @Since(value="1.4.0.0-PN")
    public static abstract class CustomChart {
        final String chartId;

        CustomChart(String chartId) {
            if (chartId == null || chartId.isEmpty()) {
                throw new IllegalArgumentException("ChartId cannot be null or empty!");
            }
            this.chartId = chartId;
        }

        private JSONObject getRequestJsonObject() {
            JSONObject chart = new JSONObject();
            chart.put((Object)"chartId", (Object)this.chartId);
            try {
                JSONObject data = this.getChartData();
                if (data == null) {
                    return null;
                }
                chart.put((Object)"data", (Object)data);
            }
            catch (Exception t) {
                return null;
            }
            return chart;
        }

        @Since(value="1.4.0.0-PN")
        protected abstract JSONObject getChartData() throws Exception;
    }
}

