/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.command.data.CommandData;
import cn.nukkit.command.data.CommandDataVersions;
import cn.nukkit.command.data.CommandOverload;
import cn.nukkit.command.data.CommandParameter;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.ObjIntConsumer;
import lombok.Generated;

@PowerNukkitDifference(since="1.4.0.0-PN", info="Made the arg type constants dynamic because they can change in Minecraft updates")
public class AvailableCommandsPacket
extends DataPacket {
    public static final byte NETWORK_ID = 76;
    private static final ObjIntConsumer<BinaryStream> WRITE_BYTE = (s, v) -> s.putByte((byte)v);
    private static final ObjIntConsumer<BinaryStream> WRITE_SHORT = BinaryStream::putLShort;
    private static final ObjIntConsumer<BinaryStream> WRITE_INT = BinaryStream::putLInt;
    public static final int ARG_FLAG_VALID = 0x100000;
    public static final int ARG_FLAG_ENUM = 0x200000;
    public static final int ARG_FLAG_POSTFIX = 0x1000000;
    public static final int ARG_FLAG_SOFT_ENUM = 0x4000000;
    public static final int ARG_TYPE_INT = Utils.dynamic(1);
    public static final int ARG_TYPE_FLOAT = Utils.dynamic(3);
    public static final int ARG_TYPE_VALUE = Utils.dynamic(4);
    public static final int ARG_TYPE_WILDCARD_INT = Utils.dynamic(5);
    public static final int ARG_TYPE_OPERATOR = Utils.dynamic(6);
    public static final int ARG_TYPE_TARGET = Utils.dynamic(7);
    public static final int ARG_TYPE_WILDCARD_TARGET = Utils.dynamic(8);
    public static final int ARG_TYPE_FILE_PATH = Utils.dynamic(16);
    public static final int ARG_TYPE_STRING = Utils.dynamic(32);
    public static final int ARG_TYPE_BLOCK_POSITION = Utils.dynamic(40);
    public static final int ARG_TYPE_POSITION = Utils.dynamic(41);
    public static final int ARG_TYPE_MESSAGE = Utils.dynamic(44);
    public static final int ARG_TYPE_RAWTEXT = Utils.dynamic(46);
    public static final int ARG_TYPE_JSON = Utils.dynamic(50);
    public static final int ARG_TYPE_COMMAND = Utils.dynamic(63);
    public Map<String, CommandDataVersions> commands;
    public final Map<String, List<String>> softEnums = new HashMap<String, List<String>>();

    @Override
    public byte pid() {
        return 76;
    }

    @Override
    public void decode() {
    }

    @Override
    public void encode() {
        this.reset();
        LinkedHashSet enumValuesSet = new LinkedHashSet();
        LinkedHashSet postFixesSet = new LinkedHashSet();
        LinkedHashSet enumsSet = new LinkedHashSet();
        this.commands.forEach((name, data) -> {
            CommandData cmdData = data.versions.get(0);
            if (cmdData.aliases != null) {
                enumsSet.add(cmdData.aliases);
                enumValuesSet.addAll(cmdData.aliases.getValues());
            }
            for (CommandOverload overload : cmdData.overloads.values()) {
                for (CommandParameter parameter : overload.input.parameters) {
                    if (parameter.enumData != null) {
                        enumsSet.add(parameter.enumData);
                        enumValuesSet.addAll(parameter.enumData.getValues());
                    }
                    if (parameter.postFix == null) continue;
                    postFixesSet.add(parameter.postFix);
                }
            }
        });
        ArrayList enumValues = new ArrayList(enumValuesSet);
        ArrayList enums = new ArrayList(enumsSet);
        ArrayList postFixes = new ArrayList(postFixesSet);
        this.putUnsignedVarInt(enumValues.size());
        enumValues.forEach(this::putString);
        this.putUnsignedVarInt(postFixes.size());
        postFixes.forEach(this::putString);
        ObjIntConsumer<BinaryStream> indexWriter = enumValues.size() < 256 ? WRITE_BYTE : (enumValues.size() < 65536 ? WRITE_SHORT : WRITE_INT);
        this.putUnsignedVarInt(enums.size());
        enums.forEach(cmdEnum -> {
            this.putString(cmdEnum.getName());
            List<String> values = cmdEnum.getValues();
            this.putUnsignedVarInt(values.size());
            for (String val : values) {
                int i = enumValues.indexOf(val);
                if (i < 0) {
                    throw new IllegalStateException("Enum value '" + val + "' not found");
                }
                indexWriter.accept(this, i);
            }
        });
        this.putUnsignedVarInt(this.commands.size());
        this.commands.forEach((name, cmdData) -> {
            CommandData data = cmdData.versions.get(0);
            this.putString((String)name);
            this.putString(data.description);
            this.putLShort(data.flags);
            this.putByte((byte)data.permission);
            this.putLInt(data.aliases == null ? -1 : enums.indexOf(data.aliases));
            this.putUnsignedVarInt(data.overloads.size());
            for (CommandOverload overload : data.overloads.values()) {
                this.putUnsignedVarInt(overload.input.parameters.length);
                for (CommandParameter parameter : overload.input.parameters) {
                    this.putString(parameter.name);
                    int type = 0;
                    if (parameter.postFix != null) {
                        int i = postFixes.indexOf(parameter.postFix);
                        if (i < 0) {
                            throw new IllegalStateException("Postfix '" + parameter.postFix + "' isn't in postfix array");
                        }
                        type = 0x1000000 | i;
                    } else {
                        type |= 0x100000;
                        type = parameter.enumData != null ? (type |= 0x200000 | enums.indexOf(parameter.enumData)) : (type |= parameter.type.getId());
                    }
                    this.putLInt(type);
                    this.putBoolean(parameter.optional);
                    this.putByte(parameter.options);
                }
            }
        });
        this.putUnsignedVarInt(this.softEnums.size());
        this.softEnums.forEach((name, values) -> {
            this.putString((String)name);
            this.putUnsignedVarInt(values.size());
            values.forEach(this::putString);
        });
        this.putUnsignedVarInt(0L);
    }

    @Generated
    public String toString() {
        return "AvailableCommandsPacket(commands=" + this.commands + ", softEnums=" + this.softEnums + ")";
    }
}

