/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.network.protocol.DataPacket;
import lombok.Generated;

public class MoveEntityDeltaPacket
extends DataPacket {
    public static final byte NETWORK_ID = 111;
    public static final int FLAG_HAS_X = 1;
    public static final int FLAG_HAS_Y = 2;
    public static final int FLAG_HAS_Z = 4;
    public static final int FLAG_HAS_YAW = 8;
    public static final int FLAG_HAS_HEAD_YAW = 16;
    public static final int FLAG_HAS_PITCH = 32;
    public int flags = 0;
    @Since(value="1.4.0.0-PN")
    public float x = 0.0f;
    @Since(value="1.4.0.0-PN")
    public float y = 0.0f;
    @Since(value="1.4.0.0-PN")
    public float z = 0.0f;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Changed to float", replaceWith="x")
    @PowerNukkitOnly(value="Re-added for backward-compatibility")
    public int xDelta = 0;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Changed to float", replaceWith="y")
    @PowerNukkitOnly(value="Re-added for backward-compatibility")
    public int yDelta = 0;
    @Deprecated
    @PowerNukkitOnly(value="Re-added for backward-compatibility")
    @DeprecationDetails(since="1.4.0.0-PN", reason="Changed to float", replaceWith="z")
    public int zDelta = 0;
    private int xDecoded;
    private int yDecoded;
    private int zDecoded;
    public double yawDelta = 0.0;
    public double headYawDelta = 0.0;
    public double pitchDelta = 0.0;

    @Override
    public byte pid() {
        return 111;
    }

    @Override
    public void decode() {
        this.flags = this.getByte();
        this.x = this.getCoordinate(1);
        this.y = this.getCoordinate(2);
        this.z = this.getCoordinate(4);
        this.yawDelta = this.getRotation(8);
        this.headYawDelta = this.getRotation(16);
        this.pitchDelta = this.getRotation(32);
        this.xDelta = this.xDecoded = NukkitMath.floorFloat(this.x);
        this.yDelta = this.yDecoded = NukkitMath.floorFloat(this.y);
        this.zDelta = this.zDecoded = NukkitMath.floorFloat(this.z);
    }

    @Override
    public void encode() {
        this.putByte((byte)this.flags);
        float x = this.x;
        float y = this.y;
        float z = this.z;
        if (this.xDelta != this.xDecoded || this.yDelta != this.yDecoded || this.zDelta != this.zDecoded) {
            x = this.xDelta;
            y = this.yDelta;
            z = this.zDelta;
        }
        this.putCoordinate(1, x);
        this.putCoordinate(2, y);
        this.putCoordinate(4, z);
        this.putRotation(8, this.yawDelta);
        this.putRotation(16, this.headYawDelta);
        this.putRotation(32, this.pitchDelta);
    }

    private float getCoordinate(int flag) {
        if ((this.flags & flag) != 0) {
            return this.getLFloat();
        }
        return 0.0f;
    }

    private double getRotation(int flag) {
        if ((this.flags & flag) != 0) {
            return (double)this.getByte() * 1.40625;
        }
        return 0.0;
    }

    private void putCoordinate(int flag, float value) {
        if ((this.flags & flag) != 0) {
            this.putLFloat(value);
        }
    }

    private void putRotation(int flag, double value) {
        if ((this.flags & flag) != 0) {
            this.putByte((byte)(value / 1.40625));
        }
    }

    @Generated
    public String toString() {
        return "MoveEntityDeltaPacket(flags=" + this.flags + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", xDelta=" + this.xDelta + ", yDelta=" + this.yDelta + ", zDelta=" + this.zDelta + ", xDecoded=" + this.xDecoded + ", yDecoded=" + this.yDecoded + ", zDecoded=" + this.zDecoded + ", yawDelta=" + this.yawDelta + ", headYawDelta=" + this.headYawDelta + ", pitchDelta=" + this.pitchDelta + ")";
    }
}

