/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.network.protocol.DataPacket;
import javax.annotation.Nonnull;

@PowerNukkitOnly
@Since(value="1.5.2.0-PN")
public class NPCDialoguePacket
extends DataPacket {
    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public static final byte NETWORK_ID = -87;
    private static final NPCDialogAction[] ACTIONS = NPCDialogAction.values();
    private long runtimeEntityId;
    private NPCDialogAction action = NPCDialogAction.OPEN;
    private String dialogue = "";
    private String sceneName = "";
    private String npcName = "";
    private String actionJson = "";

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public NPCDialoguePacket() {
    }

    @Override
    public byte pid() {
        return -87;
    }

    @Override
    public void decode() {
        this.runtimeEntityId = this.getUnsignedVarLong();
        this.action = ACTIONS[this.getVarInt()];
        this.dialogue = this.getString();
        this.sceneName = this.getString();
        this.npcName = this.getString();
        this.actionJson = this.getString();
    }

    @Override
    public void encode() {
        this.reset();
        this.putUnsignedVarLong(this.runtimeEntityId);
        this.putVarInt(this.action.ordinal());
        this.putString(this.dialogue);
        this.putString(this.sceneName);
        this.putString(this.npcName);
        this.putString(this.actionJson);
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public long getRuntimeEntityId() {
        return this.runtimeEntityId;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setRuntimeEntityId(long runtimeEntityId) {
        this.runtimeEntityId = runtimeEntityId;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public NPCDialogAction getAction() {
        return this.action;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setAction(@Nonnull NPCDialogAction action) {
        this.action = action;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public String getDialogue() {
        return this.dialogue;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setDialogue(@Nonnull String dialogue) {
        this.dialogue = dialogue;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public String getSceneName() {
        return this.sceneName;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setSceneName(@Nonnull String sceneName) {
        this.sceneName = sceneName;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public String getNpcName() {
        return this.npcName;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setNpcName(@Nonnull String npcName) {
        this.npcName = npcName;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public String getActionJson() {
        return this.actionJson;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setActionJson(@Nonnull String actionJson) {
        this.actionJson = actionJson;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public static enum NPCDialogAction {
        OPEN,
        CLOSE;

    }
}

