/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.permission;

import cn.nukkit.permission.BanEntry;
import cn.nukkit.utils.Utils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BanList {
    @Generated
    private static final Logger log = LogManager.getLogger(BanList.class);
    private LinkedHashMap<String, BanEntry> list = new LinkedHashMap();
    private final String file;
    private boolean enable = true;

    public BanList(String file) {
        this.file = file;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public LinkedHashMap<String, BanEntry> getEntires() {
        this.removeExpired();
        return this.list;
    }

    public boolean isBanned(String name) {
        if (!this.isEnable() || name == null) {
            return false;
        }
        this.removeExpired();
        return this.list.containsKey(name.toLowerCase());
    }

    public void add(BanEntry entry) {
        this.list.put(entry.getName(), entry);
        this.save();
    }

    public BanEntry addBan(String target) {
        return this.addBan(target, null);
    }

    public BanEntry addBan(String target, String reason) {
        return this.addBan(target, reason, null);
    }

    public BanEntry addBan(String target, String reason, Date expireDate) {
        return this.addBan(target, reason, expireDate, null);
    }

    public BanEntry addBan(String target, String reason, Date expireDate, String source) {
        BanEntry entry = new BanEntry(target);
        entry.setSource(source != null ? source : entry.getSource());
        entry.setExpirationDate(expireDate);
        entry.setReason(reason != null ? reason : entry.getReason());
        this.add(entry);
        return entry;
    }

    public void remove(String name) {
        if (this.list.containsKey(name = name.toLowerCase())) {
            this.list.remove(name);
            this.save();
        }
    }

    public void removeExpired() {
        for (String name : new ArrayList<String>(this.list.keySet())) {
            BanEntry entry = this.list.get(name);
            if (!entry.hasExpired()) continue;
            this.list.remove(name);
        }
    }

    public void load() {
        this.list = new LinkedHashMap();
        File file = new File(this.file);
        try {
            if (!file.exists()) {
                file.createNewFile();
                this.save();
            } else {
                LinkedList list = (LinkedList)new Gson().fromJson(Utils.readFile(this.file), new TypeToken<LinkedList<TreeMap<String, String>>>(){}.getType());
                for (TreeMap map : list) {
                    BanEntry entry = BanEntry.fromMap(map);
                    this.list.put(entry.getName(), entry);
                }
            }
        }
        catch (IOException e) {
            log.error("Could not load ban list: ", (Throwable)e);
        }
    }

    public void save() {
        this.removeExpired();
        try {
            File file = new File(this.file);
            if (!file.exists()) {
                file.createNewFile();
            }
            LinkedList<LinkedHashMap<String, String>> list = new LinkedList<LinkedHashMap<String, String>>();
            for (BanEntry entry : this.list.values()) {
                list.add(entry.getMap());
            }
            Utils.writeFile(this.file, (InputStream)new ByteArrayInputStream(new GsonBuilder().setPrettyPrinting().create().toJson(list).getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            log.error("Could not save ban list ", (Throwable)e);
        }
    }
}

