/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.potion;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.EntityRegainHealthEvent;
import cn.nukkit.network.protocol.MobEffectPacket;
import cn.nukkit.potion.InstantEffect;
import cn.nukkit.utils.ServerException;

public class Effect
implements Cloneable {
    public static final int SPEED = 1;
    public static final int SLOWNESS = 2;
    public static final int HASTE = 3;
    public static final int SWIFTNESS = 3;
    public static final int FATIGUE = 4;
    public static final int MINING_FATIGUE = 4;
    public static final int STRENGTH = 5;
    @Since(value="1.4.0.0-PN")
    public static final int INSTANT_HEALTH = 6;
    @Deprecated
    @DeprecationDetails(by="PowerNukkit", since="1.4.0.0-PN", reason="Was renamed to INSTANT_HEALTH in game, can be removed anytime by Cloudburst Nukkit", replaceWith="INSTANT_HEALTH")
    public static final int HEALING = 6;
    @Since(value="1.4.0.0-PN")
    public static final int INSTANT_DAMAGE = 7;
    @Deprecated
    @DeprecationDetails(by="PowerNukkit", since="1.4.0.0-PN", reason="Was renamed to INSTANT_DAMAGE in game, can be removed anytime by Cloudburst Nukkit", replaceWith="INSTANT_DAMAGE")
    public static final int HARMING = 7;
    @Since(value="1.4.0.0-PN")
    public static final int JUMP_BOOST = 8;
    @Deprecated
    @DeprecationDetails(by="PowerNukkit", since="1.4.0.0-PN", reason="Was renamed to JUMP_BOOST in game, can be removed anytime by Cloudburst Nukkit", replaceWith="JUMP_BOOST")
    public static final int JUMP = 8;
    public static final int NAUSEA = 9;
    @Deprecated
    @DeprecationDetails(by="PowerNukkit", since="1.4.0.0-PN", reason="Was renamed to NAUSEA in game, can be removed anytime by Cloudburst Nukkit", replaceWith="NAUSEA")
    public static final int CONFUSION = 9;
    public static final int REGENERATION = 10;
    @Since(value="1.4.0.0-PN")
    public static final int RESISTANCE = 11;
    @Deprecated
    @DeprecationDetails(by="PowerNukkit", since="1.4.0.0-PN", reason="Was renamed to JUMP_BOOST in game, can be removed anytime by Cloudburst Nukkit", replaceWith="JUMP_BOOST")
    public static final int DAMAGE_RESISTANCE = 11;
    public static final int FIRE_RESISTANCE = 12;
    public static final int WATER_BREATHING = 13;
    public static final int INVISIBILITY = 14;
    public static final int BLINDNESS = 15;
    public static final int NIGHT_VISION = 16;
    public static final int HUNGER = 17;
    public static final int WEAKNESS = 18;
    public static final int POISON = 19;
    public static final int WITHER = 20;
    public static final int HEALTH_BOOST = 21;
    public static final int ABSORPTION = 22;
    public static final int SATURATION = 23;
    public static final int LEVITATION = 24;
    public static final int FATAL_POISON = 25;
    public static final int CONDUIT_POWER = 26;
    @Deprecated
    @DeprecationDetails(by="PowerNukkit and removed by Cloudburst", since="TBD", reason="Typo", replaceWith="CONDUIT_POWER")
    @PowerNukkitOnly(value="Was removed from Cloudburst Nukkit, kept on PowerNukkit for backward compatibility")
    public static final int COUNDIT_POWER = 26;
    public static final int SLOW_FALLING = 27;
    @Since(value="1.4.0.0-PN")
    public static final int BAD_OMEN = 28;
    @Since(value="1.4.0.0-PN")
    public static final int VILLAGE_HERO = 29;
    protected static Effect[] effects;
    protected final int id;
    protected final String name;
    protected int duration;
    protected int amplifier = 0;
    protected int color;
    protected boolean show = true;
    protected boolean ambient = false;
    protected final boolean bad;

    public static void init() {
        effects = new Effect[256];
        Effect.effects[1] = new Effect(1, "%potion.moveSpeed", 124, 175, 198);
        Effect.effects[2] = new Effect(2, "%potion.moveSlowdown", 90, 108, 129, true);
        Effect.effects[3] = new Effect(3, "%potion.digSpeed", 217, 192, 67);
        Effect.effects[4] = new Effect(4, "%potion.digSlowDown", 74, 66, 23, true);
        Effect.effects[5] = new Effect(5, "%potion.damageBoost", 147, 36, 35);
        Effect.effects[6] = new InstantEffect(6, "%potion.heal", 248, 36, 35);
        Effect.effects[7] = new InstantEffect(7, "%potion.harm", 67, 10, 9, true);
        Effect.effects[8] = new Effect(8, "%potion.jump", 34, 255, 76);
        Effect.effects[9] = new Effect(9, "%potion.confusion", 85, 29, 74, true);
        Effect.effects[10] = new Effect(10, "%potion.regeneration", 205, 92, 171);
        Effect.effects[11] = new Effect(11, "%potion.resistance", 153, 69, 58);
        Effect.effects[12] = new Effect(12, "%potion.fireResistance", 228, 154, 58);
        Effect.effects[13] = new Effect(13, "%potion.waterBreathing", 46, 82, 153);
        Effect.effects[14] = new Effect(14, "%potion.invisibility", 127, 131, 146);
        Effect.effects[15] = new Effect(15, "%potion.blindness", 191, 192, 192);
        Effect.effects[16] = new Effect(16, "%potion.nightVision", 0, 0, 139);
        Effect.effects[17] = new Effect(17, "%potion.hunger", 46, 139, 87);
        Effect.effects[18] = new Effect(18, "%potion.weakness", 72, 77, 72, true);
        Effect.effects[19] = new Effect(19, "%potion.poison", 78, 147, 49, true);
        Effect.effects[20] = new Effect(20, "%potion.wither", 53, 42, 39, true);
        Effect.effects[21] = new Effect(21, "%potion.healthBoost", 248, 125, 35);
        Effect.effects[22] = new Effect(22, "%potion.absorption", 36, 107, 251);
        Effect.effects[23] = new Effect(23, "%potion.saturation", 255, 0, 255);
        Effect.effects[24] = new Effect(24, "%potion.levitation", 206, 255, 255, true);
        Effect.effects[25] = new Effect(25, "%potion.poison", 78, 147, 49, true);
        Effect.effects[26] = new Effect(26, "%potion.conduitPower", 29, 194, 209);
        Effect.effects[27] = new Effect(27, "%potion.slowFalling", 206, 255, 255);
        Effect.effects[28] = new Effect(28, "%effect.badOmen", 11, 97, 56, true);
        Effect.effects[29] = new Effect(29, "%effect.villageHero", 68, 255, 68).setVisible(false);
    }

    public static Effect getEffect(int id) {
        if (id >= 0 && id < effects.length && effects[id] != null) {
            return effects[id].clone();
        }
        throw new ServerException("Effect id: " + id + " not found");
    }

    public static Effect getEffectByName(String name) {
        name = name.trim().replace(' ', '_').replace("minecraft:", "");
        try {
            int id = Effect.class.getField(name.toUpperCase()).getInt(null);
            return Effect.getEffect(id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Effect(int id, String name, int r, int g, int b) {
        this(id, name, r, g, b, false);
    }

    public Effect(int id, String name, int r, int g, int b, boolean isBad) {
        this.id = id;
        this.name = name;
        this.bad = isBad;
        this.setColor(r, g, b);
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public Effect setDuration(int ticks) {
        this.duration = ticks;
        return this;
    }

    public int getDuration() {
        return this.duration;
    }

    @PowerNukkitDifference(since="1.4.0.0-PN", info="Cloudburst Nukkit always returns false for VILLAGE_HERO, we made the registration register the false value as default instead of this brute-force.")
    public boolean isVisible() {
        return this.show;
    }

    public Effect setVisible(boolean visible) {
        this.show = visible;
        return this;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public Effect setAmplifier(int amplifier) {
        this.amplifier = amplifier;
        return this;
    }

    public boolean isAmbient() {
        return this.ambient;
    }

    public Effect setAmbient(boolean ambient) {
        this.ambient = ambient;
        return this;
    }

    public boolean isBad() {
        return this.bad;
    }

    public boolean canTick() {
        switch (this.id) {
            case 19: 
            case 25: {
                int interval = 25 >> this.amplifier;
                if (interval > 0) {
                    return this.duration % interval == 0;
                }
                return true;
            }
            case 20: {
                int interval = 50 >> this.amplifier;
                if (interval > 0) {
                    return this.duration % interval == 0;
                }
                return true;
            }
            case 10: {
                int interval = 40 >> this.amplifier;
                if (interval > 0) {
                    return this.duration % interval == 0;
                }
                return true;
            }
        }
        return false;
    }

    public void applyEffect(Entity entity) {
        switch (this.id) {
            case 19: 
            case 25: {
                if (!(entity.getHealth() > 1.0f) && this.id != 25) break;
                entity.attack(new EntityDamageEvent(entity, EntityDamageEvent.DamageCause.MAGIC, 1.0f));
                break;
            }
            case 20: {
                entity.attack(new EntityDamageEvent(entity, EntityDamageEvent.DamageCause.MAGIC, 1.0f));
                break;
            }
            case 10: {
                if (!(entity.getHealth() < (float)entity.getMaxHealth())) break;
                entity.heal(new EntityRegainHealthEvent(entity, 1.0f, 2));
            }
        }
    }

    public int[] getColor() {
        return new int[]{this.color >> 16, this.color >> 8 & 0xFF, this.color & 0xFF};
    }

    public void setColor(int r, int g, int b) {
        this.color = ((r & 0xFF) << 16) + ((g & 0xFF) << 8) + (b & 0xFF);
    }

    public void add(Entity entity) {
        int add;
        Effect oldEffect = entity.getEffect(this.getId());
        if (oldEffect != null && (Math.abs(this.getAmplifier()) < Math.abs(oldEffect.getAmplifier()) || Math.abs(this.getAmplifier()) == Math.abs(oldEffect.getAmplifier()) && this.getDuration() < oldEffect.getDuration())) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            MobEffectPacket pk = new MobEffectPacket();
            pk.eid = entity.getId();
            pk.effectId = this.getId();
            pk.amplifier = this.getAmplifier();
            pk.particles = this.isVisible();
            pk.duration = this.getDuration();
            pk.eventId = oldEffect != null ? 2 : 1;
            player.dataPacket(pk);
            if (this.id == 1 && (oldEffect == null || oldEffect.amplifier != this.amplifier)) {
                if (oldEffect != null) {
                    player.setMovementSpeed(player.getMovementSpeed() / (1.0f + 0.2f * (float)(oldEffect.amplifier + 1)), false);
                }
                player.setMovementSpeed(player.getMovementSpeed() * (1.0f + 0.2f * (float)(this.amplifier + 1)));
            }
            if (this.id == 2 && (oldEffect == null || oldEffect.amplifier != this.amplifier)) {
                if (oldEffect != null) {
                    player.setMovementSpeed(player.getMovementSpeed() / (1.0f - 0.15f * (float)(oldEffect.amplifier + 1)), false);
                }
                player.setMovementSpeed(player.getMovementSpeed() * (1.0f - 0.15f * (float)(this.amplifier + 1)));
            }
        }
        if (this.id == 14) {
            entity.setDataFlag(Entity.DATA_FLAGS, Entity.DATA_FLAG_INVISIBLE, true);
            entity.setNameTagVisible(false);
        }
        if (this.id == 22 && (float)(add = (this.amplifier + 1) * 4) > entity.getAbsorption()) {
            entity.setAbsorption(add);
        }
    }

    public void remove(Entity entity) {
        if (entity instanceof Player) {
            MobEffectPacket pk = new MobEffectPacket();
            pk.eid = entity.getId();
            pk.effectId = this.getId();
            pk.eventId = 3;
            ((Player)entity).dataPacket(pk);
            if (this.id == 1) {
                ((Player)entity).setMovementSpeed(((Player)entity).getMovementSpeed() / (1.0f + 0.2f * (float)(this.amplifier + 1)));
            }
            if (this.id == 2) {
                ((Player)entity).setMovementSpeed(((Player)entity).getMovementSpeed() / (1.0f - 0.15f * (float)(this.amplifier + 1)));
            }
            if (this.id == 21) {
                float max = entity.getMaxHealth();
                float health = Math.min(entity.getHealth(), max);
                entity.setHealth(health);
            }
        }
        if (this.id == 14) {
            entity.setDataFlag(Entity.DATA_FLAGS, Entity.DATA_FLAG_INVISIBLE, false);
            entity.setNameTagVisible(true);
        }
        if (this.id == 22) {
            entity.setAbsorption(0.0f);
        }
    }

    public Effect clone() {
        try {
            return (Effect)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

