/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.resourcepacks;

import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.resourcepacks.AbstractResourcePack;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZippedResourcePack
extends AbstractResourcePack {
    @Generated
    private static final Logger log = LogManager.getLogger(ZippedResourcePack.class);
    private File file;
    private byte[] sha256 = null;

    @PowerNukkitDifference(info="Accepts resource packs with subfolder structure", since="1.4.0.0-PN")
    public ZippedResourcePack(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(Server.getInstance().getLanguage().translateString("nukkit.resources.zip.not-found", file.getName()));
        }
        this.file = file;
        try (ZipFile zip = new ZipFile(file);){
            ZipEntry entry = zip.getEntry("manifest.json");
            if (entry == null) {
                entry = zip.stream().filter(e -> e.getName().toLowerCase().endsWith("manifest.json") && !e.isDirectory()).filter(e -> {
                    File fe = new File(e.getName());
                    if (!fe.getName().equalsIgnoreCase("manifest.json")) {
                        return false;
                    }
                    return fe.getParent() == null || fe.getParentFile().getParent() == null;
                }).findFirst().orElseThrow(() -> new IllegalArgumentException(Server.getInstance().getLanguage().translateString("nukkit.resources.zip.no-manifest")));
            }
            this.manifest = new JsonParser().parse((Reader)new InputStreamReader(zip.getInputStream(entry), StandardCharsets.UTF_8)).getAsJsonObject();
        }
        catch (IOException e2) {
            log.error("An error occurred while loading the zipped resource pack {}", (Object)file, (Object)e2);
        }
        if (!this.verifyManifest()) {
            throw new IllegalArgumentException(Server.getInstance().getLanguage().translateString("nukkit.resources.zip.invalid-manifest"));
        }
    }

    @Override
    public int getPackSize() {
        return (int)this.file.length();
    }

    @Override
    public byte[] getSha256() {
        if (this.sha256 == null) {
            try {
                this.sha256 = MessageDigest.getInstance("SHA-256").digest(Files.readAllBytes(this.file.toPath()));
            }
            catch (Exception e) {
                log.error("Failed to parse the SHA-256 of the resource pack {}", (Object)this.file, (Object)e);
            }
        }
        return this.sha256;
    }

    @Override
    public byte[] getPackChunk(int off, int len) {
        byte[] chunk = this.getPackSize() - off > len ? new byte[len] : new byte[this.getPackSize() - off];
        try (FileInputStream fis = new FileInputStream(this.file);){
            fis.skip(off);
            fis.read(chunk);
        }
        catch (Exception e) {
            log.error("An error occurred while processing the resource pack {} at offset:{} and length:{}", (Object)this.file, (Object)off, (Object)len, (Object)e);
        }
        return chunk;
    }
}

