/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.scheduler;

import cn.nukkit.Server;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.scheduler.AsyncPool;
import cn.nukkit.scheduler.AsyncTask;
import cn.nukkit.scheduler.PluginTask;
import cn.nukkit.scheduler.Task;
import cn.nukkit.scheduler.TaskHandler;
import cn.nukkit.utils.PluginException;
import cn.nukkit.utils.Utils;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerScheduler {
    @Generated
    private static final Logger log = LogManager.getLogger(ServerScheduler.class);
    public static int WORKERS = 4;
    private final AsyncPool asyncPool;
    private final Queue<TaskHandler> pending = new ConcurrentLinkedQueue<TaskHandler>();
    private final Map<Integer, ArrayDeque<TaskHandler>> queueMap;
    private final Map<Integer, TaskHandler> taskMap;
    private final AtomicInteger currentTaskId = new AtomicInteger();
    private volatile int currentTick = -1;

    public ServerScheduler() {
        this.queueMap = new ConcurrentHashMap<Integer, ArrayDeque<TaskHandler>>();
        this.taskMap = new ConcurrentHashMap<Integer, TaskHandler>();
        this.asyncPool = new AsyncPool(Server.getInstance(), WORKERS);
    }

    public TaskHandler scheduleTask(Task task) {
        return this.addTask(task, 0, 0, false);
    }

    @Deprecated
    public TaskHandler scheduleTask(Runnable task) {
        return this.addTask(null, task, 0, 0, false);
    }

    public TaskHandler scheduleTask(Plugin plugin, Runnable task) {
        return this.addTask(plugin, task, 0, 0, false);
    }

    @Deprecated
    public TaskHandler scheduleTask(Runnable task, boolean asynchronous) {
        return this.addTask(null, task, 0, 0, asynchronous);
    }

    public TaskHandler scheduleTask(Plugin plugin, Runnable task, boolean asynchronous) {
        return this.addTask(plugin, task, 0, 0, asynchronous);
    }

    @Deprecated
    public TaskHandler scheduleAsyncTask(AsyncTask task) {
        return this.addTask(null, task, 0, 0, true);
    }

    public TaskHandler scheduleAsyncTask(Plugin plugin, AsyncTask task) {
        return this.addTask(plugin, task, 0, 0, true);
    }

    @Deprecated
    public void scheduleAsyncTaskToWorker(AsyncTask task, int worker) {
        this.scheduleAsyncTask(task);
    }

    public int getAsyncTaskPoolSize() {
        return this.asyncPool.getCorePoolSize();
    }

    public void increaseAsyncTaskPoolSize(int newSize) {
        throw new UnsupportedOperationException("Cannot increase a working pool size.");
    }

    public TaskHandler scheduleDelayedTask(Task task, int delay) {
        return this.addTask(task, delay, 0, false);
    }

    public TaskHandler scheduleDelayedTask(Task task, int delay, boolean asynchronous) {
        return this.addTask(task, delay, 0, asynchronous);
    }

    @Deprecated
    public TaskHandler scheduleDelayedTask(Runnable task, int delay) {
        return this.addTask(null, task, delay, 0, false);
    }

    public TaskHandler scheduleDelayedTask(Plugin plugin, Runnable task, int delay) {
        return this.addTask(plugin, task, delay, 0, false);
    }

    @Deprecated
    public TaskHandler scheduleDelayedTask(Runnable task, int delay, boolean asynchronous) {
        return this.addTask(null, task, delay, 0, asynchronous);
    }

    public TaskHandler scheduleDelayedTask(Plugin plugin, Runnable task, int delay, boolean asynchronous) {
        return this.addTask(plugin, task, delay, 0, asynchronous);
    }

    @Deprecated
    public TaskHandler scheduleRepeatingTask(Runnable task, int period) {
        return this.addTask(null, task, 0, period, false);
    }

    public TaskHandler scheduleRepeatingTask(Plugin plugin, Runnable task, int period) {
        return this.addTask(plugin, task, 0, period, false);
    }

    @Deprecated
    public TaskHandler scheduleRepeatingTask(Runnable task, int period, boolean asynchronous) {
        return this.addTask(null, task, 0, period, asynchronous);
    }

    public TaskHandler scheduleRepeatingTask(Plugin plugin, Runnable task, int period, boolean asynchronous) {
        return this.addTask(plugin, task, 0, period, asynchronous);
    }

    public TaskHandler scheduleRepeatingTask(Task task, int period) {
        return this.addTask(task, 0, period, false);
    }

    public TaskHandler scheduleRepeatingTask(Task task, int period, boolean asynchronous) {
        return this.addTask(task, 0, period, asynchronous);
    }

    public TaskHandler scheduleDelayedRepeatingTask(Task task, int delay, int period) {
        return this.addTask(task, delay, period, false);
    }

    public TaskHandler scheduleDelayedRepeatingTask(Task task, int delay, int period, boolean asynchronous) {
        return this.addTask(task, delay, period, asynchronous);
    }

    @Deprecated
    public TaskHandler scheduleDelayedRepeatingTask(Runnable task, int delay, int period) {
        return this.addTask(null, task, delay, period, false);
    }

    public TaskHandler scheduleDelayedRepeatingTask(Plugin plugin, Runnable task, int delay, int period) {
        return this.addTask(plugin, task, delay, period, false);
    }

    @Deprecated
    public TaskHandler scheduleDelayedRepeatingTask(Runnable task, int delay, int period, boolean asynchronous) {
        return this.addTask(null, task, delay, period, asynchronous);
    }

    public TaskHandler scheduleDelayedRepeatingTask(Plugin plugin, Runnable task, int delay, int period, boolean asynchronous) {
        return this.addTask(plugin, task, delay, period, asynchronous);
    }

    public void cancelTask(int taskId) {
        if (this.taskMap.containsKey(taskId)) {
            try {
                this.taskMap.remove(taskId).cancel();
            }
            catch (RuntimeException ex) {
                log.fatal("Exception while invoking onCancel", (Throwable)ex);
            }
        }
    }

    public void cancelTask(Plugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("Plugin cannot be null!");
        }
        for (Map.Entry<Integer, TaskHandler> entry : this.taskMap.entrySet()) {
            TaskHandler taskHandler = entry.getValue();
            if (taskHandler.getPlugin() != null && !plugin.equals(taskHandler.getPlugin())) continue;
            try {
                taskHandler.cancel();
            }
            catch (RuntimeException ex) {
                log.fatal("Exception while invoking onCancel", (Throwable)ex);
            }
        }
    }

    public void cancelAllTasks() {
        for (Map.Entry<Integer, TaskHandler> entry : this.taskMap.entrySet()) {
            try {
                entry.getValue().cancel();
            }
            catch (RuntimeException ex) {
                log.fatal("Exception while invoking onCancel", (Throwable)ex);
            }
        }
        this.taskMap.clear();
        this.queueMap.clear();
        this.currentTaskId.set(0);
    }

    public boolean isQueued(int taskId) {
        return this.taskMap.containsKey(taskId);
    }

    private TaskHandler addTask(Task task, int delay, int period, boolean asynchronous) {
        return this.addTask(task instanceof PluginTask ? (Plugin)((PluginTask)task).getOwner() : null, task, delay, period, asynchronous);
    }

    private TaskHandler addTask(Plugin plugin, Runnable task, int delay, int period, boolean asynchronous) {
        if (plugin != null && plugin.isDisabled()) {
            throw new PluginException("Plugin '" + plugin.getName() + "' attempted to register a task while disabled.");
        }
        if (delay < 0 || period < 0) {
            throw new PluginException("Attempted to register a task with negative delay or period.");
        }
        TaskHandler taskHandler = new TaskHandler(plugin, task, this.nextTaskId(), asynchronous);
        taskHandler.setDelay(delay);
        taskHandler.setPeriod(period);
        taskHandler.setNextRunTick(taskHandler.isDelayed() ? this.currentTick + taskHandler.getDelay() : this.currentTick);
        if (task instanceof Task) {
            ((Task)task).setHandler(taskHandler);
        }
        this.pending.offer(taskHandler);
        this.taskMap.put(taskHandler.getTaskId(), taskHandler);
        return taskHandler;
    }

    public void mainThreadHeartbeat(int currentTick) {
        TaskHandler task;
        while ((task = this.pending.poll()) != null) {
            int tick = Math.max(currentTick, task.getNextRunTick());
            ArrayDeque<TaskHandler> queue = Utils.getOrCreate(this.queueMap, ArrayDeque.class, tick);
            queue.add(task);
        }
        if (currentTick - this.currentTick > this.queueMap.size()) {
            for (Map.Entry<Integer, ArrayDeque<TaskHandler>> entry : this.queueMap.entrySet()) {
                int tick = entry.getKey();
                if (tick > currentTick) continue;
                this.runTasks(tick);
            }
        } else {
            for (int i = this.currentTick + 1; i <= currentTick; ++i) {
                this.runTasks(currentTick);
            }
        }
        this.currentTick = currentTick;
        AsyncTask.collectTask();
    }

    private void runTasks(int currentTick) {
        ArrayDeque<TaskHandler> queue = this.queueMap.remove(currentTick);
        if (queue != null) {
            for (TaskHandler taskHandler : queue) {
                if (taskHandler.isCancelled()) {
                    this.taskMap.remove(taskHandler.getTaskId());
                    continue;
                }
                if (taskHandler.isAsynchronous()) {
                    this.asyncPool.execute(taskHandler.getTask());
                } else {
                    taskHandler.timing.startTiming();
                    try {
                        taskHandler.run(currentTick);
                    }
                    catch (Throwable e) {
                        log.fatal("Could not execute taskHandler {}", (Object)taskHandler.getTaskId(), (Object)e);
                    }
                    taskHandler.timing.stopTiming();
                }
                if (taskHandler.isRepeating()) {
                    taskHandler.setNextRunTick(currentTick + taskHandler.getPeriod());
                    this.pending.offer(taskHandler);
                    continue;
                }
                try {
                    TaskHandler removed = this.taskMap.remove(taskHandler.getTaskId());
                    if (removed == null) continue;
                    removed.cancel();
                }
                catch (RuntimeException ex) {
                    log.fatal("Exception while invoking onCancel", (Throwable)ex);
                }
            }
        }
    }

    public int getQueueSize() {
        int size = this.pending.size();
        for (ArrayDeque<TaskHandler> queue : this.queueMap.values()) {
            size += queue.size();
        }
        return size;
    }

    private int nextTaskId() {
        return this.currentTaskId.incrementAndGet();
    }
}

