/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class HumanStringComparator
implements Comparator<String> {
    private static final HumanStringComparator INSTANCE = new HumanStringComparator();
    private static final int LEFT = -1;
    private static final int RIGHT = 1;
    private static final int EQUALS = 0;
    private static final String SYMBOLS = "[:.;,/\\]{}|=";

    @Override
    public int compare(String o1, String o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        List<String> l1 = this.splitSymbols(this.combineNegativeSign(this.split(o1)));
        List<String> l2 = this.splitSymbols(this.combineNegativeSign(this.split(o2)));
        return this.compare(l1, l2);
    }

    private List<String> splitSymbols(List<String> list) {
        boolean changed = false;
        ArrayList<String> result = list;
        int size = list.size();
        for (int i = size - 1; i >= 0; --i) {
            int length;
            String str = result.get(i);
            int lastPart = length = str.length();
            for (int j = length - 1; j >= 0; --j) {
                int indexToAddLast;
                char c = str.charAt(j);
                if (SYMBOLS.indexOf(c) == -1) continue;
                if (!changed) {
                    result = list instanceof ArrayList ? list : new ArrayList<String>(list);
                    changed = true;
                }
                if (j > 0) {
                    result.set(i, str.substring(0, j));
                    result.add(i + 1, Character.toString(c));
                    indexToAddLast = i + 2;
                } else {
                    result.set(i, Character.toString(c));
                    indexToAddLast = i + 1;
                }
                if (j + 2 <= length) {
                    result.add(indexToAddLast, str.substring(j + 1, lastPart));
                }
                lastPart = j;
            }
        }
        return result;
    }

    @Override
    private int compare(List<String> l1, List<String> l2) {
        int len1 = l1.size();
        int len2 = l2.size();
        int minLen = Math.min(len1, len2);
        for (int i = 0; i < minLen; ++i) {
            String commonPart2;
            String str1 = l1.get(i);
            String str2 = l2.get(i);
            int strLen1 = str1.length();
            int strLen2 = str2.length();
            assert (strLen1 > 0);
            assert (strLen2 > 0);
            boolean isNum1 = Character.isDigit(str1.charAt(strLen1 - 1));
            boolean isNum2 = Character.isDigit(str2.charAt(strLen2 - 1));
            if (isNum1) {
                if (isNum2) {
                    int i2;
                    int i1 = Integer.parseInt(str1);
                    int result = Integer.compare(i1, i2 = Integer.parseInt(str2));
                    if (result != 0) {
                        return result;
                    }
                    result = Integer.compare(strLen1, strLen2);
                    if (result == 0) continue;
                    return result;
                }
                return 1;
            }
            if (isNum2) {
                return -1;
            }
            if (strLen1 == strLen2) {
                int result = str1.compareTo(str2);
                if (result == 0) continue;
                return result;
            }
            int minStrLen = Math.min(strLen1, strLen2);
            String commonPart1 = str1.substring(0, minStrLen);
            int result = commonPart1.compareTo(commonPart2 = str2.substring(0, minStrLen));
            if (result != 0) {
                return result;
            }
            if (strLen1 < strLen2) {
                if (this.detectOmittedNumber(l1, len1, i, str2, strLen2, minStrLen, commonPart1)) {
                    return 1;
                }
            } else if (this.detectOmittedNumber(l2, len2, i, str1, strLen1, minStrLen, commonPart2)) {
                return -1;
            }
            return Integer.compare(strLen1, strLen2);
        }
        return Integer.compare(len1, len2);
    }

    private boolean detectOmittedNumber(List<String> l1, int len1, int i, String str2, int strLen2, int minStrLen, String commonPart1) {
        int afterNextLen1;
        String next1 = len1 > i + 1 ? l1.get(i + 1) : null;
        int nextLen1 = next1 == null ? 0 : next1.length();
        boolean isDigit1 = next1 != null && Character.isDigit(next1.charAt(nextLen1 - 1));
        String afterNext1 = isDigit1 && len1 > i + 2 ? l1.get(i + 2) : null;
        int n = afterNextLen1 = afterNext1 != null ? afterNext1.length() : 0;
        if (afterNextLen1 > 0) {
            String combined = commonPart1 + afterNext1.substring(0, Math.min(afterNextLen1, strLen2 - minStrLen));
            String comparingWith = str2;
            return combined.equals(comparingWith);
        }
        return false;
    }

    private List<String> combineNegativeSign(List<String> list) {
        int size = list.size();
        if (size < 2) {
            return list;
        }
        for (int i = size - 1; i > 0; --i) {
            String str2;
            int strLen2;
            String str1 = list.get(i);
            int strLen1 = str1.length();
            if (strLen1 <= 0 || !Character.isDigit(str1.charAt(strLen1 - 1)) || (strLen2 = (str2 = list.get(i - 1)).length()) <= 0 || str2.charAt(strLen2 - 1) != '-') continue;
            list.set(i, "-" + str1);
            if (strLen2 == 1) {
                list.remove(i - 1);
                i -= 2;
                continue;
            }
            list.set(i - 1, str2.substring(0, strLen2 - 1));
            --i;
        }
        return list;
    }

    @Nonnull
    private List<String> split(String str) {
        int length = str.length();
        if (length == 0) {
            return Collections.emptyList();
        }
        if (length == 1) {
            return Collections.singletonList(str);
        }
        List<String> list = null;
        boolean wasDigit = false;
        int start = -1;
        for (int i = 0; i < length; ++i) {
            if (Character.isDigit(str.charAt(i))) {
                if (!wasDigit && start == -1) {
                    start = i;
                    wasDigit = true;
                    continue;
                }
                if (wasDigit) continue;
                if (list == null) {
                    list = new ArrayList<String>(2);
                }
                list.add(str.substring(start, i));
                start = i;
                wasDigit = true;
                continue;
            }
            if (wasDigit) {
                if (list == null) {
                    list = new ArrayList<String>(2);
                }
                list.add(str.substring(start, i));
                start = i;
                wasDigit = false;
                continue;
            }
            if (start != -1) continue;
            start = i;
        }
        String substring = str.substring(start, length);
        if (list == null) {
            list = Collections.singletonList(substring);
        } else {
            list.add(substring);
        }
        return list;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static HumanStringComparator getInstance() {
        return INSTANCE;
    }
}

