/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparent;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.IntBlockProperty;
import cn.nukkit.item.Item;
import cn.nukkit.level.particle.DestroyBlockParticle;
import cn.nukkit.level.particle.Particle;
import cn.nukkit.math.BlockFace;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BlockChorusFlower
extends BlockTransparent {
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final IntBlockProperty AGE = new IntBlockProperty("age", false, 5);
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(AGE);

    @Override
    public int getId() {
        return 200;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public String getName() {
        return "Chorus Flower";
    }

    @Override
    public double getHardness() {
        return 0.4;
    }

    @Override
    public double getResistance() {
        return 0.4;
    }

    @Override
    public int getToolType() {
        return 0;
    }

    private boolean isPositionValid() {
        Block down = this.down();
        if (down.getId() == 240 || down.getId() == 121) {
            return true;
        }
        if (down.getId() != 0) {
            return false;
        }
        boolean foundPlant = false;
        for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
            Block side = this.getSide(face);
            if (side.getId() != 240) continue;
            if (foundPlant) {
                return false;
            }
            foundPlant = true;
        }
        return foundPlant;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (!this.isPositionValid()) {
                this.level.scheduleUpdate(this, 1);
                return type;
            }
        } else if (type == 3) {
            Map<Integer, Player> players = this.level.getChunkPlayers((int)this.x >> 4, (int)this.z >> 4);
            this.level.addParticle((Particle)new DestroyBlockParticle(this, this), players.values());
            this.level.setBlock(this, Block.get(0));
            return type;
        }
        return 0;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        if (!this.isPositionValid()) {
            return false;
        }
        return super.place(item, block, target, face, fx, fy, fz, player);
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{this.toItem()};
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }
}

