/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFallableMeta;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.DyeColor;
import javax.annotation.Nonnull;

@PowerNukkitDifference(info="Extends BlockFallableMeta instead of BlockFallable")
public class BlockConcretePowder
extends BlockFallableMeta {
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperties PROPERTIES = CommonBlockProperties.COLOR_BLOCK_PROPERTIES;

    public BlockConcretePowder() {
    }

    public BlockConcretePowder(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 237;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public String getName() {
        return this.getDyeColor().getName() + " Concrete Powder";
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public int getToolType() {
        return 2;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            super.onUpdate(1);
            for (int side = 1; side <= 5; ++side) {
                Block block = this.getSide(BlockFace.fromIndex(side));
                if (block.getId() != 8 && block.getId() != 9) continue;
                this.level.setBlock((Vector3)this, Block.get(236, this.getDamage()), true, true);
            }
            return 1;
        }
        return 0;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block b, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        boolean concrete = false;
        for (int side = 1; side <= 5; ++side) {
            Block block = this.getSide(BlockFace.fromIndex(side));
            if (block.getId() != 8 && block.getId() != 9) continue;
            concrete = true;
            break;
        }
        if (concrete) {
            this.level.setBlock((Vector3)this, Block.get(236, this.getDamage()), true, true);
        } else {
            this.level.setBlock((Vector3)this, this, true, true);
        }
        return true;
    }

    @Override
    public BlockColor getColor() {
        return this.getDyeColor().getColor();
    }

    public DyeColor getDyeColor() {
        return this.getPropertyValue(CommonBlockProperties.COLOR);
    }
}

